/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.core.tests.internal.runtime.TestJSRuntimeProvider1;
import org.eclipse.wst.jsdt.core.tests.internal.runtime.TestRuntimeType1;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JSRuntimeManagerTest {
    public static final String RUNTIME_TEST_TYPE_ID = "js.runtime.test.type";
    public static final String FAKE_RUNTIME_ID = "new-test-runtime-id";
    public static final String FAKE_RUNTIME_NAME = "new-test-runtime-name";
    public static final String FAKE_RUNTIME_LOCATION = "/home/new/test/runtime/location";
    public static final String FAKE_RUNTIME_ARGS = "arg1, arg2";
    public static final String UNREGISTERED_RUNTIME_TYPE = "UNREGISTERED_RUNTIME_TYPE";

    @Before
    public void clearManager() {
        JSRuntimeManager.reset();
    }

    private IJSRuntimeInstall createFakeRuntime() {
        TestRuntimeType1 rt1 = new TestRuntimeType1();
        JSRuntimeWorkingCopy runtimeInstall = new JSRuntimeWorkingCopy((IJSRuntimeType)rt1, FAKE_RUNTIME_ID);
        runtimeInstall.setName(FAKE_RUNTIME_NAME);
        runtimeInstall.setInstallLocation(new File(FAKE_RUNTIME_LOCATION));
        runtimeInstall.setJSRuntimeArguments(FAKE_RUNTIME_ARGS);
        return runtimeInstall;
    }

    @Test
    public void test_01_managerDefaultContents() {
        IJSRuntimeInstall jsri1 = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        Assert.assertNotNull((Object)jsri1);
        Assert.assertEquals((Object)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1, (Object)jsri1.getId());
        IJSRuntimeInstall jsri2 = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2);
        Assert.assertNotNull((Object)jsri2);
        Assert.assertEquals((Object)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2, (Object)jsri2.getId());
        Object[] storedRuntimes = JSRuntimeManager.getJSRuntimeInstallsByType((String)RUNTIME_TEST_TYPE_ID);
        Assert.assertArrayEquals((Object[])new IJSRuntimeInstall[]{jsri1, jsri2}, (Object[])storedRuntimes);
    }

    @Test
    public void test_02_managerValidAdd() {
        IJSRuntimeInstall runtimeInstall = this.createFakeRuntime();
        JSRuntimeManager.addJSRuntimeInstall((IJSRuntimeInstall)runtimeInstall);
        IJSRuntimeInstall storedRuntime = JSRuntimeManager.getJSRuntimeInstall((String)FAKE_RUNTIME_ID);
        Assert.assertNotNull((String)"Manager must return a valid runtime for this ID.", (Object)runtimeInstall);
        Assert.assertEquals((Object)FAKE_RUNTIME_ID, (Object)storedRuntime.getId());
        Assert.assertEquals((Object)FAKE_RUNTIME_NAME, (Object)storedRuntime.getName());
        Assert.assertEquals((Object)FAKE_RUNTIME_LOCATION, (Object)storedRuntime.getInstallLocation().getAbsolutePath());
        Assert.assertArrayEquals((Object[])FAKE_RUNTIME_ARGS.split(" "), (Object[])storedRuntime.getJSRuntimeArguments());
        Assert.assertEquals((Object)RUNTIME_TEST_TYPE_ID, (Object)storedRuntime.getRuntimeType().getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_03_managerInvalidAdd_DuplicateRuntime() {
        IJSRuntimeInstall runtimeInstall = this.createFakeRuntime();
        JSRuntimeManager.addJSRuntimeInstall((IJSRuntimeInstall)runtimeInstall);
        JSRuntimeManager.addJSRuntimeInstall((IJSRuntimeInstall)runtimeInstall);
    }

    @Test
    public void test_04_managerClear() {
        IJSRuntimeInstall runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        Assert.assertNotNull((String)"Runtime install must be present in JSRuntimeManager.", (Object)runtimeInstall);
        runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2);
        Assert.assertNotNull((String)"Runtime install must be present in JSRuntimeManager.", (Object)runtimeInstall);
        JSRuntimeManager.clear();
        runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        Assert.assertNull((String)"Manager must have no runtime ids.", (Object)runtimeInstall);
        runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2);
        Assert.assertNull((String)"Manager must have no runtime ids.", (Object)runtimeInstall);
    }

    @Test
    public void test_05_managerUpdate() {
        String updatedPrefix = "UPDATED";
        String updatedArgs = String.valueOf(updatedPrefix) + "arg1 " + updatedPrefix + "arg 2";
        IJSRuntimeInstall install = this.createFakeRuntime();
        JSRuntimeManager.addJSRuntimeInstall((IJSRuntimeInstall)install);
        install.setName(String.valueOf(updatedPrefix) + FAKE_RUNTIME_NAME);
        install.setInstallLocation(new File(String.valueOf(updatedPrefix) + FAKE_RUNTIME_LOCATION));
        install.setJSRuntimeArguments(updatedArgs);
        JSRuntimeManager.updateJSRuntimeInstall((IJSRuntimeInstall)install);
        IJSRuntimeInstall updatedRuntime = JSRuntimeManager.getJSRuntimeInstall((String)FAKE_RUNTIME_ID);
        Assert.assertEquals((Object)FAKE_RUNTIME_ID, (Object)updatedRuntime.getId());
        Assert.assertEquals((Object)(String.valueOf(updatedPrefix) + FAKE_RUNTIME_NAME), (Object)updatedRuntime.getName());
        Assert.assertEquals((Object)new File(String.valueOf(updatedPrefix) + FAKE_RUNTIME_LOCATION).getAbsolutePath(), (Object)updatedRuntime.getInstallLocation().getAbsolutePath());
        Assert.assertArrayEquals((Object[])updatedArgs.split(" "), (Object[])updatedRuntime.getJSRuntimeArguments());
        Assert.assertEquals((Object)RUNTIME_TEST_TYPE_ID, (Object)updatedRuntime.getRuntimeType().getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_06_managerInvalidUpdate() {
        IJSRuntimeInstall install = this.createFakeRuntime();
        JSRuntimeManager.updateJSRuntimeInstall((IJSRuntimeInstall)install);
    }

    @Test
    public void test_07_managerRemove() {
        IJSRuntimeInstall runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        Assert.assertNotNull((String)"JS Runtime Install missing.", (Object)runtimeInstall);
        JSRuntimeManager.removeJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        runtimeInstall = JSRuntimeManager.getJSRuntimeInstall((String)TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        Assert.assertNull((String)"JS Runtime unsuccessfully removed.", (Object)runtimeInstall);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_08_managerInvalidRemove() {
        JSRuntimeManager.removeJSRuntimeInstall((String)FAKE_RUNTIME_ID);
    }

    @Test
    public void test_09_obtainRuntimeInstallsByType() {
        IJSRuntimeInstall install = this.createFakeRuntime();
        JSRuntimeManager.addJSRuntimeInstall((IJSRuntimeInstall)install);
        IJSRuntimeInstall[] installs = JSRuntimeManager.getJSRuntimeInstallsByType((String)RUNTIME_TEST_TYPE_ID);
        Assert.assertEquals((String)"Manager has more installs than expected.", (long)3L, (long)installs.length);
        List<String> expectedIds = Arrays.asList(TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1, TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2, FAKE_RUNTIME_ID);
        ArrayList<String> storedIds = new ArrayList<String>();
        int i = 0;
        while (i < installs.length) {
            storedIds.add(installs[i].getId());
            ++i;
        }
        Assert.assertTrue((boolean)expectedIds.containsAll(storedIds));
        Assert.assertTrue((boolean)storedIds.containsAll(expectedIds));
        installs = JSRuntimeManager.getJSRuntimeInstallsByType((String)UNREGISTERED_RUNTIME_TYPE);
        Assert.assertEquals((String)"No installs must be found for unknown runtime type.", (long)0L, (long)installs.length);
    }
}

