/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.core.util.SequenceReader;

public class SequenceReaderTests
extends TestCase {
    public void testSingleReaderSequence() throws IOException {
        Reader[] readers = new Reader[]{new StringReader("Ready")};
        StringBuffer buff = new StringBuffer();
        try (SequenceReader sequenceReader = new SequenceReader(readers);){
            int c = sequenceReader.read();
            while (c != -1) {
                buff.append((char)c);
                c = sequenceReader.read();
            }
        }
        SequenceReaderTests.assertEquals((String)"Ready", (String)buff.toString());
    }

    public void testTripleReaderSequence() throws IOException {
        Reader[] readers = new Reader[]{new StringReader("Ready"), new StringReader("Set"), new StringReader("Go")};
        StringBuffer buff = new StringBuffer();
        try (SequenceReader sequenceReader = new SequenceReader(readers);){
            int c = sequenceReader.read();
            while (c != -1) {
                buff.append((char)c);
                c = sequenceReader.read();
            }
        }
        SequenceReaderTests.assertEquals((String)"ReadySetGo", (String)buff.toString());
    }

    public void testEmptyReader() throws IOException {
        Reader[] readers = new Reader[]{new StringReader("")};
        StringBuffer buff = new StringBuffer();
        try (SequenceReader sequenceReader = new SequenceReader(readers);){
            int c = sequenceReader.read();
            while (c != -1) {
                buff.append((char)c);
                c = sequenceReader.read();
            }
        }
        SequenceReaderTests.assertEquals((String)"something was read from an empty reader", (int)0, (int)buff.length());
    }

    public void testEmptySequence() throws IOException {
        Reader[] readers = new Reader[]{};
        StringBuffer buff = new StringBuffer();
        try (SequenceReader sequenceReader = new SequenceReader(readers);){
            int c = sequenceReader.read();
            while (c != -1) {
                buff.append((char)c);
                c = sequenceReader.read();
            }
        }
        SequenceReaderTests.assertEquals((String)"something was read from nothing", (int)0, (int)buff.length());
    }

    public void testBufferedTripleReaderSequence() throws IOException {
        Reader[] readers = new Reader[]{new StringReader("Ready"), new StringReader("Set"), new StringReader("Go")};
        StringBuffer buff = new StringBuffer();
        try (BufferedReader sequenceReader = new BufferedReader((Reader)new SequenceReader(readers));){
            int c = ((Reader)sequenceReader).read();
            while (c != -1) {
                buff.append((char)c);
                c = ((Reader)sequenceReader).read();
            }
        }
        SequenceReaderTests.assertEquals((String)"ReadySetGo", (String)buff.toString());
    }
}

