/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.xml.ui.tests.XMLDiff;
import org.eclipse.wst.xml.ui.tests.XMLUITestsPlugin;

public class TestNewXMLGenerator
extends TestCase {
    static String PLUGIN_ABSOLUTE_PATH;
    static final String SCHEMA_1 = "Schema1";
    static final String SCHEMA_2 = "Schema2";
    static final String ROOT_ELEMENT_1 = "GolfCountryClub";
    static final String ROOT_ELEMENT_2 = "BillInfo";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNXG_bare() {
        this.runOneTest(0, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_optAttr() {
        this.runOneTest(1, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_optElem() {
        this.runOneTest(2, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_optFirst() {
        this.runOneTest(20, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_optTextNodes() {
        this.runOneTest(8, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_all() {
        this.runOneTest(31, ROOT_ELEMENT_1, SCHEMA_1);
    }

    public void testNXG_nsQualified() {
        this.runOneTest(31, ROOT_ELEMENT_2, SCHEMA_2);
    }

    private void runOneTest(int buildPolicy, String rootElement, String xsdUriFile) {
        try {
            PLUGIN_ABSOLUTE_PATH = XMLUITestsPlugin.getInstallURL();
            String uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/" + xsdUriFile + ".xsd";
            String[] errorInfo = new String[2];
            CMDocument cmd = NewXMLGenerator.createCMDocument((String)uri, (String[])errorInfo);
            NewXMLGenerator generator = new NewXMLGenerator(uri, cmd);
            String id = String.valueOf(xsdUriFile) + "-" + rootElement + "-" + buildPolicy;
            String fileNameResult = String.valueOf(PLUGIN_ABSOLUTE_PATH) + "testresources/Tested-" + id + ".xml";
            File nFile = new File(fileNameResult);
            if (!nFile.exists()) {
                nFile.createNewFile();
            }
            String fileNameCompare = String.valueOf(PLUGIN_ABSOLUTE_PATH) + "testresources/Compare-" + id + ".xml";
            generator.setBuildPolicy(buildPolicy);
            generator.setRootElementName(rootElement);
            generator.setDefaultSystemId(String.valueOf(xsdUriFile) + ".xsd");
            generator.createNamespaceInfoList();
            generator.createXMLDocument(fileNameResult);
            XMLDiff differ = new XMLDiff();
            TestNewXMLGenerator.assertTrue((String)"The XML files are not identical.", (boolean)differ.diff(fileNameCompare, fileNameResult, "XML"));
            this.remove(nFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void remove(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.remove(children[i]);
                ++i;
            }
        }
        file.delete();
    }
}

