/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.document;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentTextStore;

public class TestRegionMatches
extends TestCase {
    public TestRegionMatches() {
    }

    public TestRegionMatches(String name) {
        super(name);
    }

    public void testRegionMatches1() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        structuredDocumentTextStore.set("testing123");
        boolean result = structuredDocumentTextStore.regionMatches(0, 1, "t");
        TestRegionMatches.assertEquals((boolean)true, (boolean)result);
    }

    public void testRegionMatches2() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        structuredDocumentTextStore.set("testing123");
        boolean result = structuredDocumentTextStore.regionMatches(0, 2, "t");
        TestRegionMatches.assertEquals((boolean)false, (boolean)result);
    }

    public void testRegionMatches3() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        structuredDocumentTextStore.set("testing123");
        boolean result = structuredDocumentTextStore.regionMatches(7, 3, "123");
        TestRegionMatches.assertEquals((boolean)true, (boolean)result);
    }

    public void testRegionMatches4() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        structuredDocumentTextStore.set("testing123");
        boolean result = structuredDocumentTextStore.regionMatches(8, 3, "234");
        TestRegionMatches.assertEquals((boolean)false, (boolean)result);
    }

    public void testRegionMatchesIgnoreCase() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        String test = "testing123";
        String compare = "TeSting123";
        structuredDocumentTextStore.set(test);
        boolean result = structuredDocumentTextStore.regionMatches(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)false, (boolean)result);
        result = structuredDocumentTextStore.regionMatchesIgnoreCase(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)true, (boolean)result);
    }

    public void testRegionMatchesIgnoreCase2() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        String test = "test\u0130ng123";
        String compare = "TeStIng123";
        structuredDocumentTextStore.set(test);
        boolean result = structuredDocumentTextStore.regionMatches(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)false, (boolean)result);
        result = structuredDocumentTextStore.regionMatchesIgnoreCase(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)true, (boolean)result);
    }

    public void testRegionMatchesIgnoreCase3() {
        StructuredDocumentTextStore structuredDocumentTextStore = new StructuredDocumentTextStore();
        String test = "testing123";
        String compare = "TeSt\u0131ng123";
        structuredDocumentTextStore.set(test);
        boolean result = structuredDocumentTextStore.regionMatches(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)false, (boolean)result);
        result = structuredDocumentTextStore.regionMatchesIgnoreCase(0, test.length(), compare);
        TestRegionMatches.assertEquals((boolean)true, (boolean)result);
    }
}

