/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.debug.core.tests.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.debug.core.tests.AbstractBreakpointTest;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;

public class LineBreakpointTests
extends AbstractBreakpointTest {
    public LineBreakpointTests() {
        super("Line breakpoint tests");
    }

    public void testCreateBareLine() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test1.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test1.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test1.js", (boolean)source.exists());
        String path = source.getFullPath().toString();
        this.createLineBreakpoints(path, new int[]{11, 12, 14, 17});
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        LineBreakpointTests.assertEquals((String)"there should have been 4 JS line breakpoints in test1.js", (int)breakpoints.length, (int)4);
    }

    public void testToggleBareLine() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test1.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test1.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test1.js", (boolean)source.exists());
        IEditorPart editor = this.openEditor(source);
        LineBreakpointTests.assertNotNull((String)"the editor part for test1.js could not be created", (Object)editor);
        IBreakpoint bp = this.toggleBreakpoint(editor, 11);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 11 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 12);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 12 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 14);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 14 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 17);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 17 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 11);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 11 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 12);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 12 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 14);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 14 in test1.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 17);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 17 in test1.js", (Object)bp);
        LineBreakpointTests.assertEquals((String)"Should be no JS breakpoints left", (int)this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model").length, (int)0);
    }

    public void testCreateSimpleFunctionClosure() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test2.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test2.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test2.js", (boolean)source.exists());
        String path = source.getFullPath().toString();
        this.createLineBreakpoints(path, new int[]{13, 15, 19, 21, 25, 27, 31, 33});
        IBreakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        LineBreakpointTests.assertEquals((String)"there should have been 8 JS line breakpoints in test1.js", (int)breakpoints.length, (int)8);
    }

    public void testToggleSimpleFunctionClosure() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test2.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test2.js could not be found", (Object)source);
        IEditorPart editor = this.openEditor(source);
        LineBreakpointTests.assertNotNull((String)"the editor part for test2.js could not be created", (Object)editor);
        IBreakpoint bp = this.toggleBreakpoint(editor, 13);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 13 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 15);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 15 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 19);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 19 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 21);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 21 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 25);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 25 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 27);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 27 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 31);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 31 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 33);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 33 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 13);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 11 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 15);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 15 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 19);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 19 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 21);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 21 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 25);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 25 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 27);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 27 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 31);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 31 in test2.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 33);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 33 in test2.js", (Object)bp);
        LineBreakpointTests.assertEquals((String)"Should be no JS breakpoints left", (int)this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model").length, (int)0);
    }

    public void testCreateBug313013() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test3.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test3.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test3.js", (boolean)source.exists());
        this.createLineBreakpoints(source.getFullPath().toString(), new int[]{13, 16, 20, 25});
        IBreakpoint[] bps = this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        LineBreakpointTests.assertEquals((String)"there should have been 4 JS line breakpoints in test3.js", (int)bps.length, (int)4);
    }

    public void testToggleBug313013() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test3.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test3.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test3.js", (boolean)source.exists());
        IEditorPart editor = this.openEditor(source);
        LineBreakpointTests.assertNotNull((String)"the editor part for test3.js could not be created", (Object)editor);
        IBreakpoint bp = this.toggleBreakpoint(editor, 13);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 13 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 16);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 16 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 20);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 20 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 25);
        LineBreakpointTests.assertNotNull((String)"could not toggle breakpoint on line 25 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 13);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 13 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 16);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 16 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 20);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 20 in test3.js", (Object)bp);
        bp = this.toggleBreakpoint(editor, 25);
        LineBreakpointTests.assertNull((String)"could not toggle to remove breakpoint on line 25 in test3.js", (Object)bp);
        LineBreakpointTests.assertEquals((String)"Should be no JS breakpoints left", (int)this.getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model").length, (int)0);
    }

    public void testToggleValidatedLocIfEndBrace() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test4.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test4.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test4.js", (boolean)source.exists());
        IEditorPart editor = this.openEditor(source);
        LineBreakpointTests.assertNotNull((String)"the editor part for test4.js could not be created", (Object)editor);
        IBreakpoint bp = this.toggleBreakpoint(editor, 13);
        LineBreakpointTests.assertTrue((String)"the breakpoint must be a line breakpoint", (boolean)(bp instanceof IJavaScriptLineBreakpoint));
        IJavaScriptLineBreakpoint lbp = (IJavaScriptLineBreakpoint)bp;
        LineBreakpointTests.assertEquals((String)"the new line number for the validated breakpoint should be line 15", (int)lbp.getLineNumber(), (int)15);
    }

    public void testToggleValidatedLocElse() throws Exception {
        IFile source = this.loadTestSource("BpProject", "", "test4.js", "testsource");
        LineBreakpointTests.assertNotNull((String)"the test source for test4.js could not be found", (Object)source);
        LineBreakpointTests.assertTrue((String)"The test source does not exist for test4.js", (boolean)source.exists());
        IEditorPart editor = this.openEditor(source);
        LineBreakpointTests.assertNotNull((String)"the editor part for test4.js could not be created", (Object)editor);
        IBreakpoint bp = this.toggleBreakpoint(editor, 14);
        LineBreakpointTests.assertTrue((String)"the breakpoint must be a line breakpoint", (boolean)(bp instanceof IJavaScriptLineBreakpoint));
        IJavaScriptLineBreakpoint lbp = (IJavaScriptLineBreakpoint)bp;
        LineBreakpointTests.assertEquals((String)"the new line number for the validated breakpoint should be line 15", (int)lbp.getLineNumber(), (int)15);
    }
}

