/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.misc;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.Preferences;

public class HTMLCorePreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.html.core");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                HTMLCorePreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.html.core");
            }
        }
        catch (BundleException e) {
            HTMLCorePreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.html.core exception: " + String.valueOf((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.wst.html.core", "tagNameCase");
        this.bundleGetPreference("org.eclipse.wst.html.core", "attrNameCase");
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        int defaultValue = -1;
        int value = Platform.getPreferencesService().getInt(bundleName, prefKey, defaultValue, null);
        HTMLCorePreferencesTest.assertTrue((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (defaultValue != value ? 1 : 0) != 0);
    }

    public void testPluginGetDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginGetDefaultPreference(node, "splitMultiAttrs", Boolean.toString(false));
        this.pluginGetDefaultPreference(node, "attrNameCase", Integer.toString(1));
    }

    private void pluginGetDefaultPreference(IEclipsePreferences node, String prefKey, String expected) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String theDefaultValue = node.get(prefKey, defaultValue);
        HTMLCorePreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)theDefaultValue);
    }

    public void testPluginSetPreferences() {
        IEclipsePreferences node = new InstanceScope().getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginSetPreferenceBoolean(node, "splitMultiAttrs");
        this.pluginSetPreferenceString(node, "tagNameCase");
    }

    private void pluginSetPreferenceBoolean(IEclipsePreferences node, String prefKey) {
        boolean originalValue = false;
        boolean expectedValue = true;
        String originalString = node.get(prefKey, "bogus");
        if (!"bogus".equals(originalString)) {
            originalValue = Boolean.valueOf(originalString);
            expectedValue = !originalValue;
        }
        node.putBoolean(prefKey, expectedValue);
        boolean foundValue = node.getBoolean(prefKey, true);
        HTMLCorePreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        if ("bogus".equals(originalString)) {
            node.remove(prefKey);
        } else {
            node.put(prefKey, originalString);
        }
    }

    private void pluginSetPreferenceString(IEclipsePreferences node, String prefKey) {
        String originalValue = node.get(prefKey, "bogus");
        String expectedValue = Long.toString(System.currentTimeMillis());
        node.put(prefKey, expectedValue);
        String foundValue = node.get(prefKey, "");
        HTMLCorePreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (String)expectedValue, (String)foundValue);
        if ("bogus".equals(originalValue)) {
            node.remove(prefKey);
        } else {
            node.put(prefKey, originalValue);
        }
    }

    public void testDelimiterPreferences() {
        String preferredDelimiter = ContentTypeEncodingPreferences.getPreferredNewLineDelimiter((String)ContentTypeIdForHTML.ContentTypeID_HTML);
        Preferences prefs = ContentBasedPreferenceGateway.getPreferences((String)ContentTypeIdForHTML.ContentTypeID_HTML);
        String gatewayDelimiter = prefs.get("endOfLineCode", null);
        HTMLCorePreferencesTest.assertEquals((String)"ContentTypeEncodingPreferences and ContentBasedPreferenceGateway preferences do not match", (String)gatewayDelimiter, (String)preferredDelimiter);
        prefs.put("endOfLineCode", "EOL_Unix");
        HTMLDocumentLoader loader = new HTMLDocumentLoader();
        IEncodedDocument document = loader.createNewStructuredDocument();
        String documentDelimiter = document.getPreferredLineDelimiter();
        HTMLCorePreferencesTest.assertEquals((String)"Delimiter in document does not match preference", (String)"\n", (String)documentDelimiter);
        prefs.remove("endOfLineCode");
    }
}

