/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.parser;

import org.eclipse.wst.html.core.tests.parser.ModelTest;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttrValueTest
extends ModelTest {
    private static final String[] VALUES = new String[]{"<<Previous", "<page>", "Next>>"};

    @Override
    public void testModel() {
        IDOMModel model = AttrValueTest.createHTMLModel();
        try {
            AttrValueTest.assertNotNull((Object)model);
            IStructuredDocument document = model.getStructuredDocument();
            AttrValueTest.assertNotNull((Object)document);
            document.setText((Object)this, "<button value=\"" + VALUES[0] + "\"></button><button value=\"" + VALUES[1] + "\"></button><button value=\"" + VALUES[2] + "\"></button>");
            IDOMDocument dom = model.getDocument();
            NodeList nodes = dom.getElementsByTagName("button");
            AttrValueTest.assertTrue((String)"Must be 3 button elements in the document.", (nodes.getLength() == 3 ? 1 : 0) != 0);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                Node attr = node.getAttributes().getNamedItem("value");
                AttrValueTest.assertTrue((String)"Attribute 'value' not present.", (attr != null && attr.getNodeValue().length() > 0 ? 1 : 0) != 0);
                AttrValueTest.assertEquals((String)"Attribute values are not equal", (String)VALUES[i], (String)attr.getNodeValue());
                ++i;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }
}

