/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.WebMethod;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public abstract class AbstractWebMethodPublicStaticFinalRuleTest
extends AbstractAnnotationValidationTest {
    @Override
    protected Annotation getAnnotation() {
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebMethod.class.getSimpleName(), null);
    }

    @Override
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyClass\")\n");
        classContents.append("public class MyClass {\n\n");
        classContents.append("\tString myPackagePrivateMethod() {\n\t\treturn \"package-private\";\n\t}\n\n");
        classContents.append("\tprivate String myPrivateMethod() {\n\t\treturn \"private\";\n\t}\n\n");
        classContents.append("\tprotected String myProtectedMethod() {\n\t\tmyPrivateMethod();\n");
        classContents.append("\t\treturn \"protected\";\n\t}\n");
        classContents.append("\tpublic static String myStaticMethod() {\n\t\treturn \"static\";\n\t}\n\n");
        classContents.append("\tpublic final String myFinalMethod() {\n\t\treturn \"final\";\n\t}\n\n}");
        return classContents.toString();
    }

    @Override
    protected String getClassName() {
        return "MyClass.java";
    }

    @Override
    protected String getPackageName() {
        return "com.example";
    }

    public abstract IMethod getMethodToTeset();

    public abstract String getErrorMessage();

    public void testWebMethodRestriction() {
        try {
            AbstractWebMethodPublicStaticFinalRuleTest.assertNotNull((Object)this.annotation);
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((String)WebMethod.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.getMethodToTeset();
            AbstractWebMethodPublicStaticFinalRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)WebMethod.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            AbstractWebMethodPublicStaticFinalRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AbstractWebMethodPublicStaticFinalRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            AbstractWebMethodPublicStaticFinalRuleTest.assertTrue((boolean)this.source.getImport(WebMethod.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            AbstractWebMethodPublicStaticFinalRuleTest.assertEquals((Object)this.getErrorMessage(), (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            AbstractWebMethodPublicStaticFinalRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

