/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.junit.Assert;

public final class MockJarProvider {
    public static JarFile getJar(String fileName) throws AssertionFailedError {
        JarFile jarFile;
        File javaFile = new File(fileName);
        Assert.assertTrue((boolean)javaFile.exists());
        try {
            jarFile = new JarFile(javaFile);
        }
        catch (IOException e) {
            AssertionFailedError error = new AssertionFailedError();
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
        return jarFile;
    }

    public static JarFile getJar(IFile jarFile) {
        FileOutputStream outStream = null;
        try {
            InputStream inStream = jarFile.getContents();
            File tempFile = File.createTempFile(jarFile.getName() + "_" + System.currentTimeMillis(), null);
            tempFile.deleteOnExit();
            outStream = new FileOutputStream(tempFile);
            JSFTestUtil.saveToFileSystem(inStream, tempFile.toURI());
            JarFile jarFile2 = new JarFile(tempFile);
            return jarFile2;
        }
        catch (CoreException e) {
            throw new AssertionFailedError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.getLocalizedMessage());
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

