/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.ExtendedCommandContext;
import org.eclipse.jpt.common.utility.command.StatefulExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.AbstractQueueingCommandContext;
import org.eclipse.jpt.common.utility.internal.command.DefaultExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.SimpleStatefulExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.SynchronizingCommand;

public class QueueingExtendedCommandContext
extends AbstractQueueingCommandContext<StatefulExtendedCommandContext>
implements StatefulExtendedCommandContext {
    public QueueingExtendedCommandContext() {
        this(DefaultExtendedCommandContext.instance());
    }

    public QueueingExtendedCommandContext(ExtendedCommandContext commandContext) {
        this(new SimpleStatefulExtendedCommandContext(commandContext));
    }

    public QueueingExtendedCommandContext(StatefulExtendedCommandContext commandContext) {
        super(commandContext);
    }

    @Override
    public void waitToExecute(Command command) throws InterruptedException {
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            syncCommand.waitForExecution();
            ((StatefulExtendedCommandContext)this.commandContext).waitToExecute(command);
        }
        finally {
            syncCommand.release();
        }
    }

    @Override
    public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitToExecute(command);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            if (syncCommand.waitForExecution(timeout)) {
                timeout = stop - System.currentTimeMillis();
                boolean bl = timeout > 0L && ((StatefulExtendedCommandContext)this.commandContext).waitToExecute(command, timeout);
                return bl;
            }
            return false;
        }
        finally {
            syncCommand.release();
        }
    }
}

