/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJarsProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableUtilJarsAndWebLibProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    public Object[] getElements(Object inputElement) {
        ArchiveWrapper wrapper;
        List utilities;
        if (inputElement instanceof ArchiveWrapper && (utilities = (wrapper = (ArchiveWrapper)inputElement).getEARUtilitiesAndWebLibs()).size() > 0) {
            this.filterEJBClientJars(utilities, wrapper);
            Object[] array = utilities.toArray();
            Arrays.sort(array, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return AvailableUtilJarsAndWebLibProvider.this.getColumnText(o1, 0).compareTo(AvailableUtilJarsAndWebLibProvider.this.getColumnText(o2, 0));
                }
            });
            return array;
        }
        return new Object[0];
    }

    private void filterEJBClientJars(List<ArchiveWrapper> utilities, ArchiveWrapper earWrapper) {
        List modules = earWrapper.getEarModules();
        for (ArchiveWrapper module : modules) {
            ArchiveWrapper clientWrapper;
            if (!module.isEJBJarFile() || (clientWrapper = earWrapper.getEJBClientArchiveWrapper(module)) == null) continue;
            boolean removed = false;
            int i = 0;
            while (i < utilities.size() && !removed) {
                if (clientWrapper.getUnderLyingArchive() == utilities.get(i).getUnderLyingArchive()) {
                    utilities.remove(i);
                    removed = true;
                }
                ++i;
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return AvailableJarsProvider.getUtilImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        ArchiveWrapper wrapper = (ArchiveWrapper)element;
        IPath path = wrapper.getPath();
        if (path.toString().startsWith("WEB-INF/lib/")) {
            return String.valueOf(wrapper.getParent().getName()) + "#" + wrapper.getPath();
        }
        return wrapper.getName();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

