/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.util.ModelUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ValidatorGeneralSection
extends AbstractFacesConfigSection {
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField validatorIDField;
    private ClassButtonDialogField validatorClassField;
    private ValidatorGeneralAdapter validatorGeneralAdapter;

    public ValidatorGeneralSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.ValidatorGeneralSection_Name);
        this.getSection().setDescription(EditorMessages.ValidatorGeneralSection_Description);
    }

    @Override
    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(EditorMessages.ValidatorGeneralSection_Label_DisplayName);
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDisplayNameValue = ((StringDialogField)field).getText().trim();
                Command cmd = null;
                ValidatorType validator = (ValidatorType)ValidatorGeneralSection.this.getInput();
                EditingDomain editingDomain = ValidatorGeneralSection.this.getEditingDomain();
                if (validator.getDisplayName().size() > 0) {
                    DisplayNameType displayName = (DisplayNameType)validator.getDisplayName().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)displayName, (Object)FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent(), (Object)newDisplayNameValue);
                } else {
                    DisplayNameType displayNameType = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                    displayNameType.setTextContent(newDisplayNameValue);
                    displayNameType.eAdapters().add((Object)ValidatorGeneralSection.this.getValidatorGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)validator, (Object)FacesConfigPackage.eINSTANCE.getValidatorType_DisplayName(), (Object)displayNameType);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText(EditorMessages.ValidatorGeneralSection_Label_Description);
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescriptionValue = ((StringDialogField)field).getText().trim();
                newDescriptionValue = ModelUtil.escapeEntities(newDescriptionValue);
                Command cmd = null;
                ValidatorType validator = (ValidatorType)ValidatorGeneralSection.this.getInput();
                EditingDomain editingDomain = ValidatorGeneralSection.this.getEditingDomain();
                if (validator.getDescription().size() > 0) {
                    DescriptionType description = (DescriptionType)validator.getDescription().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)description, (Object)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent(), (Object)newDescriptionValue);
                } else {
                    DescriptionType description = FacesConfigFactory.eINSTANCE.createDescriptionType();
                    description.setTextContent(newDescriptionValue);
                    description.eAdapters().add((Object)ValidatorGeneralSection.this.getValidatorGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)validator, (Object)FacesConfigPackage.eINSTANCE.getValidatorType_Description(), (Object)description);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.validatorIDField = new StringDialogField();
        this.validatorIDField.setLabelText(EditorMessages.ValidatorGeneralSection_Label_ValidatorID);
        this.validatorIDField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.validatorIDField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                ValidatorIdType ValidatorType2 = FacesConfigFactory.eINSTANCE.createValidatorIdType();
                ValidatorType2.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = ValidatorGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)ValidatorGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorId(), (Object)ValidatorType2)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.validatorClassField = new ClassButtonDialogField(null);
        this.validatorClassField.setLabelText(EditorMessages.ValidatorGeneralSection_Label_ValidatorClass);
        this.validatorClassField.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        this.validatorClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.validatorClassField.getTextControl(toolkit, container));
        this.validatorClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                ValidatorClassType ValidatorClass = FacesConfigFactory.eINSTANCE.createValidatorClassType();
                ValidatorClass.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = ValidatorGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)ValidatorGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorClass(), (Object)ValidatorClass)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.validatorClassField.setInterface("javax.faces.validator.Validator");
    }

    @Override
    public void refreshAll() {
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        Object input = this.getInput();
        if (input instanceof ValidatorType) {
            ValidatorType validator = (ValidatorType)input;
            this.refreshControls(validator);
        }
    }

    private void refreshControls(ValidatorType validator) {
        if (validator.getDisplayName().size() > 0) {
            DisplayNameType displayName = (DisplayNameType)validator.getDisplayName().get(0);
            this.displayNameField.setTextWithoutUpdate(displayName.getTextContent());
        } else {
            this.displayNameField.setTextWithoutUpdate("");
        }
        if (validator.getDescription().size() > 0) {
            DescriptionType description = (DescriptionType)validator.getDescription().get(0);
            String descriptionString = description.getTextContent();
            descriptionString = ModelUtil.unEscapeEntities(descriptionString);
            this.descriptionField.setTextWithoutUpdate(descriptionString);
        } else {
            this.descriptionField.setTextWithoutUpdate("");
        }
        if (validator.getValidatorId() != null) {
            this.validatorIDField.setTextWithoutUpdate(validator.getValidatorId().getTextContent());
        } else {
            this.validatorIDField.setTextWithoutUpdate("");
        }
        if (validator.getValidatorClass() != null) {
            this.validatorClassField.setTextWithoutUpdate(validator.getValidatorClass().getTextContent());
        } else {
            this.validatorClassField.setTextWithoutUpdate("");
        }
    }

    @Override
    protected void addAdaptersOntoInput(Object newInput) {
        DescriptionType description;
        DisplayNameType displayName;
        ValidatorType validator = (ValidatorType)newInput;
        if (EcoreUtil.getExistingAdapter((Notifier)validator, ValidatorGeneralSection.class) == null) {
            validator.eAdapters().add((Object)this.getValidatorGeneralAdapter());
        }
        if (validator.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)validator.getDisplayName().get(0)), ValidatorGeneralSection.class) == null) {
            displayName.eAdapters().add((Object)this.getValidatorGeneralAdapter());
        }
        if (validator.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)validator.getDescription().get(0)), ValidatorGeneralSection.class) == null) {
            description.eAdapters().add((Object)this.getValidatorGeneralAdapter());
        }
    }

    @Override
    protected void removeAdaptersFromInput(Object oldInput) {
        DescriptionType description;
        DisplayNameType displayName;
        ValidatorType validator = (ValidatorType)oldInput;
        if (EcoreUtil.getExistingAdapter((Notifier)validator, ValidatorGeneralSection.class) != null) {
            validator.eAdapters().remove((Object)this.getValidatorGeneralAdapter());
        }
        if (validator.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)validator.getDisplayName().get(0)), ValidatorGeneralSection.class) != null) {
            displayName.eAdapters().remove((Object)this.getValidatorGeneralAdapter());
        }
        if (validator.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)validator.getDescription().get(0)), ValidatorGeneralSection.class) != null) {
            description.eAdapters().remove((Object)this.getValidatorGeneralAdapter());
        }
    }

    private Adapter getValidatorGeneralAdapter() {
        if (this.validatorGeneralAdapter == null) {
            this.validatorGeneralAdapter = new ValidatorGeneralAdapter();
        }
        return this.validatorGeneralAdapter;
    }

    class ValidatorGeneralAdapter
    extends AdapterImpl {
        ValidatorGeneralAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == ValidatorGeneralSection.class;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorId() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getValidatorType_ValidatorClass() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getValidatorType_Description() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getValidatorType_DisplayName()) {
                    this.refreshInUIThread();
                } else if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent()) {
                    this.refreshInUIThread();
                }
            }
        }

        private void refreshInUIThread() {
            if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                ValidatorGeneralSection.this.refresh();
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ValidatorGeneralSection.this.refresh();
                    }
                });
            }
        }
    }
}

