/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DesignPosition {
    public static final DesignPosition INVALID = new DesignPosition(null, -1);
    private EditPart _containerPart;
    int _offset;

    public DesignPosition(EditPart part, int offset) {
        this._containerPart = part;
        this._offset = offset;
    }

    public EditPart getContainerPart() {
        return this._containerPart;
    }

    public Node getContainerNode() {
        if (this._containerPart != null) {
            return (Node)this._containerPart.getModel();
        }
        return null;
    }

    public int getOffset() {
        return this._offset;
    }

    public boolean isValid() {
        return this._containerPart != null && this._offset >= 0;
    }

    public EditPart getSiblingEditPart(boolean forward) {
        List children;
        if (!this.isValid()) {
            return null;
        }
        int index = forward ? this._offset : this._offset - 1;
        if (index >= (children = this._containerPart.getChildren()).size() || index < 0) {
            return null;
        }
        return (EditPart)children.get(index);
    }

    public static DesignPosition createPositionBeforePart(EditPart part) {
        EditPart parent = part.getParent();
        if (parent == null) {
            return new DesignPosition(part, 0);
        }
        return new DesignPosition(parent, parent.getChildren().indexOf(part));
    }

    public static DesignPosition createPositionAfterPart(EditPart part) {
        EditPart parent = part.getParent();
        if (parent == null) {
            return new DesignPosition(part, part.getChildren().size());
        }
        return new DesignPosition(parent, parent.getChildren().indexOf(part) + 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DesignPosition) {
            DesignPosition p = (DesignPosition)obj;
            return p.getContainerPart() == this._containerPart && p.getOffset() == this._offset;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this._containerPart) ^ System.identityHashCode(this._offset);
    }

    public StringBuffer debugDump(StringBuffer buffer) {
        buffer.append("DesignPosition: ").append(this._containerPart).append(": ").append(this._offset).append("\n");
        if (!(this._containerPart.getModel() instanceof Text)) {
            if (this._offset > 0) {
                buffer.append("after: ").append(this._containerPart.getChildren().get(this._offset - 1)).append("\n");
            }
            if (this._offset < this._containerPart.getChildren().size() - 1) {
                buffer.append("before: ").append(this._containerPart.getChildren().get(this._offset)).append("\n");
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return this.debugDump(buffer).toString();
    }
}

