/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.util.RangeBinarySearch;
import org.eclipse.wst.jsdt.chromium.debug.ui.PluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;

public class LiveEditDiffViewer {
    private final Composite mainControl;
    private final SideControls oldSideView;
    private final SideControls newSideView;
    private final TreeLinkMonitor linkMonitor;
    private final Text functionStatusText;
    private final Colors colors;
    private InputData currentInput = null;

    public static LiveEditDiffViewer create(Composite parent, Configuration configuration) {
        return new LiveEditDiffViewer(parent, configuration);
    }

    private LiveEditDiffViewer(Composite parent, Configuration configuration) {
        this.colors = new Colors(parent.getDisplay());
        FontMetrics defaultFontMetrics = PluginUtil.getFontMetrics((Drawable)parent, null);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        composite.setLayout((Layout)topLayout);
        Composite labelPairComposite = new Composite(composite, 0);
        labelPairComposite.setLayoutData((Object)new GridData(768));
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.spacing = 5;
        labelPairComposite.setLayout((Layout)fillLayout);
        Label labelLeft = new Label(labelPairComposite, 0);
        Label labelRight = new Label(labelPairComposite, 0);
        Composite fourCells = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = defaultFontMetrics.getHeight() * 30;
        gd.widthHint = defaultFontMetrics.getAverageCharWidth() * 85;
        fourCells.setLayoutData((Object)gd);
        FillLayout fillLayout2 = new FillLayout();
        fillLayout2.type = 512;
        fillLayout2.spacing = 5;
        fourCells.setLayout((Layout)fillLayout2);
        Composite treePairComposite = new Composite(fourCells, 0);
        fillLayout2 = new FillLayout();
        fillLayout2.type = 256;
        fillLayout2.spacing = 5;
        treePairComposite.setLayout((Layout)fillLayout2);
        this.linkMonitor = new TreeLinkMonitor();
        TreeViewer treeViewerLeft = new TreeViewer(treePairComposite);
        TreeViewer treeViewerRight = new TreeViewer(treePairComposite);
        Composite sourcePairComposite = new Composite(fourCells, 0);
        FillLayout fillLayout3 = new FillLayout();
        fillLayout3.type = 256;
        fillLayout3.spacing = 5;
        sourcePairComposite.setLayout((Layout)fillLayout3);
        SourceViewer sourceViewerLeft = new SourceViewer(sourcePairComposite, null, 2816);
        sourceViewerLeft.getTextWidget().setEditable(false);
        SourceViewer sourceViewerRight = new SourceViewer(sourcePairComposite, null, 2816);
        sourceViewerRight.getTextWidget().setEditable(false);
        this.functionStatusText = new Text(composite, 586);
        Display display = composite.getDisplay();
        this.functionStatusText.setBackground(display.getSystemColor(22));
        GridData gd2 = new GridData(1808);
        gd2.heightHint = gd2.minimumHeight = defaultFontMetrics.getHeight() * 3;
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 4;
        this.functionStatusText.setLayoutData((Object)gd2);
        SideControls sideViewLeft = new SideControls(labelLeft, treeViewerLeft, sourceViewerLeft);
        SideControls sideViewRight = new SideControls(labelRight, treeViewerRight, sourceViewerRight);
        if (configuration.oldOnLeft()) {
            this.oldSideView = sideViewLeft;
            this.newSideView = sideViewRight;
        } else {
            this.oldSideView = sideViewRight;
            this.newSideView = sideViewLeft;
        }
        this.oldSideView.label.setText(configuration.getOldLabel());
        this.newSideView.label.setText(configuration.getNewLabel());
        this.configureSide(this.oldSideView, this.newSideView, Side.OLD);
        this.configureSide(this.newSideView, this.oldSideView, Side.NEW);
        this.mainControl = composite;
        this.mainControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LiveEditDiffViewer.this.handleDispose(event);
            }
        });
    }

    private void configureSide(SideControls sideControls, SideControls opposite, Side side) {
        this.configureTreeViewer(sideControls.treeViewer, opposite.treeViewer, side);
        this.configureSourceViewer(sideControls.sourceViewer, opposite.sourceViewer, side);
    }

    private void configureTreeViewer(TreeViewer treeViewer, TreeViewer opposite, Side side) {
        treeViewer.setContentProvider((IContentProvider)new FunctionTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl(side));
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangeListener(opposite));
        treeViewer.addTreeListener((ITreeViewerListener)new TreeListenerImpl(opposite));
        treeViewer.getTree().getVerticalBar().addListener(13, (Listener)new TreeScrollBarListener(opposite));
    }

    private void configureSourceViewer(SourceViewer sourceViewer, SourceViewer opposite, Side side) {
        sourceViewer.getTextWidget().getVerticalBar().addListener(13, (Listener)new SourceScrollBarListener(sourceViewer, opposite, side));
        sourceViewer.getTextWidget().addLineBackgroundListener((LineBackgroundListener)new LineBackgroundListenerImpl(side));
    }

    private void handleDispose(DisposeEvent event) {
        this.colors.dispose();
    }

    public Control getControl() {
        return this.mainControl;
    }

    public void setInput(Input input) {
        this.linkMonitor.block();
        try {
            this.oldSideView.treeViewer.setInput((Object)input);
            this.newSideView.treeViewer.setInput((Object)input);
            this.oldSideView.treeViewer.expandAll();
            this.newSideView.treeViewer.expandAll();
            Document oldDocument = input == null ? null : new Document(input.getOldSource().getText());
            this.oldSideView.sourceViewer.setDocument((IDocument)oldDocument);
            Document newDocument = input == null ? null : new Document(input.getNewSource().getText());
            this.newSideView.sourceViewer.setDocument((IDocument)newDocument);
            if (input != null) {
                this.applyDiffPresentation(this.oldSideView.sourceViewer, this.newSideView.sourceViewer, input.getTextualDiff());
            }
        }
        finally {
            this.linkMonitor.unblock();
        }
        this.currentInput = LiveEditDiffViewer.buildInputData(input);
        this.setSelectedFunction(null);
    }

    private static InputData buildInputData(Input input) {
        if (input == null) {
            return null;
        }
        List chunkArray = input.getTextualDiff().getChunks();
        String oldText = input.getOldSource().getText();
        String newText = input.getNewSource().getText();
        int arrayLengthExpected = chunkArray.size() / 3;
        ArrayList<ChunkData> oldLineNumbers = new ArrayList<ChunkData>(arrayLengthExpected);
        ArrayList<ChunkData> newLineNumbers = new ArrayList<ChunkData>(arrayLengthExpected);
        int oldPos = 0;
        int currentOldLineNumber = 0;
        int newPos = 0;
        int currentNewLineNumber = 0;
        int i = 0;
        while (i < chunkArray.size()) {
            int oldStart = ((Long)chunkArray.get(i + 0)).intValue();
            int newStart = oldStart - oldPos + newPos;
            int oldEnd = ((Long)chunkArray.get(i + 1)).intValue();
            int newEnd = ((Long)chunkArray.get(i + 2)).intValue();
            int oldLineStart = currentOldLineNumber += LiveEditDiffViewer.countLineEnds(oldText, oldPos, oldStart);
            int newLineStart = currentNewLineNumber += LiveEditDiffViewer.countLineEnds(newText, newPos, newStart);
            oldLineNumbers.add(new ChunkData(oldLineStart, currentOldLineNumber += LiveEditDiffViewer.countLineEnds(oldText, oldStart, oldEnd), oldStart, oldEnd));
            newLineNumbers.add(new ChunkData(newLineStart, currentNewLineNumber += LiveEditDiffViewer.countLineEnds(newText, newStart, newEnd), newStart, newEnd));
            oldPos = oldEnd;
            newPos = newEnd;
            i += 3;
        }
        return new InputData(new TextChangesMap(oldLineNumbers, newLineNumbers), new TextChangesMap(newLineNumbers, oldLineNumbers));
    }

    private static int countLineEnds(String str, int start, int end) {
        int result = 0;
        int i = start;
        while (i < end) {
            if (str.charAt(i) == '\n') {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private void applyDiffPresentation(SourceViewer oldViewer, SourceViewer newViewer, UpdatableScript.TextualDiff textualDiff) {
        TextPresentation oldPresentation = new TextPresentation();
        TextPresentation newPresentation = new TextPresentation();
        List chunkNumbers = textualDiff.getChunks();
        int posOld = 0;
        int posNew = 0;
        int i = 0;
        while (i < chunkNumbers.size()) {
            int startOld = ((Long)chunkNumbers.get(i + 0)).intValue();
            int endOld = ((Long)chunkNumbers.get(i + 1)).intValue();
            int endNew = ((Long)chunkNumbers.get(i + 2)).intValue();
            int startNew = startOld - posOld + posNew;
            if (startOld == endOld) {
                newPresentation.addStyleRange(new StyleRange(startNew, endNew - startNew, null, this.colors.get(ColorName.ADDED_BACKGROUND)));
            } else if (startNew == endNew) {
                oldPresentation.addStyleRange(new StyleRange(startOld, endOld - startOld, null, this.colors.get(ColorName.ADDED_BACKGROUND)));
            } else {
                newPresentation.addStyleRange(new StyleRange(startNew, endNew - startNew, null, this.colors.get(ColorName.CHANGED_BACKGROUND)));
                oldPresentation.addStyleRange(new StyleRange(startOld, endOld - startOld, null, this.colors.get(ColorName.CHANGED_BACKGROUND)));
            }
            posOld = endOld;
            posNew = endNew;
            i += 3;
        }
        oldViewer.changeTextPresentation(oldPresentation, true);
        newViewer.changeTextPresentation(newPresentation, true);
    }

    private void updateFunctionSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        FunctionNode functionNode = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object element = structuredSelection.getFirstElement();
            functionNode = (FunctionNode)element;
        }
        this.setSelectedFunction(functionNode);
    }

    private void setSelectedFunction(FunctionNode functionNode) {
        String text;
        if (functionNode == null) {
            text = "";
        } else {
            text = functionNode.getStatus();
            this.highlightCode(functionNode, Side.OLD, this.oldSideView.sourceViewer);
            this.highlightCode(functionNode, Side.NEW, this.newSideView.sourceViewer);
        }
        this.functionStatusText.setText(text);
    }

    private void highlightCode(FunctionNode node, Side side, SourceViewer sourceViewer) {
        SourcePosition position = node.getPosition(side);
        if (position == null) {
            Point oldSelection = sourceViewer.getSelectedRange();
            sourceViewer.setSelectedRange(oldSelection.x, 0);
        } else {
            sourceViewer.setSelectedRange(position.getStart(), position.getEnd() - position.getStart());
            sourceViewer.revealRange(position.getStart(), position.getEnd() - position.getStart());
        }
    }

    private static class ChunkData {
        final int startLineNumber;
        final int endLineNumber;
        final int startPosition;
        final int endPosition;

        ChunkData(int startLineNumber, int endLineNumber, int startPosition, int endPosition) {
            this.startLineNumber = startLineNumber;
            this.endLineNumber = endLineNumber;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }
    }

    private static enum ColorName {
        ADDED_BACKGROUND(new RGB(220, 255, 220)),
        CHANGED_BACKGROUND(new RGB(220, 220, 255)),
        CHANGED_LINE_BACKGROUND(new RGB(240, 240, 240));

        private final RGB rgb;

        private ColorName(RGB rgb) {
            this.rgb = rgb;
        }

        public RGB getRgb() {
            return this.rgb;
        }
    }

    private static class Colors {
        private final Display display;
        private final Map<ColorName, Color> colorMap = new EnumMap<ColorName, Color>(ColorName.class);

        public Colors(Display display) {
            this.display = display;
        }

        Color get(ColorName name) {
            Color result = this.colorMap.get((Object)name);
            if (result == null) {
                result = new Color((Device)this.display, name.getRgb());
                this.colorMap.put(name, result);
            }
            return result;
        }

        void dispose() {
            for (Color color : this.colorMap.values()) {
                color.dispose();
            }
        }
    }

    public static interface Configuration {
        public String getOldLabel();

        public String getNewLabel();

        public boolean oldOnLeft();
    }

    public static interface FunctionNode {
        public String getName();

        public String getStatus();

        public List<? extends FunctionNode> children();

        public SourcePosition getPosition(Side var1);

        public FunctionNode getParent();
    }

    private static class FunctionTreeContentProvider
    implements ITreeContentProvider {
        private FunctionTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            FunctionNode functionNode = (FunctionNode)parentElement;
            return functionNode.children().toArray();
        }

        public Object getParent(Object element) {
            FunctionNode functionNode = (FunctionNode)element;
            return functionNode.getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            Input input = (Input)inputElement;
            if (input == null) {
                return new Object[0];
            }
            return new Object[]{input.getRootFunction()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static interface Input {
        public FunctionNode getRootFunction();

        public SourceText getOldSource();

        public SourceText getNewSource();

        public UpdatableScript.TextualDiff getTextualDiff();
    }

    private static class InputData {
        private final Map<Side, TextChangesMap> sideToMap = new EnumMap<Side, TextChangesMap>(Side.class);

        InputData(TextChangesMap oldSideMap, TextChangesMap newSideMap) {
            this.sideToMap.put(Side.OLD, oldSideMap);
            this.sideToMap.put(Side.NEW, newSideMap);
        }

        TextChangesMap getMap(Side side) {
            return this.sideToMap.get((Object)side);
        }
    }

    private static class LabelProviderImpl
    implements ILabelProvider {
        private final Side side;

        LabelProviderImpl(Side side) {
            this.side = side;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            FunctionNode functionNode = (FunctionNode)element;
            SourcePosition position = functionNode.getPosition(this.side);
            if (position == null) {
                return ".";
            }
            String name = functionNode.getName();
            if (name == null || name.trim().length() == 0) {
                return Messages.LiveEditDiffViewer_UNNAMED;
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }
    }

    private class LineBackgroundListenerImpl
    implements LineBackgroundListener {
        private final Side side;

        LineBackgroundListenerImpl(Side side) {
            this.side = side;
        }

        public void lineGetBackground(LineBackgroundEvent event) {
            if (LiveEditDiffViewer.this.currentInput == null) {
                return;
            }
            TextChangesMap changesMap = LiveEditDiffViewer.this.currentInput.getMap(this.side);
            ColorName colorName = changesMap.getLineColorName(event.lineOffset, event.lineText.length() + 1);
            if (colorName != null) {
                event.lineBackground = LiveEditDiffViewer.this.colors.get(colorName);
            }
        }
    }

    private abstract class ScrollListenerBase
    implements Listener {
        private ScrollListenerBase() {
        }

        public void handleEvent(Event e) {
            if (LiveEditDiffViewer.this.linkMonitor.isBlocked()) {
                return;
            }
            LiveEditDiffViewer.this.linkMonitor.block();
            try {
                this.handleScroll((ScrollBar)e.widget);
            }
            finally {
                LiveEditDiffViewer.this.linkMonitor.unblock();
            }
        }

        protected abstract void handleScroll(ScrollBar var1);
    }

    private class SelectionChangeListener
    implements ISelectionChangedListener {
        private final TreeViewer oppositeViewer;

        SelectionChangeListener(TreeViewer oppositeViewer) {
            this.oppositeViewer = oppositeViewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (LiveEditDiffViewer.this.linkMonitor.isBlocked()) {
                return;
            }
            LiveEditDiffViewer.this.linkMonitor.block();
            try {
                ISelection selection = event.getSelection();
                this.oppositeViewer.setSelection(selection);
                LiveEditDiffViewer.this.updateFunctionSelection(selection);
            }
            finally {
                LiveEditDiffViewer.this.linkMonitor.unblock();
            }
        }
    }

    public static enum Side {
        OLD,
        NEW;

    }

    private static class SideControls {
        final Label label;
        final TreeViewer treeViewer;
        final SourceViewer sourceViewer;

        SideControls(Label label, TreeViewer treeViewer, SourceViewer sourceViewer) {
            this.label = label;
            this.treeViewer = treeViewer;
            this.sourceViewer = sourceViewer;
        }
    }

    public static interface SourcePosition {
        public int getStart();

        public int getEnd();
    }

    private class SourceScrollBarListener
    extends ScrollListenerBase {
        private final SourceViewer sourceViewer;
        private final SourceViewer opposite;
        private final Side side;

        SourceScrollBarListener(SourceViewer sourceViewer, SourceViewer opposite, Side side) {
            this.sourceViewer = sourceViewer;
            this.opposite = opposite;
            this.side = side;
        }

        @Override
        protected void handleScroll(ScrollBar scrollBar) {
            if (LiveEditDiffViewer.this.currentInput == null) {
                return;
            }
            int topPos = this.sourceViewer.getTopIndex();
            int bottomPos = this.sourceViewer.getBottomIndex();
            TextChangesMap changesMap = LiveEditDiffViewer.this.currentInput.getMap(this.side);
            int neededOppositeTopPos = changesMap.translateLineNumber(topPos, true);
            int neededOppositeBottomPos = changesMap.translateLineNumber(bottomPos, false);
            int actualOppositeTopPos = this.opposite.getTopIndex();
            int actualOppositeBottomPos = this.opposite.getBottomIndex();
            int topFreeSpace = actualOppositeTopPos - neededOppositeTopPos;
            int bottomFreeSpace = neededOppositeBottomPos - actualOppositeBottomPos;
            if (topFreeSpace > 0 && bottomFreeSpace < 0) {
                int moveUpValue = Math.min(topFreeSpace, -bottomFreeSpace);
                this.opposite.setTopIndex(actualOppositeTopPos - moveUpValue);
            } else if (topFreeSpace < 0 && bottomFreeSpace > 0) {
                int moveDownValue = Math.min(-topFreeSpace, bottomFreeSpace);
                this.opposite.setTopIndex(actualOppositeTopPos + moveDownValue);
            }
        }
    }

    public static interface SourceText {
        public String getText();

        public String getTitle();
    }

    private static class TextChangesMap {
        private final List<ChunkData> sourceChunks;
        private final List<ChunkData> targetChunks;

        TextChangesMap(List<ChunkData> sourceChunks, List<ChunkData> targetChunks) {
            this.sourceChunks = sourceChunks;
            this.targetChunks = targetChunks;
        }

        public ColorName getLineColorName(int lineStartOffset, int lineLen) {
            if (this.isChangedLine(lineStartOffset, lineLen)) {
                return ColorName.CHANGED_LINE_BACKGROUND;
            }
            return null;
        }

        private boolean isChangedLine(final int lineStartOffset, int lineLen) {
            RangeBinarySearch.Input searchInput = new RangeBinarySearch.Input(){

                public int pinPointsNumber() {
                    return sourceChunks.size();
                }

                public boolean isPointXLessThanPinPoint(int pinPointIndex) {
                    return lineStartOffset <= ((ChunkData)((TextChangesMap)this).sourceChunks.get((int)pinPointIndex)).endPosition;
                }
            };
            int chunkIndex = RangeBinarySearch.find((RangeBinarySearch.Input)searchInput);
            if (chunkIndex == this.sourceChunks.size()) {
                return false;
            }
            return lineStartOffset + lineLen > this.sourceChunks.get((int)chunkIndex).startPosition;
        }

        int translateLineNumber(final int lineNumber, final boolean preferAboveNotBelow) {
            RangeBinarySearch.Input searchInput = new RangeBinarySearch.Input(){

                public int pinPointsNumber() {
                    return sourceChunks.size() * 2;
                }

                public boolean isPointXLessThanPinPoint(int pinPointIndex) {
                    int chunkIndex = pinPointIndex / 2;
                    int number = pinPointIndex % 2 == 0 ? ((ChunkData)((TextChangesMap)this).sourceChunks.get((int)chunkIndex)).startLineNumber : ((ChunkData)((TextChangesMap)this).sourceChunks.get((int)chunkIndex)).endLineNumber;
                    return preferAboveNotBelow ? lineNumber <= number : lineNumber < number;
                }
            };
            int pointIndex = RangeBinarySearch.find((RangeBinarySearch.Input)searchInput);
            int chunkIndex = pointIndex / 2;
            if (pointIndex % 2 == 0) {
                int diff = chunkIndex == 0 ? 0 : this.targetChunks.get((int)(chunkIndex - 1)).endLineNumber - this.sourceChunks.get((int)(chunkIndex - 1)).endLineNumber;
                return lineNumber + diff;
            }
            if (preferAboveNotBelow) {
                return this.targetChunks.get((int)chunkIndex).startLineNumber;
            }
            return this.targetChunks.get((int)chunkIndex).endLineNumber;
        }
    }

    private static class TreeLinkMonitor {
        private boolean blocked = false;
        private final Thread accessThread = Thread.currentThread();

        private TreeLinkMonitor() {
        }

        void block() {
            assert (this.accessThread == Thread.currentThread());
            if (this.blocked) {
                throw new IllegalStateException();
            }
            this.blocked = true;
        }

        void unblock() {
            this.blocked = false;
        }

        boolean isBlocked() {
            return this.blocked;
        }
    }

    private class TreeListenerImpl
    implements ITreeViewerListener {
        private final TreeViewer oppositeViewer;

        TreeListenerImpl(TreeViewer oppositeViewer) {
            this.oppositeViewer = oppositeViewer;
        }

        public void treeExpanded(TreeExpansionEvent event) {
            if (LiveEditDiffViewer.this.linkMonitor.isBlocked()) {
                return;
            }
            LiveEditDiffViewer.this.linkMonitor.block();
            try {
                this.oppositeViewer.expandToLevel(event.getElement(), 1);
            }
            finally {
                LiveEditDiffViewer.this.linkMonitor.unblock();
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            if (LiveEditDiffViewer.this.linkMonitor.isBlocked()) {
                return;
            }
            LiveEditDiffViewer.this.linkMonitor.block();
            try {
                this.oppositeViewer.collapseToLevel(event.getElement(), 1);
            }
            finally {
                LiveEditDiffViewer.this.linkMonitor.unblock();
            }
        }
    }

    private class TreeScrollBarListener
    extends ScrollListenerBase {
        private final TreeViewer oppositeViewer;

        TreeScrollBarListener(TreeViewer oppositeViewer) {
            this.oppositeViewer = oppositeViewer;
        }

        @Override
        protected void handleScroll(ScrollBar scrollBar) {
            int vpos = scrollBar.getSelection();
            this.oppositeViewer.getTree().getVerticalBar().setSelection(vpos);
        }
    }
}

