/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.propertypages;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.Messages;

class AccuratenessControl {
    private final Logic logic;

    AccuratenessControl(Composite composite, String[] pathSegments, int initialAccuratenessValue) {
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(768));
        Composite topLineBlock = new Composite(inner, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        topLineBlock.setLayout((Layout)layout2);
        topLineBlock.setLayoutData((Object)new GridData(768));
        Label label = new Label(topLineBlock, 0);
        label.setText(Messages.AccuratenessControl_LABEL_USE);
        Composite buttonsGroup = new Composite(topLineBlock, 0);
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginHeight = 0;
        buttonsGroup.setLayout((Layout)layout3);
        final Button less = new Button(buttonsGroup, 0);
        less.setText(Messages.AccuratenessControl_LESS_BUTTON);
        final Button more = new Button(buttonsGroup, 0);
        more.setText(Messages.AccuratenessControl_MORE_BUTTON);
        final PathLabel pathLabel = new PathLabel(inner, pathSegments);
        pathLabel.getControl().setLayoutData((Object)new GridData(768));
        pathLabel.setVisiblePart(initialAccuratenessValue);
        new Label(inner, 0);
        Elements elements = new Elements(){

            @Override
            public PathLabel getPathLabel() {
                return pathLabel;
            }

            @Override
            public Button getMoreButton() {
                return more;
            }

            @Override
            public Button getLessButton() {
                return less;
            }
        };
        this.logic = AccuratenessControl.createLogic(elements);
        this.logic.updateAll();
    }

    int getAccuratenessValue() {
        return this.logic.getAccuratenessValue();
    }

    private static Logic createLogic(final Elements elements) {
        final DialogUtils.Updater updater = new DialogUtils.Updater();
        final PathLabel pathElement = elements.getPathLabel();
        DialogUtils.ValueSource<Integer> visiblePartSource = new DialogUtils.ValueSource<Integer>(){

            @Override
            public Integer getValue() {
                return pathElement.getVisiblePartSize();
            }
        };
        updater.addSource(updater.rootScope(), visiblePartSource);
        abstract class ButtonController
        implements DialogUtils.ValueConsumer {
            private final Button button;
            private final /* synthetic */ PathLabel val$pathElement;

            ButtonController(Button button, final PathLabel pathLabel, final DialogUtils.Updater updater, final DialogUtils.ValueSource valueSource) {
                this.val$pathElement = pathLabel;
                this.button = button;
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int size = pathLabel.getVisiblePartSize();
                        if (!this.isEnabled(size)) {
                            return;
                        }
                        int newSize = this.getNewValue(size);
                        pathLabel.setVisiblePart(newSize);
                        updater.reportChanged(valueSource);
                        updater.update();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }

            @Override
            public void update(DialogUtils.Updater updater) {
                int size = this.val$pathElement.getVisiblePartSize();
                boolean enabled = this.isEnabled(size);
                this.button.setEnabled(enabled);
            }

            protected abstract boolean isEnabled(int var1);

            protected abstract int getNewValue(int var1);
        }
        ButtonController lessController = new ButtonController(elements.getLessButton(), pathElement, updater, visiblePartSource){
            {
                super($anonymous0, pathLabel, updater, valueSource);
            }

            @Override
            protected boolean isEnabled(int visiblePartSize) {
                return visiblePartSize > 1;
            }

            @Override
            protected int getNewValue(int currentValue) {
                return currentValue - 1;
            }
        };
        updater.addConsumer(updater.rootScope(), lessController);
        updater.addDependency((DialogUtils.ValueConsumer)lessController, visiblePartSource);
        final int size = elements.getPathLabel().size();
        ButtonController moreController = new ButtonController(elements.getMoreButton(), pathElement, updater, visiblePartSource){
            {
                super($anonymous0, pathLabel, updater, valueSource);
            }

            @Override
            protected boolean isEnabled(int visiblePartSize) {
                return visiblePartSize < size;
            }

            @Override
            protected int getNewValue(int currentValue) {
                return currentValue + 1;
            }
        };
        updater.addConsumer(updater.rootScope(), moreController);
        updater.addDependency((DialogUtils.ValueConsumer)moreController, visiblePartSource);
        return new Logic(){

            @Override
            public int getAccuratenessValue() {
                return elements.getPathLabel().getVisiblePartSize();
            }

            @Override
            public void updateAll() {
                updater.updateAll();
            }
        };
    }

    private static interface Elements {
        public PathLabel getPathLabel();

        public Button getLessButton();

        public Button getMoreButton();
    }

    private static interface Logic {
        public int getAccuratenessValue();

        public void updateAll();
    }

    private static class PathLabel {
        private final String[] components;
        private final StyledText styledText;
        private int visiblePartSize = 1;

        PathLabel(Composite composite, String[] components) {
            this.components = components;
            this.styledText = new StyledText(composite, 0);
            this.styledText.setEditable(false);
            this.styledText.setCaret(null);
            this.styledText.setBackground(composite.getBackground());
        }

        public Control getControl() {
            return this.styledText;
        }

        int size() {
            return this.components.length;
        }

        int getVisiblePartSize() {
            return this.visiblePartSize;
        }

        void setVisiblePart(int visiblePartSize) {
            this.visiblePartSize = visiblePartSize;
            int size = this.components.length;
            StringBuilder builder = new StringBuilder();
            int i = size - visiblePartSize;
            while (i < size - 1) {
                builder.append(this.components[i]);
                builder.append("/");
                ++i;
            }
            int lastComponentStart = builder.length();
            builder.append(this.components[size - 1]);
            int lastComponentEnd = builder.length();
            this.styledText.setText(builder.toString());
            StyleRange boldRange = new StyleRange(lastComponentStart, lastComponentEnd - lastComponentStart, null, null, 1);
            StyleRange[] ranges = new StyleRange[]{boldRange};
            this.styledText.setStyleRanges(ranges);
            this.styledText.setCaretOffset(lastComponentStart);
        }
    }
}

