/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.HashMap;
import java.util.Map;

public enum DebuggerCommand {
    CONTINUE("continue"),
    EVALUATE("evaluate"),
    BACKTRACE("backtrace"),
    FRAME("frame"),
    SCRIPTS("scripts"),
    CHANGELIVE("changelive"),
    RESTARTFRAME("restartframe"),
    SOURCE("source"),
    SCOPE("scope"),
    SETBREAKPOINT("setbreakpoint"),
    CHANGEBREAKPOINT("changebreakpoint"),
    CLEARBREAKPOINT("clearbreakpoint"),
    LISTBREAKPOINTS("listbreakpoints"),
    LOOKUP("lookup"),
    SUSPEND("suspend"),
    VERSION("version"),
    FLAGS("flags"),
    SETVARIABLEVALUE("setVariableValue"),
    BREAK("break"),
    EXCEPTION("exception"),
    AFTER_COMPILE("afterCompile"),
    SCRIPT_COLLECTED("scriptCollected");

    public final String value;
    private static final Map<String, DebuggerCommand> valueToCommandMap;

    static {
        valueToCommandMap = new HashMap<String, DebuggerCommand>();
        DebuggerCommand[] debuggerCommandArray = DebuggerCommand.values();
        int n = debuggerCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebuggerCommand c = debuggerCommandArray[n2];
            valueToCommandMap.put(c.value, c);
            ++n2;
        }
    }

    private DebuggerCommand(String value) {
        this.value = value;
    }

    public static DebuggerCommand forString(String value) {
        if (value == null) {
            return null;
        }
        return valueToCommandMap.get(value);
    }
}

