/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.views.stylesheet;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.XSLNode;

public class StylesheetModelView
extends ViewPart {
    private IEditorPart activeEditor;
    private TreeViewer tv;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            IFileEditorInput edFileInput;
            IEditorPart editor;
            IEditorInput edInput;
            if (part instanceof IEditorPart && (edInput = (editor = (IEditorPart)part).getEditorInput()) instanceof IFileEditorInput && XSLCore.isXSLFile((IFile)(edFileInput = (IFileEditorInput)edInput).getFile())) {
                StylesheetModelView.this.activeEditor = editor;
                StylesheetModel model = XSLCore.getInstance().getStylesheet(edFileInput.getFile());
                StylesheetModelView.this.tv.setInput((Object)model.getStylesheet());
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == StylesheetModelView.this.activeEditor) {
                StylesheetModelView.this.tv.setInput(null);
                StylesheetModelView.this.activeEditor = null;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        site.getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 0);
        this.tv = new TreeViewer(tree);
        this.tv.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StylesheetModelView.this.getSite().getPage().getActivePart() == StylesheetModelView.this) {
                    StylesheetModelView.this.handleTreeSelection((IStructuredSelection)event.getSelection(), false);
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StylesheetModelView.this.handleTreeSelection((IStructuredSelection)event.getSelection(), true);
            }
        });
    }

    private void handleTreeSelection(IStructuredSelection selection, boolean reveal) {
        if (this.activeEditor != null && selection.getFirstElement() instanceof XSLNode) {
            XSLNode node = (XSLNode)selection.getFirstElement();
            ITextEditor textEditor = (ITextEditor)this.activeEditor.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                textEditor.selectAndReveal(node.getOffset(), 0);
            }
        }
    }

    public void setFocus() {
    }
}

