/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.HashMap;
import java.util.Map;

public final class PrimitiveUtils {
    private static final Map<Class<?>, PrimitiveEntry> primitiveTypes = new HashMap(9);
    private static final Map<Class<?>, String> wrapperTypes = new HashMap(6);

    private PrimitiveUtils() {
    }

    public static Object getEmptyValue(Class<?> type) {
        return PrimitiveUtils.primitiveTypes.get(type).emptyValue;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return PrimitiveUtils.primitiveTypes.get(type).wrapperType;
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return wrapperTypes.containsKey(type);
    }

    public static String getPrimitiveTypeNameFromWrapper(Class<?> type) {
        return wrapperTypes.get(type);
    }

    static {
        primitiveTypes.put(Void.TYPE, new PrimitiveEntry(null, Void.class));
        primitiveTypes.put(Boolean.TYPE, new PrimitiveEntry(Boolean.FALSE, Boolean.class));
        primitiveTypes.put(Byte.TYPE, new PrimitiveEntry((byte)0, Byte.class));
        primitiveTypes.put(Short.TYPE, new PrimitiveEntry((short)0, Short.class));
        primitiveTypes.put(Character.TYPE, new PrimitiveEntry(Character.valueOf('\u0000'), Character.class));
        primitiveTypes.put(Integer.TYPE, new PrimitiveEntry(0, Integer.class));
        primitiveTypes.put(Long.TYPE, new PrimitiveEntry(0L, Long.class));
        primitiveTypes.put(Float.TYPE, new PrimitiveEntry(Float.valueOf(0.0f), Float.class));
        primitiveTypes.put(Double.TYPE, new PrimitiveEntry(0.0, Double.class));
        wrapperTypes.put(Byte.class, "byte");
        wrapperTypes.put(Short.class, "short");
        wrapperTypes.put(Integer.class, "int");
        wrapperTypes.put(Long.class, "long");
        wrapperTypes.put(Float.class, "float");
        wrapperTypes.put(Double.class, "double");
    }

    private static class PrimitiveEntry {
        final Object emptyValue;
        final Class<?> wrapperType;

        private PrimitiveEntry(Object emptyValue, Class<?> wrapperType) {
            this.emptyValue = emptyValue;
            this.wrapperType = wrapperType;
        }
    }
}

