/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.easymock.IAnswer;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;

public final class Result
implements IAnswer<Object>,
Serializable {
    private static final long serialVersionUID = 5476251941213917681L;
    private final IAnswer<?> value;
    private final boolean shouldFillInStackTrace;

    private Result(IAnswer<?> value, boolean shouldFillInStackTrace) {
        this.value = value;
        this.shouldFillInStackTrace = shouldFillInStackTrace;
    }

    public static Result createThrowResult(Throwable throwable) {
        class ThrowingAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = -332797751209289222L;
            final /* synthetic */ Throwable val$throwable;

            ThrowingAnswer(Throwable throwable) {
                this.val$throwable = throwable;
            }

            @Override
            public Object answer() throws Throwable {
                throw this.val$throwable;
            }

            public String toString() {
                return "Answer throwing " + this.val$throwable;
            }
        }
        return new Result(new ThrowingAnswer(throwable), true);
    }

    public static Result createReturnResult(Object value) {
        class ReturningAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = 6973893913593916866L;
            final /* synthetic */ Object val$value;

            ReturningAnswer(Object object) {
                this.val$value = object;
            }

            @Override
            public Object answer() {
                return this.val$value;
            }

            public String toString() {
                return "Answer returning " + this.val$value;
            }
        }
        return new Result(new ReturningAnswer(value), true);
    }

    public static Result createDelegatingResult(Object value) {
        class DelegatingAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = -5699326678580460103L;
            final /* synthetic */ Object val$value;

            DelegatingAnswer(Object object) {
                this.val$value = object;
            }

            @Override
            public Object answer() throws Throwable {
                Invocation invocation = LastControl.getCurrentInvocation();
                if (invocation == null) {
                    throw new IllegalStateException("Call was performed outside of a mock invocation");
                }
                try {
                    Method m = invocation.getMethod();
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    return m.invoke(this.val$value, this.convertVarargs(m, invocation.getArguments()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Delegation to object [" + this.val$value + "] is not implementing the mocked method [" + invocation.getMethod() + "]", e);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            private Object[] convertVarargs(Method method, Object[] arguments) {
                if (!method.isVarArgs()) {
                    return arguments;
                }
                Class<?>[] paramTypes = method.getParameterTypes();
                Object[] packedArguments = new Object[paramTypes.length];
                int normalArgLength = paramTypes.length - 1;
                int varargLength = arguments.length - paramTypes.length + 1;
                System.arraycopy(arguments, 0, packedArguments, 0, normalArgLength);
                Object varargs = Array.newInstance(paramTypes[packedArguments.length - 1].getComponentType(), varargLength);
                for (int i = 0; i < varargLength; ++i) {
                    Array.set(varargs, i, arguments[normalArgLength + i]);
                }
                packedArguments[packedArguments.length - 1] = varargs;
                return packedArguments;
            }

            public String toString() {
                return "Delegated to " + this.val$value;
            }
        }
        return new Result(new DelegatingAnswer(value), false);
    }

    public static Result createAnswerResult(IAnswer<?> answer) {
        return new Result(answer, false);
    }

    @Override
    public Object answer() throws Throwable {
        return this.value.answer();
    }

    public boolean shouldFillInStackTrace() {
        return this.shouldFillInStackTrace;
    }

    public String toString() {
        return this.value.toString();
    }
}

