/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.command.CommandAdapter;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ClassToolsTests
extends TestCase {
    public static final String TEST_STATIC_FINAL_FIELD = "XXXX value";
    private static String testStaticField;
    private static final String UNINITIALIZED = "uninitialized";
    private static final String TOUCHED = "touched";
    private static String executeStaticMethod_field;
    private static final String UNINITIALIZED_ = "uninitialized_";
    private static final String TOUCHED_ = "touched_";
    private static String executeStaticMethod_field_;
    private static final String STATIC_RETURN_VALUE = "foo";
    private static String executeStaticMethodWithParm_field;
    private static String executeStaticMethodWithParm_field_;
    private static final Transformer<Field, String> FIELD_NAME_TRANSFORMER;
    private static final Transformer<Method, String> METHOD_NAME_TRANSFORMER;

    static {
        executeStaticMethod_field = UNINITIALIZED;
        executeStaticMethod_field_ = UNINITIALIZED_;
        executeStaticMethodWithParm_field = UNINITIALIZED;
        executeStaticMethodWithParm_field_ = UNINITIALIZED_;
        FIELD_NAME_TRANSFORMER = new FieldNameTransformer();
        METHOD_NAME_TRANSFORMER = new MethodNameTransformer();
    }

    public ClassToolsTests(String name) {
        super(name);
    }

    public void testForNameString() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName((String)className);
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForNameString_exception() throws Exception {
        boolean exCaught;
        block2: {
            String className = "java.lang.XXXX";
            exCaught = false;
            try {
                Class clazz = ClassTools.forName((String)className);
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForNameCharArray() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName((char[])className.toCharArray());
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForNameCharArray_exception() throws Exception {
        boolean exCaught;
        block2: {
            String className = "java.lang.XXXX";
            exCaught = false;
            try {
                Class clazz = ClassTools.forName((char[])className.toCharArray());
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForName_CharArray() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName_((char[])className.toCharArray());
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForName_CharArray_exception() throws Exception {
        String className = "java.lang.XXXX";
        boolean exCaught = false;
        try {
            Class clazz = ClassTools.forName_((char[])className.toCharArray());
            ClassToolsTests.fail((String)("bogus: " + clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForNameStringBooleanClassLoader() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName((String)className, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForNameStringBooleanClassLoader_exception() throws Exception {
        boolean exCaught;
        block2: {
            String className = "java.lang.XXXX";
            exCaught = false;
            try {
                Class clazz = ClassTools.forName((String)className, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForNameCharArrayBooleanClassLoader() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName((char[])className.toCharArray(), (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForNameCharArrayBooleanClassLoader_exception() throws Exception {
        boolean exCaught;
        block2: {
            String className = "java.lang.XXXX";
            exCaught = false;
            try {
                Class clazz = ClassTools.forName((char[])className.toCharArray(), (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForName_CharArrayBooleanClassLoader() throws Exception {
        String className = "java.lang.String";
        Class clazz = ClassTools.forName_((char[])className.toCharArray(), (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ClassToolsTests.assertNotNull((Object)clazz);
        ClassToolsTests.assertEquals((String)className, (String)clazz.getName());
        String s = (String)clazz.newInstance();
        ClassToolsTests.assertNotNull((Object)s);
    }

    public void testForName_CharArrayBooleanClassLoader_exception() throws Exception {
        String className = "java.lang.XXXX";
        boolean exCaught = false;
        try {
            Class clazz = ClassTools.forName_((char[])className.toCharArray(), (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            ClassToolsTests.fail((String)("bogus: " + clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            exCaught = true;
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testToStringName() {
        ClassToolsTests.assertEquals((String)((Object)((Object)this)).getClass().getSimpleName(), (String)ClassTools.toStringName(((Object)((Object)this)).getClass()));
    }

    public void testToStringName_anonymous() {
        CommandAdapter command = new CommandAdapter(){

            public void execute() {
            }
        };
        ClassToolsTests.assertEquals((String)"CommandAdapter", (String)ClassTools.toStringName(command.getClass()));
    }

    public void testToStringName_member() {
        LocalCommand command = new LocalCommand();
        ClassToolsTests.assertEquals((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".LocalCommand"), (String)ClassTools.toStringName(((Object)((Object)command)).getClass()));
    }

    public void testAllSuperclasses() {
        Iterator superclasses = ClassTools.allSuperclasses(Vector.class).iterator();
        ClassToolsTests.assertEquals(superclasses.next(), AbstractList.class);
        ClassToolsTests.assertEquals(superclasses.next(), AbstractCollection.class);
        ClassToolsTests.assertEquals(superclasses.next(), Object.class);
    }

    public void testAllSuperclasses_Object() {
        Iterator superclasses = ClassTools.allSuperclasses(Object.class).iterator();
        ClassToolsTests.assertFalse((boolean)superclasses.hasNext());
    }

    public void testAllInterfaces() {
        int count = 0;
        count += Vector.class.getInterfaces().length;
        count += AbstractList.class.getInterfaces().length;
        count += AbstractCollection.class.getInterfaces().length;
        Iterable interfaces = ClassTools.allInterfaces(Vector.class);
        ClassToolsTests.assertEquals((int)(count += Object.class.getInterfaces().length), (int)IterableTools.size((Iterable)interfaces));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains((Iterable)interfaces, List.class));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains((Iterable)interfaces, RandomAccess.class));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains((Iterable)interfaces, Collection.class));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains((Iterable)interfaces, Cloneable.class));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains((Iterable)interfaces, Serializable.class));
    }

    public void testAllInterfaces_Object() {
        Iterator interfaces = ClassTools.allInterfaces(Object.class).iterator();
        ClassToolsTests.assertFalse((boolean)interfaces.hasNext());
    }

    public void testGet() {
        ClassToolsTests.assertEquals((Object)TEST_STATIC_FINAL_FIELD, (Object)ClassTools.get(((Object)((Object)this)).getClass(), (String)"TEST_STATIC_FINAL_FIELD"));
    }

    public void testGet_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object value = ClassTools.get(((Object)((Object)this)).getClass(), (String)"BOGUS");
                ClassToolsTests.fail((String)("bogus: " + value));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testSet() {
        ClassTools.set(((Object)((Object)this)).getClass(), (String)"testStaticField", (Object)"new value");
        ClassToolsTests.assertEquals((String)testStaticField, (String)"new value");
    }

    public void testSet_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                ClassTools.set(((Object)((Object)this)).getClass(), (String)"bogusStaticField", (Object)"new value");
                ClassToolsTests.fail();
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testField() {
        ClassToolsTests.assertNotNull((Object)ClassTools.field(((Object)((Object)this)).getClass(), (String)"testStaticField"));
    }

    public void testField_superclass() {
        ClassToolsTests.assertNotNull((Object)ClassTools.field(((Object)((Object)this)).getClass(), (String)"fName"));
    }

    public void testField_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Field field = ClassTools.field(((Object)((Object)this)).getClass(), (String)"BOGUS");
                ClassToolsTests.fail((String)("bogus: " + field));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAllFields() {
        int fieldCount = 0;
        fieldCount += Vector.class.getDeclaredFields().length;
        fieldCount += AbstractList.class.getDeclaredFields().length;
        fieldCount += AbstractCollection.class.getDeclaredFields().length;
        Iterable fields = ClassTools.allFields(Vector.class);
        ClassToolsTests.assertEquals((int)(fieldCount += Object.class.getDeclaredFields().length), (int)IterableTools.size((Iterable)fields));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"modCount"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"serialVersionUID"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"capacityIncrement"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"elementCount"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.fieldNames(fields), (Object)"elementData"));
        ClassToolsTests.assertTrue((boolean)((Field)fields.iterator().next()).isAccessible());
    }

    public void testExecute() {
        ClassToolsTests.assertEquals((String)UNINITIALIZED, (String)executeStaticMethod_field);
        ClassToolsTests.assertNull((Object)ClassTools.execute(((Object)((Object)this)).getClass(), (String)"executeStaticMethod"));
        ClassToolsTests.assertEquals((String)TOUCHED, (String)executeStaticMethod_field);
    }

    public static void executeStaticMethod() {
        executeStaticMethod_field = TOUCHED;
    }

    public void testExecute_() throws Exception {
        ClassToolsTests.assertEquals((String)UNINITIALIZED_, (String)executeStaticMethod_field_);
        ClassToolsTests.assertNull((Object)ClassTools.execute_(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_"));
        ClassToolsTests.assertEquals((String)TOUCHED_, (String)executeStaticMethod_field_);
    }

    public static void executeStaticMethod_() {
        executeStaticMethod_field_ = TOUCHED_;
    }

    public void testExecute_returnValue() {
        ClassToolsTests.assertEquals((Object)STATIC_RETURN_VALUE, (Object)ClassTools.execute(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_returnValue"));
    }

    public static String executeStaticMethod_returnValue() {
        return STATIC_RETURN_VALUE;
    }

    public void testExecute_noSuchMethod() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object value = ClassTools.execute(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_BOGUS");
                ClassToolsTests.fail((String)("bogus: " + value));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testExecute_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object value = ClassTools.execute(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_exception");
                ClassToolsTests.fail((String)("bogus: " + value));
            }
            catch (RuntimeException ex1) {
                Throwable cause2;
                Throwable cause1 = ex1.getCause();
                if (!(cause1 instanceof InvocationTargetException) || !((cause2 = ((InvocationTargetException)cause1).getCause()) instanceof NullPointerException) || !cause2.getMessage().equals("class tools test")) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public static String executeStaticMethod_exception() {
        throw new NullPointerException("class tools test");
    }

    public void testExecuteWithParm() {
        ClassToolsTests.assertEquals((String)UNINITIALIZED, (String)executeStaticMethodWithParm_field);
        ClassTools.execute(((Object)((Object)this)).getClass(), (String)"executeStaticMethodWithParm", String.class, (Object)TOUCHED);
        ClassToolsTests.assertEquals((String)TOUCHED, (String)executeStaticMethodWithParm_field);
    }

    public static void executeStaticMethodWithParm(String value) {
        executeStaticMethodWithParm_field = value;
    }

    public void testExecuteWithParm_() throws Exception {
        ClassToolsTests.assertEquals((String)UNINITIALIZED_, (String)executeStaticMethodWithParm_field_);
        ClassTools.execute_(((Object)((Object)this)).getClass(), (String)"executeStaticMethodWithParm_", String.class, (Object)TOUCHED_);
        ClassToolsTests.assertEquals((String)TOUCHED_, (String)executeStaticMethodWithParm_field_);
    }

    public static void executeStaticMethodWithParm_(String value) {
        executeStaticMethodWithParm_field_ = value;
    }

    public void testMethod() {
        ClassToolsTests.assertNotNull((Object)ClassTools.method(((Object)((Object)this)).getClass(), (String)"testMethod"));
    }

    public void testMethod_superclass() {
        ClassToolsTests.assertNotNull((Object)ClassTools.method(((Object)((Object)this)).getClass(), (String)"run"));
    }

    public void testMethod_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.method_(((Object)((Object)this)).getClass(), (String)"testMethod_"));
    }

    public void testMethodWithParm() {
        ClassToolsTests.assertNotNull((Object)ClassTools.method(((Object)((Object)this)).getClass(), (String)"methodWithParm", String.class));
    }

    public void testMethodWithParm_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.method_(((Object)((Object)this)).getClass(), (String)"methodWithParm", String.class));
    }

    public void methodWithParm(String parm) {
        ClassToolsTests.assertNotNull((Object)parm);
    }

    public void testMethod_noSuchMethod() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Method method = ClassTools.method(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_BOGUS");
                ClassToolsTests.fail((String)("bogus: " + method));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testStaticMethod() {
        ClassToolsTests.assertNotNull((Object)ClassTools.staticMethod(((Object)((Object)this)).getClass(), (String)"staticTestMethod"));
    }

    public void testStaticMethod_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.staticMethod_(((Object)((Object)this)).getClass(), (String)"staticTestMethod"));
    }

    public static void staticTestMethod() {
    }

    public void testStaticMethodWithParm() {
        ClassToolsTests.assertNotNull((Object)ClassTools.staticMethod(((Object)((Object)this)).getClass(), (String)"staticTestMethodWithParm", String.class));
    }

    public void testStaticMethodWithParm_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.staticMethod_(((Object)((Object)this)).getClass(), (String)"staticTestMethodWithParm", String.class));
    }

    public static void staticTestMethodWithParm(String string) {
        ClassToolsTests.assertNotNull((Object)string);
    }

    public void testStaticMethod_noSuchMethod() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Method method = ClassTools.staticMethod(((Object)((Object)this)).getClass(), (String)"executeStaticMethod_BOGUS");
                ClassToolsTests.fail((String)("bogus: " + method));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAllMethods() {
        int methodCount = 0;
        methodCount += Vector.class.getDeclaredMethods().length;
        methodCount += AbstractList.class.getDeclaredMethods().length;
        methodCount += AbstractCollection.class.getDeclaredMethods().length;
        Iterable methods = ClassTools.allMethods(Vector.class);
        ClassToolsTests.assertEquals((int)(methodCount += Object.class.getDeclaredMethods().length), (int)IterableTools.size((Iterable)methods));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.methodNames(methods), (Object)"wait"));
        ClassToolsTests.assertTrue((boolean)IterableTools.contains(this.methodNames(methods), (Object)"addElement"));
        ClassToolsTests.assertTrue((boolean)((Method)methods.iterator().next()).isAccessible());
    }

    public void testNewInstanceClass() {
        Vector v = (Vector)ClassTools.newInstance(Vector.class);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClass_() throws Exception {
        Vector v = (Vector)ClassTools.newInstance_(Vector.class);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClassClassObject() {
        int initialCapacity = 200;
        Vector v = (Vector)ClassTools.newInstance(Vector.class, Integer.TYPE, (Object)new Integer(initialCapacity));
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ObjectTools.get((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassObject_() throws Exception {
        int initialCapacity = 200;
        Vector v = (Vector)ClassTools.newInstance_(Vector.class, Integer.TYPE, (Object)new Integer(initialCapacity));
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ObjectTools.get((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray() {
        int initialCapacity = 200;
        Class[] parmTypes = new Class[]{Integer.TYPE};
        Object[] args = new Object[]{new Integer(initialCapacity)};
        Vector v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])args);
        ClassToolsTests.assertNotNull((Object)v);
        ClassToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ObjectTools.get((Object)v, (String)"elementData");
        ClassToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray_exception() {
        boolean exCaught;
        block4: {
            Vector v;
            Class[] parmTypes = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{new Integer(-1)};
            exCaught = false;
            try {
                v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])args);
                ClassToolsTests.fail((String)("bogus: " + v));
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
            ClassToolsTests.assertTrue((String)"RuntimeException not thrown", (boolean)exCaught);
            parmTypes[0] = String.class;
            args[0] = STATIC_RETURN_VALUE;
            exCaught = false;
            try {
                v = (Vector)ClassTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])args);
                ClassToolsTests.fail((String)("bogus: " + v));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((String)"NoSuchMethodException not thrown", (boolean)exCaught);
    }

    public void testDefaultConstructor() {
        ClassToolsTests.assertNotNull((Object)ClassTools.defaultConstructor(Vector.class));
    }

    public void testDefaultConstructor_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.defaultConstructor_(Vector.class));
    }

    public void testConstructor() {
        ClassToolsTests.assertNotNull((Object)ClassTools.constructor(Vector.class));
    }

    public void testConstructor_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.constructor_(Vector.class));
    }

    public void testConstructorClass() {
        ClassToolsTests.assertNotNull((Object)ClassTools.constructor(Vector.class, Integer.TYPE));
    }

    public void testConstructorClass_() throws Exception {
        ClassToolsTests.assertNotNull((Object)ClassTools.constructor_(Vector.class, Integer.TYPE));
    }

    public void testConstructor_noSuchMethod() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Constructor ctor = ClassTools.constructor(((Object)((Object)this)).getClass());
                ClassToolsTests.fail((String)("bogus: " + ctor));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testExecuteClassString() {
        Double randomObject = (Double)ClassTools.execute(Math.class, (String)"random");
        ClassToolsTests.assertNotNull((Object)randomObject);
        double random = randomObject;
        ClassToolsTests.assertTrue((random >= 0.0 ? 1 : 0) != 0);
        ClassToolsTests.assertTrue((random < 1.0 ? 1 : 0) != 0);
    }

    public void testExecuteClassStringClassObject() {
        String s = (String)ClassTools.execute(String.class, (String)"valueOf", Boolean.TYPE, (Object)Boolean.TRUE);
        ClassToolsTests.assertNotNull((Object)s);
        ClassToolsTests.assertEquals((String)"true", (String)s);
    }

    public void testExecuteClassStringClassArrayObjectArray() {
        Object bogusStaticMethodReturnValue;
        boolean exCaught;
        block5: {
            block4: {
                Class[] parmTypes = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{Boolean.TRUE};
                String s = (String)ClassTools.execute(String.class, (String)"valueOf", (Class[])parmTypes, (Object[])args);
                ClassToolsTests.assertNotNull((Object)s);
                ClassToolsTests.assertEquals((String)"true", (String)s);
                exCaught = false;
                bogusStaticMethodReturnValue = null;
                try {
                    bogusStaticMethodReturnValue = ClassTools.execute(String.class, (String)"bogusStaticMethod", (Class[])parmTypes, (Object[])args);
                }
                catch (RuntimeException ex) {
                    if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                    exCaught = true;
                }
            }
            ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
            exCaught = false;
            try {
                bogusStaticMethodReturnValue = ClassTools.execute(String.class, (String)"toString");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block5;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
    }

    public void testSimpleName() {
        ClassToolsTests.assertEquals((String)"Vector", (String)Vector.class.getSimpleName());
        ClassToolsTests.assertEquals((String)"Entry", (String)Map.Entry.class.getSimpleName());
        ClassToolsTests.assertEquals((String)"int", (String)Integer.TYPE.getSimpleName());
        ClassToolsTests.assertEquals((String)"int[]", (String)int[].class.getSimpleName());
        ClassToolsTests.assertEquals((String)"int[][]", (String)int[][].class.getSimpleName());
        ClassToolsTests.assertEquals((String)"void", (String)Void.TYPE.getSimpleName());
    }

    public void testPackageName() {
        ClassToolsTests.assertEquals((String)"java.util", (String)Vector.class.getPackage().getName());
        ClassToolsTests.assertEquals((String)"java.util", (String)Map.Entry.class.getPackage().getName());
    }

    public void testArrayDepth() {
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Vector.class));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Integer.TYPE));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.arrayDepth(Void.TYPE));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepth(Vector[].class));
        ClassToolsTests.assertEquals((int)1, (int)ClassTools.arrayDepth(int[].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepth(Vector[][][].class));
        ClassToolsTests.assertEquals((int)3, (int)ClassTools.arrayDepth(int[][][].class));
    }

    public void testElementType() {
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector.class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(Integer.TYPE));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.elementType(Void.TYPE));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector[].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(int[].class));
        ClassToolsTests.assertEquals(Vector.class, (Object)ClassTools.elementType(Vector[][][].class));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.elementType(int[][][].class));
    }

    public void testIsPrimitiveWrapper() {
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isPrimitiveWrapper(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(new int[0].getClass()));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(((Object)((Object)this)).getClass()));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(new String[0].getClass()));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isPrimitiveWrapper(Integer.TYPE));
    }

    public void testIsVariablePrimitiveWrapper() {
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Void.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Boolean.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Integer.class));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitiveWrapper(Float.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitiveWrapper(Integer.TYPE));
    }

    public void testIsVariablePrimitive() {
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitive(Boolean.TYPE));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitive(Integer.TYPE));
        ClassToolsTests.assertTrue((boolean)ClassTools.isVariablePrimitive(Float.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitive(Void.TYPE));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitive(Void.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitive(String.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitive(Boolean.class));
        ClassToolsTests.assertFalse((boolean)ClassTools.isVariablePrimitive(Integer.class));
    }

    public void testPrimitiveWrapper() {
        ClassToolsTests.assertEquals(Void.class, (Object)ClassTools.primitiveWrapper(Void.TYPE));
        ClassToolsTests.assertEquals(Integer.class, (Object)ClassTools.primitiveWrapper(Integer.TYPE));
        ClassToolsTests.assertEquals(Float.class, (Object)ClassTools.primitiveWrapper(Float.TYPE));
        ClassToolsTests.assertEquals(Boolean.class, (Object)ClassTools.primitiveWrapper(Boolean.TYPE));
        ClassToolsTests.assertNull((Object)ClassTools.primitiveWrapper(String.class));
    }

    public void testPrimitiveForCode_char() {
        ClassToolsTests.assertEquals(Byte.TYPE, (Object)ClassTools.primitiveForCode((char)'B'));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.primitiveForCode((char)'I'));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.primitiveForCode((char)'V'));
        ClassToolsTests.assertNull((Object)ClassTools.primitiveForCode((char)'X'));
    }

    public void testPrimitiveForCode_int() {
        ClassToolsTests.assertEquals(Byte.TYPE, (Object)ClassTools.primitiveForCode((int)66));
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.primitiveForCode((int)73));
        ClassToolsTests.assertEquals(Void.TYPE, (Object)ClassTools.primitiveForCode((int)86));
        ClassToolsTests.assertNull((Object)ClassTools.primitiveForCode((int)88));
    }

    public void testPrimitiveCode() {
        ClassToolsTests.assertEquals((char)'I', (char)ClassTools.primitiveCode(Integer.TYPE));
        ClassToolsTests.assertEquals((char)'B', (char)ClassTools.primitiveCode(Byte.TYPE));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.primitiveCode(new byte[0].getClass()));
        ClassToolsTests.assertEquals((int)0, (int)ClassTools.primitiveCode(((Object)((Object)this)).getClass()));
    }

    public void testForTypeDeclarationString() {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.String"));
    }

    public void testForTypeDeclarationString_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Class clazz = ClassTools.forTypeDeclaration((String)"java.lang.BOGUS");
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForTypeDeclarationCharArray() {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration((char[])"java.lang.String".toCharArray()));
    }

    public void testForTypeDeclarationCharArray_exception() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Class clazz = ClassTools.forTypeDeclaration((char[])"java.lang.BOGUS".toCharArray());
                ClassToolsTests.fail((String)("bogus: " + clazz));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForTypeDeclarationString_() throws Exception {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration_((String)"java.lang.String"));
    }

    public void testForTypeDeclarationCharArray_() throws Exception {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration_((char[])"java.lang.String".toCharArray()));
    }

    public void testForTypeDeclarationStringClassLoader() {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.String", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void testForTypeDeclarationCharArrayClassLoader() {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration((char[])"java.lang.String".toCharArray(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void testForTypeDeclarationStringClassLoader_() throws Exception {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration_((String)"java.lang.String", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void testForTypeDeclarationCharArrayClassLoader_() throws Exception {
        ClassToolsTests.assertEquals(String.class, (Object)ClassTools.forTypeDeclaration_((char[])"java.lang.String".toCharArray(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void testForTypeDeclarationStringInt() throws Exception {
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.forTypeDeclaration((String)"int", (int)0));
        ClassToolsTests.assertEquals(int[].class, (Object)ClassTools.forTypeDeclaration((String)"int", (int)1));
        ClassToolsTests.assertEquals(int[][][].class, (Object)ClassTools.forTypeDeclaration((String)"int", (int)3));
        ClassToolsTests.assertEquals(Object.class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.Object", (int)0));
        ClassToolsTests.assertEquals(Object[][][].class, (Object)ClassTools.forTypeDeclaration((String)"java.lang.Object", (int)3));
    }

    public void testForTypeDeclarationStringInt_exception() throws Exception {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                ClassTools.forTypeDeclaration((String)Void.TYPE.getName(), (int)1);
                ClassToolsTests.fail((String)"should not get here...");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForTypeDeclarationCharArrayInt() throws Exception {
        ClassToolsTests.assertEquals(Integer.TYPE, (Object)ClassTools.forTypeDeclaration((char[])"int".toCharArray(), (int)0));
        ClassToolsTests.assertEquals(int[].class, (Object)ClassTools.forTypeDeclaration((char[])"int".toCharArray(), (int)1));
        ClassToolsTests.assertEquals(int[][][].class, (Object)ClassTools.forTypeDeclaration((char[])"int".toCharArray(), (int)3));
        ClassToolsTests.assertEquals(Object.class, (Object)ClassTools.forTypeDeclaration((char[])"java.lang.Object".toCharArray(), (int)0));
        ClassToolsTests.assertEquals(Object[][][].class, (Object)ClassTools.forTypeDeclaration((char[])"java.lang.Object".toCharArray(), (int)3));
    }

    public void testForTypeDeclarationCharArrayInt_exception() throws Exception {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                ClassTools.forTypeDeclaration((char[])Void.TYPE.getName().toCharArray(), (int)1);
                ClassToolsTests.fail((String)"should not get here...");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof ClassNotFoundException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    public void testForTypeDeclarationStringInt_() throws Exception {
        ClassToolsTests.assertEquals(new String[0][0].getClass(), (Object)ClassTools.forTypeDeclaration_((String)"java.lang.String", (int)2));
    }

    public void testForTypeDeclarationCharArrayInt_() throws Exception {
        ClassToolsTests.assertEquals(new String[0][0].getClass(), (Object)ClassTools.forTypeDeclaration_((char[])"java.lang.String".toCharArray(), (int)2));
    }

    public void testBuildMethodSignature() {
        ClassToolsTests.assertEquals((String)"foo(java.lang.String)", (String)ClassTools.buildMethodSignature((String)STATIC_RETURN_VALUE, (Class[])new Class[]{String.class}));
    }

    private Iterable<String> fieldNames(Iterable<Field> fields) {
        return new TransformationIterable(fields, FIELD_NAME_TRANSFORMER);
    }

    private Iterable<String> methodNames(Iterable<Method> methods) {
        return new TransformationIterable(methods, METHOD_NAME_TRANSFORMER);
    }

    public void testClassToolsConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(ClassTools.class);
                ClassToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ClassToolsTests.assertTrue((boolean)exCaught);
    }

    static class FieldNameTransformer
    extends TransformerAdapter<Field, String> {
        FieldNameTransformer() {
        }

        public String transform(Field field) {
            return field.getName();
        }
    }

    public static class LocalCommand
    extends CommandAdapter {
        public void execute() {
        }
    }

    static class MethodNameTransformer
    extends TransformerAdapter<Method, String> {
        MethodNameTransformer() {
        }

        public String transform(Method method) {
            return method.getName();
        }
    }
}

