/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.text.MessageFormat;
import org.easymock.EasyMock;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DirectEditAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DirectEditAttributeFeatureTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testCheckValueValidStringByJavaConventions() {
        PersistentType jpt = (PersistentType)EasyMock.createNiceMock(PersistentType.class);
        PersistentAttribute jpa = this.configureJpaForJpt(jpt);
        EasyMock.expect((Object)jpt.getAttributeNamed((String)EasyMock.isA(String.class))).andStubReturn((Object)jpa);
        EasyMock.replay((Object[])new Object[]{jpa, jpt});
        IFeatureProvider provider = this.replayJpaForNullPe(jpa);
        IDirectEditingContext context = this.replayNullPeContext();
        DirectEditAttributeFeature feature = new DirectEditAttributeFeature(provider);
        this.assertNotValidJavaConventionField((IDirectEditingFeature)feature, context, "");
        this.assertNotValidJavaConventionField((IDirectEditingFeature)feature, context, "1a");
        this.assertNotValidJavaConventionField((IDirectEditingFeature)feature, context, "d d");
        this.assertValidField((IDirectEditingFeature)feature, context, "$d");
        this.assertNotValidJavaConventionField((IDirectEditingFeature)feature, context, "enum");
    }

    @Test
    public void testCheckValueValidStringDuplicateAttribute() {
        PersistentAttribute otherJpa = (PersistentAttribute)EasyMock.createMock(PersistentAttribute.class);
        PersistentType jpt = (PersistentType)EasyMock.createMock(PersistentType.class);
        EasyMock.expect((Object)jpt.getAttributeNamed("attrName")).andStubReturn((Object)otherJpa);
        PersistentAttribute jpa = this.configureJpaForJpt(jpt);
        EasyMock.replay((Object[])new Object[]{jpa, jpt, otherJpa});
        IFeatureProvider provider = this.replayJpaForNullPe(jpa);
        IDirectEditingContext context = this.replayNullPeContext();
        DirectEditAttributeFeature feature = new DirectEditAttributeFeature(provider);
        Assert.assertEquals((Object)MessageFormat.format(JPAEditorMessages.DirectEditAttributeFeature_attributeExists, "attrName"), (Object)feature.checkValueValid("attrName", context));
    }

    private IFeatureProvider replayJpaForNullPe(PersistentAttribute jpa) {
        IFeatureProvider provider = (IFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)provider.getBusinessObjectForPictogramElement(null)).andStubReturn((Object)jpa);
        EasyMock.replay((Object[])new Object[]{provider});
        return provider;
    }

    private PersistentAttribute configureJpaForJpt(PersistentType jpt) {
        PersistentAttribute jpa = (PersistentAttribute)EasyMock.createMock(PersistentAttribute.class);
        EasyMock.expect((Object)jpa.getParent()).andStubReturn((Object)jpt);
        return jpa;
    }

    private IDirectEditingContext replayNullPeContext() {
        IDirectEditingContext context = (IDirectEditingContext)EasyMock.createMock(IDirectEditingContext.class);
        EasyMock.expect((Object)context.getPictogramElement()).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{context});
        return context;
    }

    private void assertValidField(IDirectEditingFeature feature, IDirectEditingContext context, String field) {
        Assert.assertEquals(null, (Object)feature.checkValueValid(field, context));
    }

    private void assertNotValidJavaConventionField(IDirectEditingFeature feature, IDirectEditingContext context, String field) {
        Assert.assertEquals((Object)JavaConventions.validateFieldName((String)field, (String)"1.5", (String)"1.5").getMessage(), (Object)feature.checkValueValid(field, context));
    }
}

