/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDomLoadListener;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public class JaxWsWorkspaceResourceTests
extends TestCase {
    private TestProject testProject;
    private IPackageFragment pf;
    private IJavaModel javaModel;

    public void setUp() throws Exception {
        super.setUp();
        this.testProject = new TestProject();
        this.testProject.createSourceFolder("src");
        this.pf = this.testProject.createPackage("com.sap.test.smoke");
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public void test_Smoke_OneWsAndOneSei() throws CoreException, IOException {
        EList seis;
        this.testProject.createType(this.pf, "Sei1.java", "@javax.jws.WebService public interface Sei1 {}");
        this.testProject.createType(this.pf, "WebService1.java", "@javax.jws.WebService(endpointInterface=\"com.sap.test.smoke.Sei1\") public class WebService1{}");
        JaxWsWorkspaceResource target = this.createJaxWsWorkspaceResource(this.testProject);
        target.load(null);
        EList projects = target.getDOM().getWebServiceProjects();
        IWebServiceProject testWsProject = null;
        for (IWebServiceProject aProject : projects) {
            if (!aProject.getName().equals(this.testProject.getJavaProject().getElementName())) continue;
            testWsProject = aProject;
            break;
        }
        if (testWsProject == null) {
            JaxWsWorkspaceResourceTests.fail((String)("WebServiceProject wit name " + this.testProject.getJavaProject().getElementName() + "is not found in the model"));
        }
        JaxWsWorkspaceResourceTests.assertTrue((String)"More than 1 sei found in the model, while only one test sei was used", ((seis = testWsProject.getServiceEndpointInterfaces()).size() == 1 ? 1 : 0) != 0);
        JaxWsWorkspaceResourceTests.assertEquals((String)"The sei in the model is with different name", (String)"Sei1", (String)((IServiceEndpointInterface)seis.get(0)).getName());
        JaxWsWorkspaceResourceTests.assertEquals((String)"The sei in the model is with different implementation", (String)"com.sap.test.smoke.Sei1", (String)((IServiceEndpointInterface)seis.get(0)).getImplementation());
        EList webServices = testWsProject.getWebServices();
        JaxWsWorkspaceResourceTests.assertTrue((String)"More than 1 web service found in the model, while only one test web service was used", (webServices.size() == 1 ? 1 : 0) != 0);
        JaxWsWorkspaceResourceTests.assertEquals((String)"The web service in the model is with different name", (String)"WebService1Service", (String)((IWebService)webServices.get(0)).getName());
        JaxWsWorkspaceResourceTests.assertEquals((String)"The web service in the model is with different implementation", (String)"com.sap.test.smoke.WebService1", (String)((IWebService)webServices.get(0)).getImplementation());
        JaxWsWorkspaceResourceTests.assertSame((String)"The service endpoint found in the model is not the same instance as the sei of the web service", (Object)((IWebService)webServices.get(0)).getServiceEndpoint(), seis.get(0));
    }

    public void test_DomLoadedForNoProcessedProjects() throws IOException {
        JaxWsWorkspaceResource target = new JaxWsWorkspaceResource(this.javaModel){

            public IProjectSelector[] getProjectSelectors() {
                return new IProjectSelector[]{new IProjectSelector(){

                    public boolean approve(IJavaProject prj) {
                        return false;
                    }
                }};
            }
        };
        target.load(null);
        JaxWsWorkspaceResourceTests.assertNotNull((Object)target.getDOM());
        JaxWsWorkspaceResourceTests.assertEquals((int)0, (int)target.getDOM().getWebServiceProjects().size());
    }

    private JaxWsWorkspaceResource createJaxWsWorkspaceResource(final TestProject testProject) {
        return new JaxWsWorkspaceResource(this.javaModel){

            public IProjectSelector[] getProjectSelectors() {
                return new IProjectSelector[]{new IProjectSelector(){

                    public boolean approve(IJavaProject prj) {
                        return prj.getElementName().equals(testProject.getJavaProject().getElementName());
                    }
                }};
            }
        };
    }

    protected class LoadListener
    implements IWsDomLoadListener {
        boolean startCalled;
        boolean finishedCalled;

        protected LoadListener() {
        }

        public void finished() {
            this.finishedCalled = true;
        }

        public void started() {
            this.startCalled = true;
        }
    }
}

