/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.tests.validation;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.html.core.validate.extension.CustomValidatorUtil;
import org.eclipse.wst.html.core.validate.extension.IHTMLCustomTagValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.junit.Assert;

public class CustomExtendedTagValidator
implements IHTMLCustomTagValidator {
    private String currentFileLocation;

    public boolean canValidate(IDOMElement target) {
        return target.getLocalName().startsWith("eclipse");
    }

    public void init(IStructuredDocument doc) {
        this.currentFileLocation = this.getResource((IDocument)doc);
    }

    public ValidationMessage validateTag(IDOMElement target) {
        Assert.assertEquals((Object)this.currentFileLocation, (Object)this.getResource((IDocument)target.getStructuredDocument()));
        String tagName = target.getLocalName();
        if (tagName.indexOf("thym") >= 0) {
            Segment segment = CustomValidatorUtil.getTagSegment((IDOMNode)target, (int)4);
            return new ValidationMessage("Thym is available only with external installation", segment.getOffset(), segment.getLength(), 1);
        }
        return null;
    }

    private String getResource(IDocument document) {
        if (document == null) {
            return null;
        }
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null) {
                String string = sModel.getBaseLocation();
                return string;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return null;
    }
}

