/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class JsStorageEditorInput
implements IStorageEditorInput {
    IStorage fStorage;

    public JsStorageEditorInput(IStorage storage) {
        this.fStorage = storage;
    }

    public JsStorageEditorInput(String contents, IPath path) {
        this(new JSStorage(contents, path));
    }

    public boolean exists() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fStorage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        return this.fStorage;
    }

    public String getToolTipText() {
        return this.fStorage.getFullPath().toString();
    }

    private static class JSStorage
    implements IStorage {
        private String fContents;
        private IPath fPath;

        public JSStorage(String contents, IPath path) {
            this.fContents = contents;
            this.fPath = path;
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.fContents.getBytes());
        }

        public IPath getFullPath() {
            return this.fPath;
        }

        public String getName() {
            return this.fPath.lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

