/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptThread;

public abstract class DebugElementImpl
extends PlatformObject
implements IDebugElement {
    public abstract DebugTargetImpl getDebugTarget();

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getChromiumModelIdentifier();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDebugElement.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public static class WithConnected
    extends WithConnectedBase {
        private final ConnectedTargetData connectedTargetData;

        public WithConnected(ConnectedTargetData connectedTargetData) {
            this.connectedTargetData = connectedTargetData;
        }

        @Override
        public ConnectedTargetData getConnectedData() {
            return this.connectedTargetData;
        }
    }

    public static abstract class WithConnectedBase
    extends DebugElementImpl {
        @Override
        public DebugTargetImpl getDebugTarget() {
            return this.getConnectedData().getDebugTarget();
        }

        public abstract ConnectedTargetData getConnectedData();
    }

    public static class WithEvaluate
    extends WithEvaluateBase {
        private final EvaluateContext evaluateContext;

        public WithEvaluate(EvaluateContext evaluateContext) {
            this.evaluateContext = evaluateContext;
        }

        @Override
        public EvaluateContext getEvaluateContext() {
            return this.evaluateContext;
        }
    }

    public static abstract class WithEvaluateBase
    extends WithSuspendedBase {
        @Override
        public JavascriptThread.SuspendedState getSuspendedState() {
            return this.getEvaluateContext().getThreadSuspendedState();
        }

        public abstract EvaluateContext getEvaluateContext();
    }

    public static class WithSuspended
    extends WithSuspendedBase {
        private final JavascriptThread.SuspendedState suspendedState;

        public WithSuspended(JavascriptThread.SuspendedState suspendedState) {
            this.suspendedState = suspendedState;
        }

        @Override
        public JavascriptThread.SuspendedState getSuspendedState() {
            return this.suspendedState;
        }
    }

    public static abstract class WithSuspendedBase
    extends WithConnectedBase {
        @Override
        public ConnectedTargetData getConnectedData() {
            return this.getSuspendedState().getThread().getConnectedData();
        }

        public abstract JavascriptThread.SuspendedState getSuspendedState();
    }
}

