/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.text;

import com.ibm.wsdl.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.ClassloaderWSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.logging.ILogger;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverDelegate;
import org.eclipse.wst.wsdl.validation.internal.ui.text.WSDLValidateTextUIMessages;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ClassloaderWSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogEntityHolder;

public class WSDLValidate {
    private final String FILE_PREFIX = "file:///";
    private static final String VALIDATOR_PROPERTIES = "validatewsdl";
    protected static final String PARAM_WSDL11VAL = "-wsdl11v";
    protected static final String PARAM_EXTVAL = "-extv";
    protected static final String PARAM_SCHEMADIR = "-schemaDir";
    protected static final String PARAM_SCHEMA = "-schema";
    protected static final String PARAM_URIRESOLVER = "-uriresolver";
    protected static final String PARAM_LOGGER = "-logger";
    protected static final String PARAM_PROPERTY = "-D";
    protected static final String PARAM_VERBOSE = "-verbose";
    protected static final String PARAM_VERBOSE_SHORT = "-v";
    private static final String STRING_EMPTY = "";
    private static final String STRING_SPACE = " ";
    private static final String STRING_DASH = "-";
    String workingdir = System.getProperty("user.dir");
    protected WSDLValidator wsdlValidator = null;
    protected WSDLValidationConfiguration configuration = null;
    protected List wsdlFiles = new ArrayList();
    protected boolean verbose = false;
    protected ResourceBundle validatorRB = null;

    protected WSDLValidate() {
        this.wsdlValidator = new WSDLValidator();
        this.configuration = new WSDLValidationConfiguration();
        try {
            this.validatorRB = ResourceBundle.getBundle(VALIDATOR_PROPERTIES);
        }
        catch (MissingResourceException e) {
            LoggerFactory.getInstance().getLogger().log("Validation failed: Unable to load the WSDL validator properties file.", 0, e);
        }
    }

    protected void validate() {
        ILogger logger = LoggerFactory.getInstance().getLogger();
        int numInvalid = 0;
        for (String wsdlFile : this.wsdlFiles) {
            IValidationReport valReport = this.validateFile(wsdlFile);
            if (valReport.hasErrors()) {
                ++numInvalid;
                logger.log(MessageFormat.format(WSDLValidateTextUIMessages._UI_FILE_INVALID, wsdlFile), 2);
                logger.log(this.getMessages(valReport.getValidationMessages()), 2);
                continue;
            }
            if (!this.verbose) continue;
            logger.log(MessageFormat.format(WSDLValidateTextUIMessages._UI_FILE_VALID, wsdlFile), 3);
        }
        logger.log(MessageFormat.format(WSDLValidateTextUIMessages._UI_VALIDATION_SUMMARY, new Integer(this.wsdlFiles.size()), new Integer(numInvalid)), 2);
    }

    protected IValidationReport validateFile(String filename) {
        String filelocation = null;
        try {
            URL fileURL = StringUtils.getURL((URL)new URL("file:///" + this.workingdir + "/"), (String)filename);
            filelocation = fileURL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {}
        IValidationReport valReport = this.wsdlValidator.validate(filelocation, null, this.configuration);
        return valReport;
    }

    protected String getMessages(IValidationMessage[] messages) {
        StringBuffer outputBuffer = new StringBuffer();
        if (messages != null) {
            int numMessages = messages.length;
            String marker = null;
            int i = 0;
            while (i < numMessages) {
                IValidationMessage message = messages[i];
                int severity = message.getSeverity();
                marker = severity == 0 ? WSDLValidateTextUIMessages._UI_ERROR_MARKER : (severity == 1 ? WSDLValidateTextUIMessages._UI_WARNING_MARKER : STRING_EMPTY);
                outputBuffer.append(marker).append(STRING_SPACE).append(message.getLine()).append(":").append(message.getColumn()).append(STRING_SPACE).append(message.getMessage());
                if (i != numMessages - 1) {
                    outputBuffer.append("\n");
                }
                ++i;
            }
        }
        return outputBuffer.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(WSDLValidateTextUIMessages._ERROR_WRONG_ARGUMENTS);
            System.exit(0);
        }
        WSDLValidate wsdlValidate = new WSDLValidate();
        wsdlValidate.parseArguments(args);
        wsdlValidate.validate();
    }

    protected void parseArguments(String[] args) {
        int numargs = args.length;
        int i = 0;
        while (i < numargs) {
            String param = args[i];
            if (param.equals(PARAM_WSDL11VAL) || param.equals(PARAM_EXTVAL)) {
                String namespace;
                if (!(namespace = args[++i]).startsWith(STRING_DASH)) {
                    String validatorClass;
                    if (!(validatorClass = args[++i]).startsWith(STRING_DASH)) {
                        Object delegate;
                        if (param.equalsIgnoreCase(PARAM_WSDL11VAL)) {
                            delegate = new ClassloaderWSDL11ValidatorDelegate(validatorClass);
                            this.wsdlValidator.registerWSDL11Validator(namespace, (WSDL11ValidatorDelegate)delegate);
                        } else if (param.equalsIgnoreCase(PARAM_EXTVAL)) {
                            delegate = new ClassloaderWSDLValidatorDelegate(validatorClass);
                            this.wsdlValidator.registerWSDLExtensionValidator(namespace, (WSDLValidatorDelegate)delegate);
                        }
                    } else {
                        --i;
                    }
                } else {
                    --i;
                }
            } else if (param.equalsIgnoreCase(PARAM_SCHEMADIR)) {
                String xsdDir = args[++i];
                XMLCatalog.addSchemaDir(xsdDir);
            } else if (param.equalsIgnoreCase(PARAM_SCHEMA)) {
                String publicid = args[++i];
                String systemid = args[++i];
                XMLCatalog.addEntity(new XMLCatalogEntityHolder(publicid, systemid));
            } else if (param.equalsIgnoreCase(PARAM_URIRESOLVER)) {
                String resolverClass = args[++i];
                this.wsdlValidator.addURIResolver(new URIResolverDelegate(resolverClass, null).getURIResolver());
            } else if (param.equals(PARAM_LOGGER)) {
                String loggerClassString = args[++i];
                try {
                    Class<?> loggerClass = WSDLValidate.class.getClassLoader().loadClass(loggerClassString);
                    ILogger logger = (ILogger)loggerClass.newInstance();
                    LoggerFactory.getInstance().setLogger(logger);
                }
                catch (Exception exception) {
                    System.err.println(MessageFormat.format(WSDLValidateTextUIMessages._ERROR_LOADING_LOGGER, loggerClassString));
                }
            } else if (param.startsWith(PARAM_PROPERTY)) {
                int separator = param.indexOf(61);
                String name = param.substring(2, separator);
                String value = param.substring(separator + 1);
                this.configuration.setProperty(name, value);
            } else if (param.equals(PARAM_VERBOSE) || param.equals(PARAM_VERBOSE_SHORT)) {
                this.verbose = true;
            } else if (!param.startsWith(STRING_DASH)) {
                this.wsdlFiles.add(param);
            }
            ++i;
        }
    }
}

