/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.internal.utility.ICUStringCollator;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.properties.JptProjectPropertiesPage;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ControlTools;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.AspectCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ExtendedListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.PredicatePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.libprov.JpaLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.ConnectionAdapter;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileAdapter;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.jpa.ui.JpaProjectModel;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaProjectPropertiesPage
extends JptProjectPropertiesPage {
    public static final String PROP_ID = "org.eclipse.jpt.jpa.ui.jpaProjectProperties";
    private PropertyValueModel<JpaProject> jpaProjectModel;
    private PropertyValueModel<Boolean> jpaProjectIsNotNullFlagModel;
    private BufferedModifiablePropertyValueModel<JpaPlatform.Config> jpaPlatformConfigModel;
    private PropertyChangeListener jpaPlatformConfigListener;
    private BufferedModifiablePropertyValueModel<String> connectionModel;
    private PropertyValueModel<ConnectionProfile> connectionProfileModel;
    private PropertyValueModel<Boolean> disconnectedModel;
    private PropertyChangeListener disconnectedModelListener;
    private Link connectLink;
    private BufferedModifiablePropertyValueModel<Boolean> userOverrideDefaultCatalogFlagModel;
    private BufferedModifiablePropertyValueModel<String> userOverrideDefaultCatalogModel;
    private ModifiablePropertyValueModel<String> defaultCatalogModel;
    private ListValueModel<String> catalogChoicesModel;
    private BufferedModifiablePropertyValueModel<Boolean> userOverrideDefaultSchemaFlagModel;
    private BufferedModifiablePropertyValueModel<String> userOverrideDefaultSchemaModel;
    private ModifiablePropertyValueModel<String> defaultSchemaModel;
    private ListValueModel<String> schemaChoicesModel;
    private BufferedModifiablePropertyValueModel<Boolean> discoverAnnotatedClassesModel;
    private ModifiablePropertyValueModel<Boolean> listAnnotatedClassesModel;
    private PropertyValueModel<Boolean> jpa2_0ProjectFlagModel;
    private BufferedModifiablePropertyValueModel<String> metamodelSourceFolderModel;
    private ListValueModel<String> javaSourceFolderChoicesModel;
    private static final String BUILD_PATHS_PROPERTY_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    static final Comparator<String> STRING_COMPARATOR = new ICUStringCollator();
    private static final Transformer<IProject, PropertyValueModel<JpaProject>> JPA_PROJECT_MODEL_TRANSFORMER = new JpaProjectModelTransformer();
    private static final Predicate<JpaModel> IS_COMPATIBLE_WITH_JPA_2_0 = PredicateTools.nullCheck((Predicate)new JpaModel.JpaVersionIsCompatibleWith("2.0"));
    private static final Comparator<JpaPlatform.Config> JPA_PLATFORM_CONFIG_COMPARATOR = new JpaPlatformConfigComparator();
    private static final Transformer<JpaPlatform.Config, String> JPA_PLATFORM_CONFIG_LABEL_CONVERTER = new JpaPlatformConfigLabelConverter();
    private static final Transformer<String, String> SIMPLE_STRING_TRANSFORMER = TransformerTools.passThruTransformer((Object)JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_NONE);
    private static final ListValueModel<String> CONNECTION_CHOICES_MODEL = new ExtendedListValueModelWrapper((ListValueModel)new SortedListValueModelAdapter((CollectionValueModel)new ConnectionChoicesModel(), STRING_COMPARATOR));

    protected void buildModels() {
        this.jpaProjectModel = this.buildJpaProjectModel();
        this.jpaProjectIsNotNullFlagModel = this.buildJpaProjectIsNotNullFlagModel();
        this.jpaPlatformConfigModel = this.buildJpaPlatformConfigModel();
        this.jpaPlatformConfigListener = this.buildJpaPlatformConfigListener();
        this.connectionModel = this.buildConnectionModel();
        this.connectionProfileModel = this.buildConnectionProfileModel();
        this.disconnectedModel = this.buildDisconnectedModel();
        this.disconnectedModelListener = this.buildDisconnectedModelListener();
        this.userOverrideDefaultCatalogFlagModel = this.buildUserOverrideDefaultCatalogFlagModel();
        this.userOverrideDefaultCatalogModel = this.buildUserOverrideDefaultCatalogModel();
        this.defaultCatalogModel = this.buildDefaultCatalogModel();
        this.catalogChoicesModel = this.buildCatalogChoicesModel();
        this.userOverrideDefaultSchemaFlagModel = this.buildUserOverrideDefaultSchemaFlagModel();
        this.userOverrideDefaultSchemaModel = this.buildUserOverrideDefaultSchemaModel();
        this.defaultSchemaModel = this.buildDefaultSchemaModel();
        this.schemaChoicesModel = this.buildSchemaChoicesModel();
        this.discoverAnnotatedClassesModel = this.buildDiscoverAnnotatedClassesModel();
        this.listAnnotatedClassesModel = this.buildListAnnotatedClassesModel();
        this.jpa2_0ProjectFlagModel = this.buildJpa2_0ProjectFlagModel();
        this.metamodelSourceFolderModel = this.buildMetamodelSourceFolderModel();
        this.javaSourceFolderChoicesModel = this.buildJavaSourceFolderChoicesModel();
    }

    private PropertyValueModel<JpaProject> buildJpaProjectModel() {
        return new DoublePropertyValueModel(this.buildJpaProjectModelModel());
    }

    private PropertyValueModel<PropertyValueModel<JpaProject>> buildJpaProjectModelModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.projectModel, JPA_PROJECT_MODEL_TRANSFORMER);
    }

    private PropertyValueModel<Boolean> buildJpaProjectIsNotNullFlagModel() {
        return new PredicatePropertyValueModel(this.jpaProjectModel, PredicateTools.isNotNull());
    }

    private BufferedModifiablePropertyValueModel<JpaPlatform.Config> buildJpaPlatformConfigModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new JpaPlatformConfigModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyChangeListener buildJpaPlatformConfigListener() {
        return new JpaPlatformConfigListener();
    }

    void jpaPlatformConfigChanged() {
        if (!this.getControl().isDisposed()) {
            this.adjustLibraryProviders();
        }
    }

    private BufferedModifiablePropertyValueModel<String> buildConnectionModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new ConnectionModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyValueModel<ConnectionProfile> buildConnectionProfileModel() {
        return new ConnectionProfileModel((PropertyValueModel<String>)this.connectionModel);
    }

    private PropertyValueModel<Boolean> buildDisconnectedModel() {
        return new DisconnectedModel(this.connectionProfileModel);
    }

    private BufferedModifiablePropertyValueModel<Boolean> buildUserOverrideDefaultCatalogFlagModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new UserOverrideDefaultCatalogFlagModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private BufferedModifiablePropertyValueModel<String> buildUserOverrideDefaultCatalogModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new UserOverrideDefaultCatalogModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private ModifiablePropertyValueModel<String> buildDefaultCatalogModel() {
        return new DefaultModel((PropertyValueModel<Boolean>)this.userOverrideDefaultCatalogFlagModel, (ModifiablePropertyValueModel<String>)this.userOverrideDefaultCatalogModel, this.buildDatabaseDefaultCatalogModel());
    }

    private PropertyValueModel<String> buildDatabaseDefaultCatalogModel() {
        return new DatabaseDefaultCatalogModel(this.connectionProfileModel);
    }

    private ListValueModel<String> buildCatalogChoicesModel() {
        return new SortedListValueModelAdapter(this.buildUnsortedCatalogChoicesModel(), STRING_COMPARATOR);
    }

    private CollectionValueModel<String> buildUnsortedCatalogChoicesModel() {
        return new SetCollectionValueModel((CollectionValueModel)CompositeCollectionValueModel.forModels((CollectionValueModel[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.defaultCatalogModel), this.buildDatabaseCatalogChoicesModel()}));
    }

    private CollectionValueModel<String> buildDatabaseCatalogChoicesModel() {
        return new DatabaseCatalogChoicesModel(this.connectionProfileModel);
    }

    private BufferedModifiablePropertyValueModel<Boolean> buildUserOverrideDefaultSchemaFlagModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new UserOverrideDefaultSchemaFlagModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private BufferedModifiablePropertyValueModel<String> buildUserOverrideDefaultSchemaModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new UserOverrideDefaultSchemaModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private ModifiablePropertyValueModel<String> buildDefaultSchemaModel() {
        return new DefaultModel((PropertyValueModel<Boolean>)this.userOverrideDefaultSchemaFlagModel, (ModifiablePropertyValueModel<String>)this.userOverrideDefaultSchemaModel, this.buildDatabaseDefaultSchemaModel());
    }

    private PropertyValueModel<String> buildDatabaseDefaultSchemaModel() {
        return new DatabaseDefaultSchemaModel(this.connectionProfileModel, (PropertyValueModel<String>)this.defaultCatalogModel);
    }

    private ListValueModel<String> buildSchemaChoicesModel() {
        return new SortedListValueModelAdapter(this.buildUnsortedSchemaChoicesModel(), STRING_COMPARATOR);
    }

    private CollectionValueModel<String> buildUnsortedSchemaChoicesModel() {
        return new SetCollectionValueModel((CollectionValueModel)CompositeCollectionValueModel.forModels((CollectionValueModel[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.defaultSchemaModel), this.buildDatabaseSchemaChoicesModel()}));
    }

    private CollectionValueModel<String> buildDatabaseSchemaChoicesModel() {
        return new DatabaseSchemaChoicesModel(this.connectionProfileModel, (PropertyValueModel<String>)this.defaultCatalogModel);
    }

    private BufferedModifiablePropertyValueModel<Boolean> buildDiscoverAnnotatedClassesModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new DiscoverAnnotatedClassesModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private ModifiablePropertyValueModel<Boolean> buildListAnnotatedClassesModel() {
        return new TransformationModifiablePropertyValueModel(this.discoverAnnotatedClassesModel, TransformerTools.notBooleanTransformer(), TransformerTools.notBooleanTransformer());
    }

    private PropertyValueModel<Boolean> buildJpa2_0ProjectFlagModel() {
        return new PredicatePropertyValueModel(this.jpaProjectModel, IS_COMPATIBLE_WITH_JPA_2_0);
    }

    private BufferedModifiablePropertyValueModel<String> buildMetamodelSourceFolderModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new MetamodelSourceFolderModel(this.jpaProjectModel), (PropertyValueModel)this.trigger);
    }

    private ListValueModel<String> buildJavaSourceFolderChoicesModel() {
        return new ExtendedListValueModelWrapper((ListValueModel)new SortedListValueModelAdapter((CollectionValueModel)new JavaSourceFolderChoicesModel(this.jpaProjectModel), STRING_COMPARATOR));
    }

    private String getConnectionName() {
        return (String)this.connectionModel.getValue();
    }

    private ConnectionProfile getConnectionProfile() {
        return (ConnectionProfile)this.connectionProfileModel.getValue();
    }

    private boolean userOverrideDefaultCatalogFlagIsSet() {
        return JpaProjectPropertiesPage.flagIsSet(this.userOverrideDefaultCatalogFlagModel);
    }

    private String getUserOverrideDefaultCatalog() {
        return (String)this.userOverrideDefaultCatalogModel.getValue();
    }

    private boolean userOverrideDefaultSchemaFlagIsSet() {
        return JpaProjectPropertiesPage.flagIsSet(this.userOverrideDefaultSchemaFlagModel);
    }

    private String getUserOverrideDefaultSchema() {
        return (String)this.userOverrideDefaultSchemaModel.getValue();
    }

    private IWorkbenchPreferenceContainer getWorkbenchPreferenceContainer() {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        return container;
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        return this.getFacetedProject().getInstalledVersion(JpaProject.FACET);
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
        enablementVariables.put("jpaPlatform", "");
        enablementVariables.put("jpaPlatformDescription", new EmptyJpaPlatformConfig());
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)project, fv, enablementVariables);
        lid.addListener(this.buildLibraryProviderListener(), new String[0]);
        return lid;
    }

    protected void adjustLibraryProviders() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid == null) {
            return;
        }
        JpaPlatform.Config jpaPlatformConfig = (JpaPlatform.Config)this.jpaPlatformConfigModel.getValue();
        String jpaPlatformID = jpaPlatformConfig == null ? "" : jpaPlatformConfig.getId();
        lid.setEnablementContextVariable("jpaPlatform", (Object)jpaPlatformID);
        lid.setEnablementContextVariable("jpaPlatformDescription", (Object)jpaPlatformConfig);
        ArrayList<JpaLibraryProviderInstallOperationConfig> jpaConfigs = new ArrayList<JpaLibraryProviderInstallOperationConfig>();
        JpaLibraryProviderInstallOperationConfig currentJpaConfig = null;
        LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
        if (config instanceof JpaLibraryProviderInstallOperationConfig) {
            currentJpaConfig = (JpaLibraryProviderInstallOperationConfig)config;
            jpaConfigs.add(currentJpaConfig);
        }
        for (ILibraryProvider lp : lid.getLibraryProviders()) {
            config = lid.getLibraryProviderOperationConfig(lp);
            if (!(config instanceof JpaLibraryProviderInstallOperationConfig) || config.equals(currentJpaConfig)) continue;
            jpaConfigs.add((JpaLibraryProviderInstallOperationConfig)config);
        }
        for (JpaLibraryProviderInstallOperationConfig jpaConfig : jpaConfigs) {
            jpaConfig.setJpaPlatformConfig(jpaPlatformConfig);
        }
    }

    protected void createWidgets(Composite parent) {
        this.buildPlatformGroup(parent);
        Control libraryProviderComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)parent, (LibraryInstallDelegate)this.getLibraryInstallDelegate(), (String)JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_JPA_IMPLEMENTATION_LABEL);
        libraryProviderComposite.setLayoutData((Object)new GridData(768));
        SWTBindingTools.bindEnabledState(this.jpaProjectIsNotNullFlagModel, (Control[])new Control[]{libraryProviderComposite});
        this.buildConnectionGroup(parent);
        this.buildPersistentClassManagementGroup(parent);
        this.buildMetamodelGroup(parent);
        WorkbenchTools.setHelp((Control)parent, (String)JpaHelpContextIds.PROPERTIES_JAVA_PERSISTENCE);
    }

    protected void engageListeners_() {
        super.engageListeners_();
        this.jpaPlatformConfigModel.addPropertyChangeListener("value", this.jpaPlatformConfigListener);
        this.disconnectedModel.addPropertyChangeListener("value", this.disconnectedModelListener);
    }

    protected void disengageListeners_() {
        this.jpaPlatformConfigModel.removePropertyChangeListener("value", this.jpaPlatformConfigListener);
        this.disconnectedModel.removePropertyChangeListener("value", this.disconnectedModelListener);
        super.disengageListeners_();
    }

    private void buildPlatformGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_PLATFORM_LABEL);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Combo jpaPlatformDropDown = this.buildDropDown((Composite)group);
        SWTBindingTools.bindDropDownListBox(this.buildJpaPlatformConfigChoicesModel(), this.jpaPlatformConfigModel, (Combo)jpaPlatformDropDown, JPA_PLATFORM_CONFIG_LABEL_CONVERTER);
        Link facetsPageLink = this.buildFacetsPageLink((Composite)group, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_FACETS_PAGE_LINK);
        SWTBindingTools.bindEnabledState(this.jpaProjectIsNotNullFlagModel, (Control[])new Control[]{group, jpaPlatformDropDown, facetsPageLink});
    }

    private ListValueModel<JpaPlatform.Config> buildJpaPlatformConfigChoicesModel() {
        return new SortedListValueModelAdapter((CollectionValueModel)new SetCollectionValueModel((CollectionValueModel)CompositeCollectionValueModel.forModels(this.buildJpaPlatformConfigChoicesModels())), JPA_PLATFORM_CONFIG_COMPARATOR);
    }

    private CollectionValueModel<JpaPlatform.Config>[] buildJpaPlatformConfigChoicesModels() {
        return new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.jpaPlatformConfigModel), this.buildEnabledJpaPlatformConfigsModel()};
    }

    private CollectionValueModel<JpaPlatform.Config> buildEnabledJpaPlatformConfigsModel() {
        return new StaticCollectionValueModel(IterableTools.filter(JpaProjectPropertiesPage.getJpaPlatformConfigs(), (Predicate)new JpaPlatformConfigIsEnabled()));
    }

    static ConnectionProfileFactory getConnectionProfileFactory() {
        JpaWorkspace jpaWorkspace = JpaProjectPropertiesPage.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getConnectionProfileFactory();
    }

    static Iterable<JpaPlatform.Config> getJpaPlatformConfigs() {
        JpaPlatformManager jpaPlatformManager = JpaProjectPropertiesPage.getJpaPlatformManager();
        return jpaPlatformManager != null ? jpaPlatformManager.getJpaPlatformConfigs() : IterableTools.emptyIterable();
    }

    static JpaPlatformManager getJpaPlatformManager() {
        JpaWorkspace jpaWorkspace = JpaProjectPropertiesPage.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getJpaPlatformManager();
    }

    static JpaWorkspace getJpaWorkspace() {
        JpaWorkbench jpaWorkbench = JpaProjectPropertiesPage.getJpaWorkbench();
        return jpaWorkbench == null ? null : jpaWorkbench.getJpaWorkspace();
    }

    static JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }

    private void buildConnectionGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTION_LABEL);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        WorkbenchTools.setHelp((Control)group, (String)JpaHelpContextIds.PROPERTIES_JAVA_PERSISTENCE_CONNECTION);
        Combo connectionDropDown = this.buildDropDown((Composite)group, 3);
        SWTBindingTools.bindDropDownListBox(CONNECTION_CHOICES_MODEL, this.connectionModel, (Combo)connectionDropDown, SIMPLE_STRING_TRANSFORMER);
        Link addConnectionLink = this.buildLink((Composite)group, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTION_LINK);
        addConnectionLink.addSelectionListener((SelectionListener)new AddConnectionLinkListener());
        this.connectLink = this.buildLink((Composite)group, this.buildConnectLinkText());
        SWTBindingTools.bindEnabledState(this.disconnectedModel, (Control[])new Control[]{this.connectLink});
        this.connectLink.addSelectionListener((SelectionListener)new ConnectLinkListener());
        Button overrideDefaultCatalogCheckBox = this.buildCheckBox((Composite)group, 3, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_OVERRIDE_DEFAULT_CATALOG_LABEL);
        SWTBindingTools.bind(this.userOverrideDefaultCatalogFlagModel, (Button)overrideDefaultCatalogCheckBox);
        Label defaultCatalogLabel = this.buildLabel((Composite)group, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DEFAULT_CATALOG_LABEL);
        Combo defaultCatalogDropDown = this.buildDropDown((Composite)group);
        SWTBindingTools.bindDropDownListBox(this.catalogChoicesModel, this.defaultCatalogModel, (Combo)defaultCatalogDropDown);
        SWTBindingTools.bindEnabledState(this.userOverrideDefaultCatalogFlagModel, (Control[])new Control[]{defaultCatalogLabel, defaultCatalogDropDown});
        Button overrideDefaultSchemaButton = this.buildCheckBox((Composite)group, 3, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_OVERRIDE_DEFAULT_SCHEMA_LABEL);
        SWTBindingTools.bind(this.userOverrideDefaultSchemaFlagModel, (Button)overrideDefaultSchemaButton);
        Label defaultSchemaLabel = this.buildLabel((Composite)group, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DEFAULT_SCHEMA_LABEL);
        Combo defaultSchemaDropDown = this.buildDropDown((Composite)group);
        SWTBindingTools.bindDropDownListBox(this.schemaChoicesModel, this.defaultSchemaModel, (Combo)defaultSchemaDropDown);
        SWTBindingTools.bindEnabledState(this.userOverrideDefaultSchemaFlagModel, (Control[])new Control[]{defaultSchemaLabel, defaultSchemaDropDown});
        SWTBindingTools.bindEnabledState(this.jpaProjectIsNotNullFlagModel, (Control[])new Control[]{group, connectionDropDown, addConnectionLink, overrideDefaultCatalogCheckBox, overrideDefaultSchemaButton});
    }

    private PropertyChangeListener buildDisconnectedModelListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new DisconnectedModelListener());
    }

    void updateConnectLinkText() {
        this.updateConnectLinkText(this.buildConnectLinkText());
    }

    private String buildConnectLinkText() {
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        return connectionProfile != null && connectionProfile.isConnected() ? JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECTED_TEXT : JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_CONNECT_LINK;
    }

    private void updateConnectLinkText(String text) {
        if (this.connectLink.isDisposed()) {
            return;
        }
        this.connectLink.setText(text);
        ControlTools.reflow((Control)this.connectLink);
    }

    void openNewConnectionWizard() {
        String connectionName = DTPUiTools.createNewConnectionProfile();
        if (connectionName != null) {
            this.connectionModel.setValue((Object)connectionName);
        }
    }

    void openConnectionProfile() {
        ConnectionProfile cp = this.getConnectionProfile();
        if (cp != null) {
            cp.connect();
        }
    }

    private void buildPersistentClassManagementGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_PERSISTENT_CLASS_MANAGEMENT_LABEL);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Button discoverClassesRadioButton = this.buildRadioButton((Composite)group, 1, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_DISCOVER_CLASSES_BUTTON);
        SWTBindingTools.bind(this.discoverAnnotatedClassesModel, (Button)discoverClassesRadioButton);
        Button listClassesRadioButton = this.buildRadioButton((Composite)group, 1, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_LIST_CLASSES_BUTTON);
        SWTBindingTools.bind(this.listAnnotatedClassesModel, (Button)listClassesRadioButton);
        SWTBindingTools.bindEnabledState(this.jpaProjectIsNotNullFlagModel, (Control[])new Control[]{group, discoverClassesRadioButton, listClassesRadioButton});
    }

    private void buildMetamodelGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_METAMODEL_LABEL);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Link metamodelSourceFolderLink = this.buildLink((Composite)group, JptJpaUiMessages.JPA_FACET_WIZARD_PAGE_METAMODEL_SOURCE_FOLDER_LINK);
        metamodelSourceFolderLink.addSelectionListener((SelectionListener)new MetamodelSourceFolderLinkListener());
        Combo metamodelSourceFolderDropDown = this.buildDropDown((Composite)group);
        SWTBindingTools.bindDropDownListBox(this.javaSourceFolderChoicesModel, this.metamodelSourceFolderModel, (Combo)metamodelSourceFolderDropDown, SIMPLE_STRING_TRANSFORMER);
        WorkbenchTools.setHelp((Control)group, (String)JpaHelpContextIds.PROPERTIES_JAVA_PERSISTENCE_METAMODEL);
        SWTBindingTools.bindVisibleState(this.jpa2_0ProjectFlagModel, (Control[])new Control[]{group, metamodelSourceFolderLink, metamodelSourceFolderDropDown});
    }

    void openJavaBuildPathPage() {
        IWorkbenchPreferenceContainer container = this.getWorkbenchPreferenceContainer();
        container.openPage(BUILD_PATHS_PROPERTY_PAGE_ID, null);
    }

    protected boolean projectRebuildRequired() {
        return this.jpaPlatformConfigModel.isBuffering();
    }

    protected void rebuildProject() throws CoreException {
        try {
            this.rebuildProject_();
        }
        catch (InterruptedException ex) {
            throw new CoreException(JptJpaUiPlugin.instance().buildStatus(8, ex));
        }
    }

    private void rebuildProject_() throws InterruptedException {
        JpaProject.Reference ref = this.getJpaProjectReference();
        if (ref != null) {
            ref.rebuild();
        }
    }

    private JpaProject.Reference getJpaProjectReference() {
        return (JpaProject.Reference)this.getProject().getAdapter(JpaProject.Reference.class);
    }

    protected BufferedModifiablePropertyValueModel<?>[] buildBufferedModels() {
        return new BufferedModifiablePropertyValueModel[]{this.jpaPlatformConfigModel, this.connectionModel, this.userOverrideDefaultCatalogFlagModel, this.userOverrideDefaultCatalogModel, this.userOverrideDefaultSchemaFlagModel, this.userOverrideDefaultSchemaModel, this.discoverAnnotatedClassesModel, this.metamodelSourceFolderModel};
    }

    protected Model[] buildValidationModels() {
        return new Model[]{this.jpaPlatformConfigModel, this.connectionModel, this.userOverrideDefaultCatalogFlagModel, this.defaultCatalogModel, this.userOverrideDefaultSchemaFlagModel, this.defaultSchemaModel, this.discoverAnnotatedClassesModel};
    }

    protected void performValidation(Map<Integer, ArrayList<IStatus>> statuses) {
        JpaProject jpaProject = (JpaProject)this.jpaProjectModel.getValue();
        if (jpaProject == null) {
            return;
        }
        this.validateLibraryProvider(statuses);
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        String connectionName = this.getConnectionName();
        if (!StringTools.isBlank((String)connectionName)) {
            if (connectionProfile == null) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(NLS.bind((String)JptJpaCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName)));
            } else if (!connectionProfile.isActive()) {
                statuses.get(INFO_STATUS).add(this.buildInfoStatus(JptJpaCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED));
            }
        }
        if (this.userOverrideDefaultCatalogFlagIsSet()) {
            String defaultCatalog = this.getUserOverrideDefaultCatalog();
            if (StringTools.isBlank((String)defaultCatalog)) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(JptJpaCoreMessages.VALIDATE_DEFAULT_CATALOG_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !IterableTools.contains(this.catalogChoicesModel, (Object)defaultCatalog)) {
                statuses.get(WARNING_STATUS).add(this.buildWarningStatus(NLS.bind((String)JptJpaCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_CATALOG, (Object)defaultCatalog)));
            }
        }
        if (this.userOverrideDefaultSchemaFlagIsSet()) {
            String defaultSchema = this.getUserOverrideDefaultSchema();
            if (StringTools.isBlank((String)defaultSchema)) {
                statuses.get(ERROR_STATUS).add(this.buildErrorStatus(JptJpaCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !IterableTools.contains(this.schemaChoicesModel, (Object)defaultSchema)) {
                statuses.get(WARNING_STATUS).add(this.buildWarningStatus(NLS.bind((String)JptJpaCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_SCHEMA, (Object)defaultSchema)));
            }
        }
    }

    private void validateLibraryProvider(Map<Integer, ArrayList<IStatus>> statuses) {
        LibraryInstallDelegate libInstallDelegate = this.getLibraryInstallDelegate();
        if (libInstallDelegate == null) {
            return;
        }
        JpaPlatform.Config jpaPlatformConfig = (JpaPlatform.Config)this.jpaPlatformConfigModel.getValue();
        String jpaPlatformID = jpaPlatformConfig == null ? "" : jpaPlatformConfig.getId();
        HashMap<String, String> enablementVariables = new HashMap<String, String>();
        enablementVariables.put("jpaPlatform", jpaPlatformID);
        enablementVariables.put("jpaPlatformDescription", (String)((JpaProject)this.jpaProjectModel.getValue()).getJpaPlatform().getConfig());
        if (!libInstallDelegate.getLibraryProvider().isEnabledFor((IFacetedProjectBase)this.getFacetedProject(), this.getProjectFacetVersion(), enablementVariables)) {
            this.addStatus(this.buildErrorStatus(JptJpaCoreMessages.VALIDATE_LIBRARY_PROVIDER_INVALID), statuses);
        }
    }

    class AddConnectionLinkListener
    extends SelectionAdapter {
        AddConnectionLinkListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JpaProjectPropertiesPage.this.openNewConnectionWizard();
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this));
        }
    }

    class ConnectLinkListener
    extends SelectionAdapter {
        ConnectLinkListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JpaProjectPropertiesPage.this.openConnectionProfile();
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this));
        }
    }

    static class ConnectionChoicesModel
    extends AbstractCollectionValueModel
    implements CollectionValueModel<String> {
        private final ConnectionProfileFactory connectionProfileFactory = JpaProjectPropertiesPage.getConnectionProfileFactory();
        private final ConnectionProfileListener connectionProfileListener = new LocalConnectionProfileListener();

        ConnectionChoicesModel() {
        }

        void collectionChanged() {
            this.fireCollectionChanged("values", (Collection)CollectionTools.hashBag(this.iterator()));
        }

        public Iterator<String> iterator() {
            return this.getConnectionProfileNames().iterator();
        }

        private Iterable<String> getConnectionProfileNames() {
            return this.connectionProfileFactory != null ? this.connectionProfileFactory.getConnectionProfileNames() : IterableTools.emptyIterable();
        }

        public int size() {
            return IterableTools.size(this.getConnectionProfileNames());
        }

        protected void engageModel() {
            if (this.connectionProfileFactory != null) {
                this.connectionProfileFactory.addConnectionProfileListener(this.connectionProfileListener);
            }
        }

        protected void disengageModel() {
            if (this.connectionProfileFactory != null) {
                this.connectionProfileFactory.removeConnectionProfileListener(this.connectionProfileListener);
            }
        }

        class LocalConnectionProfileListener
        extends ConnectionProfileAdapter {
            LocalConnectionProfileListener() {
            }

            public void connectionProfileAdded(String name) {
                ConnectionChoicesModel.this.collectionChanged();
            }

            public void connectionProfileRemoved(String name) {
                ConnectionChoicesModel.this.collectionChanged();
            }

            public void connectionProfileRenamed(String oldName, String newName) {
            }
        }
    }

    static class ConnectionModel
    extends PropertyAspectAdapter<JpaDataSource, String> {
        ConnectionModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super((PropertyValueModel)new DataSourceModel(jpaProjectModel), new String[]{"connectionProfileName"});
        }

        protected String buildValue_() {
            return ((JpaDataSource)this.subject).getConnectionProfileName();
        }

        public void setValue_(String connection) {
            ((JpaDataSource)this.subject).setConnectionProfileName(connection);
        }
    }

    static abstract class ConnectionProfileCollectionAspectAdapter<E>
    extends AspectCollectionValueModelAdapter<ConnectionProfile, E> {
        private final ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfileCollectionAspectAdapter(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        private ConnectionListener buildConnectionListener() {
            return new LocalConnectionListener();
        }

        void connectionOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.aspectChanged();
            }
        }

        protected void engageSubject_() {
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
        }

        class LocalConnectionListener
        extends ConnectionAdapter {
            LocalConnectionListener() {
            }

            public void opened(ConnectionProfile profile) {
                ConnectionProfileCollectionAspectAdapter.this.connectionOpened(profile);
            }
        }
    }

    static class ConnectionProfileModel
    extends TransformationPropertyValueModel<String, ConnectionProfile> {
        ConnectionProfileModel(PropertyValueModel<String> connectionModel) {
            super(connectionModel);
        }

        protected ConnectionProfile transform_(String connectionName) {
            ConnectionProfileFactory factory = JpaProjectPropertiesPage.getConnectionProfileFactory();
            return factory == null ? null : factory.buildConnectionProfile(connectionName);
        }
    }

    static abstract class ConnectionProfilePropertyAspectAdapter<V>
    extends AspectPropertyValueModelAdapter<ConnectionProfile, V> {
        private final ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfilePropertyAspectAdapter(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        private ConnectionListener buildConnectionListener() {
            return new LocalConnectionListener();
        }

        void connectionOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.aspectChanged();
            }
        }

        protected void engageSubject_() {
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
        }

        class LocalConnectionListener
        extends ConnectionAdapter {
            LocalConnectionListener() {
            }

            public void opened(ConnectionProfile profile) {
                ConnectionProfilePropertyAspectAdapter.this.connectionOpened(profile);
            }
        }
    }

    static class DataSourceModel
    extends TransformationPropertyValueModel<JpaProject, JpaDataSource> {
        DataSourceModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        protected JpaDataSource transform_(JpaProject v) {
            return v.getDataSource();
        }
    }

    static class DatabaseCatalogChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        DatabaseCatalogChoicesModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected Iterable<String> getIterable() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
        }
    }

    static class DatabaseDefaultCatalogModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        DatabaseDefaultCatalogModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected String buildValue_() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db == null ? null : db.getDefaultCatalogIdentifier();
        }
    }

    static class DatabaseDefaultSchemaModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        DatabaseDefaultSchemaModel(PropertyValueModel<ConnectionProfile> connectionProfileModel, PropertyValueModel<String> defaultCatalogModel) {
            super(connectionProfileModel);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = new CatalogListener();
        }

        void catalogChanged() {
            this.aspectChanged();
        }

        @Override
        protected void engageSubject_() {
            super.engageSubject_();
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected void disengageSubject_() {
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
            super.disengageSubject_();
        }

        protected String buildValue_() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc == null ? null : sc.getDefaultSchemaIdentifier();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getDatabase().getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }

        class CatalogListener
        extends PropertyChangeAdapter {
            CatalogListener() {
            }

            public void propertyChanged(PropertyChangeEvent event) {
                DatabaseDefaultSchemaModel.this.catalogChanged();
            }
        }
    }

    static class DatabaseSchemaChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        DatabaseSchemaChoicesModel(PropertyValueModel<ConnectionProfile> connectionProfileModel, PropertyValueModel<String> defaultCatalogModel) {
            super(connectionProfileModel);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = new CatalogListener();
        }

        void catalogChanged() {
            this.aspectChanged();
        }

        @Override
        protected void engageSubject_() {
            super.engageSubject_();
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected void disengageSubject_() {
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
            super.disengageSubject_();
        }

        protected Iterable<String> getIterable() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc != null ? sc.getSortedSchemaIdentifiers() : EmptyIterable.instance();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getDatabase().getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }

        class CatalogListener
        extends PropertyChangeAdapter {
            CatalogListener() {
            }

            public void propertyChanged(PropertyChangeEvent event) {
                DatabaseSchemaChoicesModel.this.catalogChanged();
            }
        }
    }

    static class DefaultModel
    extends CompositePropertyValueModel<String, Object>
    implements ModifiablePropertyValueModel<String> {
        private final PropertyValueModel<Boolean> userOverrideDefaultFlagModel;
        private final ModifiablePropertyValueModel<String> userOverrideDefaultModel;
        private final PropertyValueModel<String> databaseDefaultModel;

        DefaultModel(PropertyValueModel<Boolean> userOverrideDefaultFlagModel, ModifiablePropertyValueModel<String> userOverrideDefaultModel, PropertyValueModel<String> databaseDefaultModel) {
            super(new PropertyValueModel[]{userOverrideDefaultFlagModel, userOverrideDefaultModel, databaseDefaultModel});
            this.userOverrideDefaultFlagModel = userOverrideDefaultFlagModel;
            this.userOverrideDefaultModel = userOverrideDefaultModel;
            this.databaseDefaultModel = databaseDefaultModel;
        }

        protected void componentChanged(PropertyChangeEvent event) {
            super.componentChanged(event);
            if (event.getSource() == this.userOverrideDefaultFlagModel && !this.userOverrideDefaultFlagIsSet()) {
                this.userOverrideDefaultModel.setValue(null);
            }
        }

        protected String buildValue() {
            return this.userOverrideDefaultFlagIsSet() ? (String)this.userOverrideDefaultModel.getValue() : (String)this.databaseDefaultModel.getValue();
        }

        public void setValue(String value) {
            this.userOverrideDefaultModel.setValue((Object)value);
            this.propertyChanged();
        }

        private boolean userOverrideDefaultFlagIsSet() {
            return JpaProjectPropertiesPage.flagIsSet(this.userOverrideDefaultFlagModel);
        }
    }

    static class DisconnectedModel
    extends ConnectionProfilePropertyAspectAdapter<Boolean> {
        DisconnectedModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        protected Boolean buildValue_() {
            return this.subject != null && ((ConnectionProfile)this.subject).isDisconnected();
        }
    }

    class DisconnectedModelListener
    extends PropertyChangeAdapter {
        DisconnectedModelListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaProjectPropertiesPage.this.updateConnectLinkText();
        }
    }

    static class DiscoverAnnotatedClassesModel
    extends PropertyAspectAdapter<JpaProject, Boolean> {
        DiscoverAnnotatedClassesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"discoversAnnotatedClasses"});
        }

        protected Boolean buildValue_() {
            return ((JpaProject)this.subject).discoversAnnotatedClasses();
        }

        protected void setValue_(Boolean value) {
            ((JpaProject)this.subject).setDiscoversAnnotatedClasses(value.booleanValue());
        }
    }

    class EmptyJpaPlatformConfig
    implements JpaPlatform.Config {
        EmptyJpaPlatformConfig() {
        }

        public JpaPlatformManager getJpaPlatformManager() {
            return null;
        }

        public JpaPlatform getJpaPlatform() {
            return null;
        }

        public IProjectFacetVersion getJpaFacetVersion() {
            return null;
        }

        public boolean supportsJpaFacetVersion(IProjectFacetVersion jpaFacetVersion) {
            return false;
        }

        public boolean isDefault() {
            return false;
        }

        public String getPluginId() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public String getId() {
            return null;
        }

        public JpaPlatform.GroupConfig getGroupConfig() {
            return null;
        }

        public String getFactoryClassName() {
            return null;
        }
    }

    static class JavaSourceFolderChoicesModel
    extends AspectCollectionValueModelAdapter<JpaProject, String> {
        private final IElementChangedListener javaElementChangedListener = new JavaElementChangedListener();

        JavaSourceFolderChoicesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        void processJavaDelta(IJavaElementDelta delta) {
            switch (delta.getElement().getElementType()) {
                case 1: {
                    this.processJavaDeltaChildren(delta);
                    break;
                }
                case 2: {
                    this.processJavaProjectDelta(delta);
                    break;
                }
            }
        }

        private void processJavaDeltaChildren(IJavaElementDelta delta) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.processJavaDelta(child);
                ++n2;
            }
        }

        private void processJavaProjectDelta(IJavaElementDelta delta) {
            IJavaProject javaProject = (IJavaProject)delta.getElement();
            if (javaProject.equals(((JpaProject)this.subject).getJavaProject()) && this.classpathHasChanged(delta)) {
                this.fireCollectionChanged("values", (Collection)CollectionTools.hashBag((Iterator)this.iterator()));
            }
        }

        private boolean classpathHasChanged(IJavaElementDelta delta) {
            return this.deltaFlagIsSet(delta, 0x200000);
        }

        private boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
            return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
        }

        protected Iterable<String> getIterable() {
            return this.subjectIsInJpa2_0Project() ? ((JpaProject2_0)this.subject).getJavaSourceFolderNames() : EmptyIterable.instance();
        }

        private boolean subjectIsInJpa2_0Project() {
            return ((JpaProject)this.subject).getJpaProject().getJpaPlatform().getJpaVersion().isCompatibleWithJpaVersion("2.0");
        }

        protected void engageSubject_() {
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        }

        protected void disengageSubject_() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangedListener);
        }

        class JavaElementChangedListener
        implements IElementChangedListener {
            JavaElementChangedListener() {
            }

            public void elementChanged(ElementChangedEvent event) {
                JavaSourceFolderChoicesModel.this.processJavaDelta(event.getDelta());
            }

            public String toString() {
                return ObjectTools.toString((Object)this);
            }
        }
    }

    static class JpaPlatformConfigComparator
    implements Comparator<JpaPlatform.Config> {
        JpaPlatformConfigComparator() {
        }

        @Override
        public int compare(JpaPlatform.Config config1, JpaPlatform.Config config2) {
            return STRING_COMPARATOR.compare(config1.getLabel(), config2.getLabel());
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    class JpaPlatformConfigIsEnabled
    extends PredicateAdapter<JpaPlatform.Config> {
        JpaPlatformConfigIsEnabled() {
        }

        public boolean evaluate(JpaPlatform.Config config) {
            return config.supportsJpaFacetVersion(JpaProjectPropertiesPage.this.getProjectFacetVersion());
        }
    }

    static class JpaPlatformConfigLabelConverter
    extends TransformerAdapter<JpaPlatform.Config, String> {
        JpaPlatformConfigLabelConverter() {
        }

        public String transform(JpaPlatform.Config config) {
            return config.getLabel();
        }
    }

    class JpaPlatformConfigListener
    extends PropertyChangeAdapter {
        JpaPlatformConfigListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaProjectPropertiesPage.this.jpaPlatformConfigChanged();
        }
    }

    static class JpaPlatformConfigModel
    extends AspectPropertyValueModelAdapter<JpaProject, JpaPlatform.Config> {
        JpaPlatformConfigModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel);
        }

        protected JpaPlatform.Config buildValue_() {
            String jpaPlatformID = JpaPreferences.getJpaPlatformID((IProject)((JpaProject)this.subject).getProject());
            JpaPlatformManager jpaPlatformManager = JpaProjectPropertiesPage.getJpaPlatformManager();
            return jpaPlatformManager == null ? null : jpaPlatformManager.getJpaPlatformConfig(jpaPlatformID);
        }

        public void setValue_(JpaPlatform.Config jpaPlatformConfig) {
            String jpaPlatformID = jpaPlatformConfig.getId();
            JpaPreferences.setJpaPlatformID((IProject)((JpaProject)this.subject).getProject(), (String)jpaPlatformID);
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }

    static class JpaProjectModelTransformer
    extends AbstractTransformer<IProject, PropertyValueModel<JpaProject>> {
        JpaProjectModelTransformer() {
        }

        protected PropertyValueModel<JpaProject> transform_(IProject project) {
            return (JpaProjectModel)project.getAdapter(JpaProjectModel.class);
        }
    }

    class MetamodelSourceFolderLinkListener
    extends SelectionAdapter {
        MetamodelSourceFolderLinkListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JpaProjectPropertiesPage.this.openJavaBuildPathPage();
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this));
        }
    }

    static class MetamodelSourceFolderModel
    extends PropertyAspectAdapter<JpaProject, String> {
        MetamodelSourceFolderModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"metamodelSourceFolderName"});
        }

        protected String buildValue_() {
            return this.subjectIsInJpa2_0Project() ? ((JpaProject2_0)this.subject).getMetamodelSourceFolderName() : null;
        }

        protected void setValue_(String value) {
            if (this.subjectIsInJpa2_0Project()) {
                ((JpaProject2_0)this.subject).setMetamodelSourceFolderName(value);
            }
        }

        private boolean subjectIsInJpa2_0Project() {
            return ((JpaProject)this.subject).getJpaProject().getJpaPlatform().getJpaVersion().isCompatibleWithJpaVersion("2.0");
        }
    }

    static class UserOverrideDefaultCatalogFlagModel
    extends UserOverrideDefaultFlagModel {
        UserOverrideDefaultCatalogFlagModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, "userOverrideDefaultCatalog");
        }

        @Override
        public String getUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }
    }

    static class UserOverrideDefaultCatalogModel
    extends PropertyAspectAdapter<JpaProject, String> {
        UserOverrideDefaultCatalogModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultCatalog"});
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }

        public void setValue_(String catalog) {
            ((JpaProject)this.subject).setUserOverrideDefaultCatalog(catalog);
        }
    }

    static abstract class UserOverrideDefaultFlagModel
    extends PropertyAspectAdapter<JpaProject, Boolean> {
        UserOverrideDefaultFlagModel(PropertyValueModel<JpaProject> jpaProjectModel, String propertyName) {
            super(jpaProjectModel, new String[]{propertyName});
        }

        protected Boolean buildValue_() {
            return this.specifiesUserOverrideDefault();
        }

        boolean specifiesUserOverrideDefault() {
            return !StringTools.isBlank((String)this.getUserOverrideDefault());
        }

        abstract String getUserOverrideDefault();

        protected void setValue_(Boolean value) {
        }
    }

    static class UserOverrideDefaultSchemaFlagModel
    extends UserOverrideDefaultFlagModel {
        UserOverrideDefaultSchemaFlagModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, "userOverrideDefaultSchema");
        }

        @Override
        public String getUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }
    }

    static class UserOverrideDefaultSchemaModel
    extends PropertyAspectAdapter<JpaProject, String> {
        UserOverrideDefaultSchemaModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultSchema"});
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }

        public void setValue_(String schema) {
            ((JpaProject)this.subject).setUserOverrideDefaultSchema(schema);
        }
    }
}

