/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.ejb.provider.AbstractMethodsContentProvider;

public class ExcludeListContentProvider
extends AbstractMethodsContentProvider {
    private static final EStructuralFeature EXCLUDE_ME_SF = EjbFactoryImpl.getPackage().getExcludeList_MethodElements();
    private static final EStructuralFeature AD_EL_SF = EjbFactoryImpl.getPackage().getAssemblyDescriptor_ExcludeList();
    protected static final EStructuralFeature ECORE_BEAN_NAME = EcorePackage.eINSTANCE.getENamedElement_Name();

    public ExcludeListContentProvider(AdapterFactory adapterFactory, boolean root) {
        super(adapterFactory, root);
    }

    public ExcludeListContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected Object[] getEnterpriseBeans(ExcludeList list) {
        EList mes = list.getMethodElements();
        return this.getEnterpriseBeans((EObject)list, (List)mes);
    }

    protected List getMethodElements(EObject aRefObject, EnterpriseBean anEJB) {
        if (aRefObject == null || !(aRefObject instanceof ExcludeList)) {
            return Collections.EMPTY_LIST;
        }
        ExcludeList parentList = (ExcludeList)aRefObject;
        return parentList.getMethodElements(anEJB);
    }

    public Object[] getElements(Object inputElement) {
        super.getElements(inputElement);
        ExcludeList list = null;
        if (inputElement instanceof EJBJar) {
            EJBJar jar = (EJBJar)inputElement;
            if (jar.getAssemblyDescriptor() != null) {
                list = jar.getAssemblyDescriptor().getExcludeList();
            }
            if (list != null) {
                return this.getEnterpriseBeans(list);
            }
        }
        if (inputElement instanceof AssemblyDescriptor && (list = ((AssemblyDescriptor)inputElement).getExcludeList()) != null) {
            return this.getEnterpriseBeans(list);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ExcludeList) {
            return this.getEnterpriseBeans((ExcludeList)parentElement);
        }
        return super.getChildren(parentElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ExcludeList) {
            return !((ExcludeList)element).getMethodElements().isEmpty();
        }
        return super.hasChildren(element);
    }

    public void notifyChanged(Notification notifier) {
        if (notifier.getFeature() == EXCLUDE_ME_SF && notifier.getNotifier() instanceof ExcludeList || notifier.getFeature() == ECORE_BEAN_NAME) {
            if (notifier.getEventType() == 9) {
                return;
            }
            if (this.isRoot) {
                this.refreshTreeViewer();
            } else {
                this.refreshTreeViewer(notifier.getNotifier());
            }
        }
        if (notifier.getOldValue() instanceof CMPAttribute && notifier.getNewValue() == null) {
            return;
        }
        if (notifier.getFeature() == this.getMethodElementsReference() || notifier.getFeature() == this.getMethodElementsContainerReference()) {
            super.notifyChanged(notifier);
        }
    }

    protected EStructuralFeature getMethodElementsReference() {
        return EXCLUDE_ME_SF;
    }

    protected EStructuralFeature getMethodElementsContainerReference() {
        return AD_EL_SF;
    }
}

