/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.platforms.DTPPlatformTests;

public class MySQLTests
extends DTPPlatformTests {
    private static final String CR = System.getProperty("line.separator");

    public MySQLTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformPropertiesFileName() {
        return "mysql.properties";
    }

    @Override
    protected String getDriverName() {
        return "MySQL JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionID() {
        return "DriverDefn.MySQL JDBC Driver";
    }

    @Override
    protected String getDriverDefinitionType() {
        return "org.eclipse.datatools.enablement.mysql.4_1.driverTemplate";
    }

    @Override
    protected String getDatabaseVendor() {
        return "MySql";
    }

    @Override
    protected String getDatabaseVersion() {
        return "4.1";
    }

    @Override
    protected String getDriverClass() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    protected String getDefaultJDBCURL() {
        return "jdbc:mysql://localhost:3306";
    }

    @Override
    protected String getProfileName() {
        return "MySQL_4.1";
    }

    @Override
    protected String getProfileDescription() {
        return "MySQL 4.1 JDBC Profile [Test]";
    }

    @Override
    protected boolean supportsCatalogs() {
        return false;
    }

    @Override
    protected Properties buildDTPConnectionProfileProperties() {
        Properties p = super.buildDTPConnectionProfileProperties();
        p.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.getDatabaseName());
        return p;
    }

    private String getDatabaseName() {
        return this.getUserID();
    }

    @Override
    protected boolean executeOfflineTests() {
        return true;
    }

    public void testDatabase() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        Schema schema = this.getDatabase().getSchemaNamed(this.getDatabaseName());
        MySQLTests.assertNotNull((Object)schema);
        MySQLTests.assertSame((Object)this.getDefaultSchema(), (Object)schema);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testTable() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog(this.getDatabaseName());
        this.dropTable("foo_baz");
        this.dropTable("baz");
        this.dropTable("foo");
        this.dropTable("bar");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate(this.buildFooDDL());
        this.executeUpdate(this.buildBazDDL());
        this.executeUpdate(this.buildFooBazDDL());
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        Schema schema = this.getDefaultSchema();
        Table fooTable = schema.getTableNamed("foo");
        MySQLTests.assertEquals((int)3, (int)fooTable.getColumnsSize());
        MySQLTests.assertEquals((int)1, (int)fooTable.getPrimaryKeyColumnsSize());
        MySQLTests.assertEquals((int)1, (int)fooTable.getForeignKeysSize());
        Column pkColumn = fooTable.getPrimaryKeyColumn();
        MySQLTests.assertEquals((String)"id", (String)pkColumn.getName());
        Column idColumn = fooTable.getColumnNamed("id");
        MySQLTests.assertSame((Object)pkColumn, (Object)idColumn);
        MySQLTests.assertEquals((String)"INT", (String)idColumn.getDataTypeName());
        MySQLTests.assertSame((Object)fooTable, (Object)idColumn.getTable());
        MySQLTests.assertTrue((boolean)idColumn.isPartOfPrimaryKey());
        MySQLTests.assertFalse((boolean)idColumn.isPartOfForeignKey());
        MySQLTests.assertEquals((String)"int", (String)idColumn.getJavaTypeDeclaration());
        Column nameColumn = fooTable.getColumnNamed("name");
        MySQLTests.assertEquals((String)"VARCHAR", (String)nameColumn.getDataTypeName());
        MySQLTests.assertEquals((String)"java.lang.String", (String)nameColumn.getJavaTypeDeclaration());
        MySQLTests.assertFalse((boolean)nameColumn.isPartOfPrimaryKey());
        Column barColumn = fooTable.getColumnNamed("bar_id");
        MySQLTests.assertEquals((String)"INT", (String)barColumn.getDataTypeName());
        MySQLTests.assertTrue((boolean)barColumn.isPartOfForeignKey());
        MySQLTests.assertFalse((boolean)barColumn.isPartOfPrimaryKey());
        ForeignKey barFK = (ForeignKey)fooTable.getForeignKeys().iterator().next();
        MySQLTests.assertEquals((int)1, (int)barFK.getColumnPairsSize());
        MySQLTests.assertEquals((String)"bar", (String)barFK.getAttributeName());
        MySQLTests.assertNull((Object)barFK.getJoinColumnAnnotationIdentifier("bar"));
        MySQLTests.assertEquals((String)"bar_id", (String)barFK.getJoinColumnAnnotationIdentifier("primaryBar"));
        MySQLTests.assertSame((Object)fooTable, (Object)barFK.getBaseTable());
        MySQLTests.assertFalse((boolean)fooTable.isPossibleJoinTable());
        MySQLTests.assertSame((Object)schema, (Object)fooTable.getSchema());
        Table barTable = schema.getTableNamed("bar");
        MySQLTests.assertEquals((int)2, (int)barTable.getColumnsSize());
        MySQLTests.assertEquals((int)1, (int)barTable.getPrimaryKeyColumnsSize());
        MySQLTests.assertEquals((int)0, (int)barTable.getForeignKeysSize());
        MySQLTests.assertEquals((String)"id", (String)barTable.getPrimaryKeyColumn().getName());
        MySQLTests.assertFalse((boolean)barTable.isPossibleJoinTable());
        MySQLTests.assertEquals((String)"BLOB", (String)barTable.getColumnNamed("chunk").getDataTypeName());
        MySQLTests.assertEquals((String)"byte[]", (String)barTable.getColumnNamed("chunk").getJavaTypeDeclaration());
        MySQLTests.assertTrue((boolean)barTable.getColumnNamed("chunk").isLOB());
        MySQLTests.assertSame((Object)barTable, (Object)barFK.getReferencedTable());
        Table foo_bazTable = schema.getTableNamed("foo_baz");
        MySQLTests.assertEquals((int)2, (int)foo_bazTable.getColumnsSize());
        MySQLTests.assertEquals((int)0, (int)foo_bazTable.getPrimaryKeyColumnsSize());
        MySQLTests.assertEquals((int)2, (int)foo_bazTable.getForeignKeysSize());
        MySQLTests.assertTrue((boolean)foo_bazTable.isPossibleJoinTable());
        MySQLTests.assertTrue((boolean)foo_bazTable.joinTableNameIsDefault());
        MySQLTests.assertTrue((boolean)foo_bazTable.getColumnNamed("foo_id").isPartOfForeignKey());
        this.dropTable("foo_baz");
        this.dropTable("baz");
        this.dropTable("foo");
        this.dropTable("bar");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private String buildBarDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE bar (").append(CR);
        sb.append("    id INTEGER PRIMARY KEY,").append(CR);
        sb.append("    chunk BLOB").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE foo (").append(CR);
        sb.append("    id INTEGER PRIMARY KEY,").append(CR);
        sb.append("    name VARCHAR(20),").append(CR);
        sb.append("    bar_id INTEGER,").append(CR);
        sb.append("    CONSTRAINT BAR FOREIGN KEY (bar_id) REFERENCES bar(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE baz (").append(CR);
        sb.append("    id INTEGER PRIMARY KEY,").append(CR);
        sb.append("    name VARCHAR(20)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE foo_baz (").append(CR);
        sb.append("    foo_id INT,").append(CR);
        sb.append("    baz_id INT,").append(CR);
        sb.append("    FOREIGN KEY (foo_id) REFERENCES foo(id),").append(CR);
        sb.append("    FOREIGN KEY (baz_id) REFERENCES baz(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    public void testTableLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog(this.getDatabaseName());
        this.dropTable("test1");
        this.dropTable("TEST2");
        this.dropTable("`TEST3`");
        this.executeUpdate("CREATE TABLE test1 (id INTEGER, name VARCHAR(20))");
        this.executeUpdate("CREATE TABLE TEST2 (id INTEGER, name VARCHAR(20))");
        this.executeUpdate("CREATE TABLE `TEST3` (id INTEGER, name VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        Schema schema = this.getDefaultSchema();
        Table test1Table = schema.getTableForIdentifier("test1");
        MySQLTests.assertNotNull((Object)test1Table);
        int lctn = this.getLowerCaseTableNamesFromDatabase();
        String test2Identifier = lctn == 0 ? "TEST2" : "test2";
        Table test2Table = schema.getTableForIdentifier(test2Identifier);
        MySQLTests.assertNotNull((Object)test2Table);
        String test3Identifier = lctn == 0 ? "`TEST3`" : "`test3`";
        Table test3Table = schema.getTableForIdentifier(test3Identifier);
        MySQLTests.assertNotNull((Object)test3Table);
        this.dropTable("test1");
        this.dropTable("TEST2");
        this.dropTable("`TEST3`");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    protected int getLowerCaseTableNamesFromDatabase() throws SQLException {
        List<Map<String, Object>> rows = this.execute("show variables like 'lower\\_case\\_table\\_names'");
        Map<String, Object> row = rows.get(0);
        String value = (String)row.get("Value");
        if (value == null) {
            value = (String)row.get("VARIABLE_VALUE");
        }
        return Integer.valueOf(value);
    }

    public void testColumnLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog(this.getDatabaseName());
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (id INTEGER, name VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        Table table = this.getDefaultSchema().getTableNamed("test");
        MySQLTests.assertNotNull((Object)table.getColumnNamed("id"));
        MySQLTests.assertNotNull((Object)table.getColumnNamed("name"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (ID INTEGER, NAME VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        table = this.getDefaultSchema().getTableNamed("test");
        MySQLTests.assertNotNull((Object)table.getColumnNamed("ID"));
        MySQLTests.assertNotNull((Object)table.getColumnNamed("NAME"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (Id INTEGER, Name VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        table = this.getDefaultSchema().getTableNamed("test");
        MySQLTests.assertNotNull((Object)table.getColumnNamed("Id"));
        MySQLTests.assertNotNull((Object)table.getColumnNamed("Name"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (`Id` INTEGER, `Name` VARCHAR(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        ((ICatalogObject)this.extractDTPSchema(this.getDefaultSchema())).refresh();
        table = this.getDefaultSchema().getTableNamed("test");
        MySQLTests.assertNotNull((Object)table.getColumnNamed("Id"));
        MySQLTests.assertNotNull((Object)table.getColumnNamed("Name"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        boolean quotes = this.getANSIQuotesFromDatabase();
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("`Id`"));
        if (quotes) {
            MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("\"Id\""));
        }
        MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("`Name`"));
        if (quotes) {
            MySQLTests.assertNotNull((Object)table.getColumnForIdentifier("\"Name\""));
        }
        this.dropTable("test");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    protected boolean getANSIQuotesFromDatabase() throws SQLException {
        List<Map<String, Object>> rows = this.execute("SELECT @@SESSION.sql_mode");
        Map<String, Object> row = rows.get(0);
        String sql_mode = (String)row.get("@@SESSION.sql_mode");
        Object[] modes = sql_mode.split(",");
        return ArrayTools.contains((Object[])modes, (Object)"ANSI_QUOTES");
    }

    private void dropTable(String tableName) throws Exception {
        this.executeUpdate("DROP TABLE IF EXISTS " + tableName);
    }
}

