/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.prefs;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.prefs.PreferencePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.prefs.PreferencesCollectionValueModel;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.model.value.prefs.PreferencesTestCase;

public class PreferencesCollectionValueModelTests
extends PreferencesTestCase {
    private Map<String, String> expectedValues;
    private ModifiablePropertyValueModel<Preferences> nodeHolder;
    PreferencesCollectionValueModel<String> preferencesAdapter;
    CollectionEvent event;
    CollectionChangeListener listener;
    private PropertyChangeListener itemListener;
    boolean listenerRemoved = false;
    private static final String KEY_NAME_1 = "foo 1";
    private static final String KEY_NAME_2 = "foo 2";
    private static final String KEY_NAME_3 = "foo 3";
    private static final String STRING_VALUE_1 = "original string value 1";
    private static final String STRING_VALUE_2 = "original string value 2";
    private static final String STRING_VALUE_3 = "original string value 3";

    public PreferencesCollectionValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedValues = new HashMap<String, String>();
        this.testNode.put(KEY_NAME_1, STRING_VALUE_1);
        this.expectedValues.put(KEY_NAME_1, STRING_VALUE_1);
        this.testNode.put(KEY_NAME_2, STRING_VALUE_2);
        this.expectedValues.put(KEY_NAME_2, STRING_VALUE_2);
        this.testNode.put(KEY_NAME_3, STRING_VALUE_3);
        this.expectedValues.put(KEY_NAME_3, STRING_VALUE_3);
        this.nodeHolder = new SimplePropertyValueModel((Object)this.testNode);
        this.preferencesAdapter = new PreferencesCollectionValueModel(this.nodeHolder, (PreferencesCollectionValueModel.Adapter)new XXX());
        this.listener = this.buildCollectionChangeListener();
        this.itemListener = this.buildItemListener();
        this.preferencesAdapter.addCollectionChangeListener("values", this.listener);
        this.event = null;
    }

    private CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void collectionChanged(CollectionChangeEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void collectionCleared(CollectionClearEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void itemsAdded(CollectionAddEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            private void logEvent(CollectionEvent e) {
                if (PreferencesCollectionValueModelTests.this.event != null) {
                    throw new IllegalStateException("unexpected this.event: " + e);
                }
                PreferencesCollectionValueModelTests.this.event = e;
            }
        };
    }

    private PropertyChangeListener buildItemListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                throw new IllegalStateException("unexpected this.event: " + e);
            }
        };
    }

    public void testSubjectHolder() throws Exception {
        this.verifyAdapter(this.preferencesAdapter);
        PreferencesCollectionValueModelTests.assertNull((Object)this.event);
        String ANOTHER_KEY_NAME_1 = "another key 1";
        String ANOTHER_KEY_NAME_2 = "another key 2";
        String ANOTHER_KEY_NAME_3 = "another key 3";
        String ANOTHER_STRING_VALUE_1 = "another string value 1";
        String ANOTHER_STRING_VALUE_2 = "another string value 2";
        String ANOTHER_STRING_VALUE_3 = "another string value 3";
        Preferences anotherNode = this.classNode.node("another test node");
        this.expectedValues.clear();
        anotherNode.put(ANOTHER_KEY_NAME_1, ANOTHER_STRING_VALUE_1);
        this.expectedValues.put(ANOTHER_KEY_NAME_1, ANOTHER_STRING_VALUE_1);
        anotherNode.put(ANOTHER_KEY_NAME_2, ANOTHER_STRING_VALUE_2);
        this.expectedValues.put(ANOTHER_KEY_NAME_2, ANOTHER_STRING_VALUE_2);
        anotherNode.put(ANOTHER_KEY_NAME_3, ANOTHER_STRING_VALUE_3);
        this.expectedValues.put(ANOTHER_KEY_NAME_3, ANOTHER_STRING_VALUE_3);
        this.nodeHolder.setValue((Object)anotherNode);
        this.verifyEvent();
        this.verifyAdapter(this.preferencesAdapter);
        this.event = null;
        this.expectedValues.clear();
        this.nodeHolder.setValue(null);
        this.verifyEvent();
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.preferencesAdapter.iterator().hasNext());
        this.event = null;
        this.nodeHolder.setValue((Object)this.testNode);
        this.verifyEvent();
        this.expectedValues.clear();
        this.expectedValues.put(KEY_NAME_1, STRING_VALUE_1);
        this.expectedValues.put(KEY_NAME_2, STRING_VALUE_2);
        this.expectedValues.put(KEY_NAME_3, STRING_VALUE_3);
        this.verifyAdapter(this.preferencesAdapter);
    }

    public void testAddPreference() throws Exception {
        this.verifyAdapter(this.preferencesAdapter);
        PreferencesCollectionValueModelTests.assertNull((Object)this.event);
        String ANOTHER_KEY_NAME = "another key";
        String ANOTHER_STRING_VALUE = "another string value";
        this.testNode.put(ANOTHER_KEY_NAME, ANOTHER_STRING_VALUE);
        this.waitForEventQueueToClear();
        HashMap<String, String> expectedItems = new HashMap<String, String>();
        expectedItems.put(ANOTHER_KEY_NAME, ANOTHER_STRING_VALUE);
        this.verifyEvent(expectedItems);
        this.expectedValues.put(ANOTHER_KEY_NAME, ANOTHER_STRING_VALUE);
        this.verifyAdapter(this.preferencesAdapter);
    }

    public void testRemovePreference() throws Exception {
        this.verifyAdapter(this.preferencesAdapter);
        PreferencesCollectionValueModelTests.assertNull((Object)this.event);
        this.testNode.remove(KEY_NAME_2);
        this.waitForEventQueueToClear();
        PreferencesCollectionValueModelTests.assertNotNull((Object)this.event);
        PreferencesCollectionValueModelTests.assertEquals(this.preferencesAdapter, (Object)this.event.getSource());
        PreferencesCollectionValueModelTests.assertEquals((String)"values", (String)this.event.getCollectionName());
        PreferencesCollectionValueModelTests.assertEquals((int)1, (int)((CollectionRemoveEvent)this.event).getItemsSize());
        String key = ((PreferencePropertyValueModel)((CollectionRemoveEvent)this.event).getItems().iterator().next()).getKey();
        PreferencesCollectionValueModelTests.assertEquals((String)KEY_NAME_2, (String)key);
        this.expectedValues.remove(KEY_NAME_2);
        this.verifyAdapter(this.preferencesAdapter);
    }

    public void testChangePreference() throws Exception {
        this.verifyAdapter(this.preferencesAdapter);
        PreferencesCollectionValueModelTests.assertNull((Object)this.event);
        String DIFFERENT = "something completely different";
        this.testNode.put(KEY_NAME_2, DIFFERENT);
        this.waitForEventQueueToClear();
        PreferencesCollectionValueModelTests.assertNull((Object)this.event);
        this.expectedValues.put(KEY_NAME_2, DIFFERENT);
        this.verifyAdapter(this.preferencesAdapter);
    }

    public void testValues() throws Exception {
        this.verifyNode(this.testNode);
        this.verifyAdapter(this.preferencesAdapter);
    }

    public void testRemoveNode() throws Exception {
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
        Preferences parent = this.testNode.parent();
        parent.addNodeChangeListener(this.buildParentNodeChangeListener());
        this.testNode.removeNode();
        this.testNode.flush();
        this.waitForEventQueueToClear();
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.listenerRemoved);
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
    }

    private NodeChangeListener buildParentNodeChangeListener() {
        return new NodeChangeListener(){

            @Override
            public void childAdded(NodeChangeEvent e) {
                throw new IllegalStateException("unexpected this.event: " + e);
            }

            @Override
            public void childRemoved(NodeChangeEvent e) {
                if (e.getChild() == PreferencesCollectionValueModelTests.this.testNode) {
                    PreferencesCollectionValueModelTests.this.preferencesAdapter.removeCollectionChangeListener("values", PreferencesCollectionValueModelTests.this.listener);
                    PreferencesCollectionValueModelTests.this.listenerRemoved = true;
                }
            }
        };
    }

    public void testHasListeners() throws Exception {
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        this.preferencesAdapter.removeCollectionChangeListener("values", this.listener);
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
        ChangeListener listener2 = this.buildChangeListener();
        this.preferencesAdapter.addChangeListener(listener2);
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
        PreferencesCollectionValueModelTests.assertTrue((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        this.preferencesAdapter.removeChangeListener(listener2);
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        PreferencesCollectionValueModelTests.assertFalse((boolean)this.preferencesAdapter.hasAnyCollectionChangeListeners("values"));
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void collectionChanged(CollectionChangeEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void collectionCleared(CollectionClearEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void itemsAdded(CollectionAddEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                this.logEvent((CollectionEvent)e);
            }

            private void logEvent(CollectionEvent e) {
                if (PreferencesCollectionValueModelTests.this.event != null) {
                    throw new IllegalStateException("unexpected this.event: " + e);
                }
                PreferencesCollectionValueModelTests.this.event = e;
            }
        };
    }

    private void verifyEvent(Map<String, String> items) {
        this.verifyEvent();
        PreferencesCollectionValueModelTests.assertEquals((int)items.size(), (int)((CollectionAddEvent)this.event).getItemsSize());
        Iterable eventItems = ((CollectionAddEvent)this.event).getItems();
        this.verifyItems(items, eventItems);
    }

    private void verifyEvent() {
        PreferencesCollectionValueModelTests.assertNotNull((Object)this.event);
        PreferencesCollectionValueModelTests.assertEquals(this.preferencesAdapter, (Object)this.event.getSource());
        PreferencesCollectionValueModelTests.assertEquals((String)"values", (String)this.event.getCollectionName());
    }

    private void verifyNode(Preferences node) throws Exception {
        String[] keys = node.keys();
        PreferencesCollectionValueModelTests.assertEquals((int)this.expectedValues.size(), (int)keys.length);
        int i = 0;
        while (i < keys.length) {
            PreferencesCollectionValueModelTests.assertEquals((String)this.expectedValues.get(keys[i]), (String)node.get(keys[i], "<missing preference>"));
            ++i;
        }
    }

    private void verifyAdapter(PreferencesCollectionValueModel<String> cvm) {
        PreferencesCollectionValueModelTests.assertEquals((int)this.expectedValues.size(), (int)cvm.size());
        this.verifyItems(this.expectedValues, (Iterable<PreferencePropertyValueModel<String>>)cvm);
    }

    private void verifyItems(Map<String, String> expected, Iterable<PreferencePropertyValueModel<String>> actual) {
        for (PreferencePropertyValueModel<String> model : actual) {
            model.addPropertyChangeListener("value", this.itemListener);
            PreferencesCollectionValueModelTests.assertEquals((String)expected.get(model.getKey()), (String)((String)model.getValue()));
            model.removePropertyChangeListener("value", this.itemListener);
        }
    }

    private boolean nodeHasAnyPrefListeners(Preferences node) throws Exception {
        PreferenceChangeListener[] prefListeners = (PreferenceChangeListener[])ObjectTools.get((Object)node, (String)"prefListeners");
        return prefListeners.length > 0;
    }

    protected static class XXX
    implements PreferencesCollectionValueModel.Adapter<String> {
        protected XXX() {
        }

        public PreferencePropertyValueModel<String> buildPreferenceModel(PropertyValueModel<? extends Preferences> preferencesModel, String key) {
            return PreferencePropertyValueModel.forString(preferencesModel, (String)key, null);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

