/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.EmptyStackException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.queue.StackQueue;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class StackQueueTests
extends TestCase {
    public StackQueueTests(String name) {
        super(name);
    }

    private Queue<String> buildQueue() {
        return QueueTools.stackQueue();
    }

    public void testConstructor_NPE() {
        boolean exCaught = false;
        try {
            StackQueue queue = QueueTools.adapt(null);
            StackQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        StackQueueTests.assertTrue((boolean)exCaught);
    }

    public void testIsEmpty() {
        Queue<String> queue = this.buildQueue();
        StackQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        StackQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        StackQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        StackQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        StackQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueAndDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        StackQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
    }

    public void testEnqueueAndPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        StackQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
    }

    public void testEmptyQueueExceptionPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        StackQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            String string = (String)queue.peek();
            StackQueueTests.fail((String)("bogus element: " + string));
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        StackQueueTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        StackQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        StackQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            String string = (String)queue.dequeue();
            StackQueueTests.fail((String)("bogus element: " + string));
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        StackQueueTests.assertTrue((boolean)exCaught);
    }

    public void testSerialization() throws Exception {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone(queue, TestTools.serialize(queue));
    }

    protected void verifyClone(Queue<String> original, Queue<String> clone) {
        StackQueueTests.assertNotSame(original, clone);
        StackQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        StackQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        StackQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        StackQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        StackQueueTests.assertTrue((boolean)original.isEmpty());
        StackQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        StackQueueTests.assertFalse((boolean)original.isEmpty());
        StackQueueTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testToString() throws Exception {
        Queue<String> queue = this.buildQueue();
        StackQueueTests.assertEquals((String)"[]", (String)queue.toString());
        queue.enqueue((Object)"first");
        StackQueueTests.assertEquals((String)"[first]", (String)queue.toString());
        queue.enqueue((Object)"second");
        StackQueueTests.assertEquals((String)"[second, first]", (String)queue.toString());
        queue.enqueue((Object)"third");
        StackQueueTests.assertEquals((String)"[third, second, first]", (String)queue.toString());
    }
}

