/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.reference.ObjectReference;

public abstract class ObjectReferenceTests
extends TestCase {
    public ObjectReferenceTests(String name) {
        super(name);
    }

    protected ObjectReference<String> buildObjectReference() {
        return this.buildObjectReference(null);
    }

    protected abstract ObjectReference<String> buildObjectReference(String var1);

    public void testGetValue() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertNull((Object)or.getValue());
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
    }

    public void testValueEqualsObject() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.valueEquals(null));
        ObjectReferenceTests.assertFalse((boolean)or.valueEquals((Object)"foo"));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertFalse((boolean)or.valueEquals(null));
        ObjectReferenceTests.assertTrue((boolean)or.valueEquals((Object)"foo"));
        ObjectReferenceTests.assertTrue((boolean)or.valueEquals((Object)new String("foo")));
    }

    public void testValueNotEqualObject() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or.valueNotEqual(null));
        ObjectReferenceTests.assertTrue((boolean)or.valueNotEqual((Object)"foo"));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertTrue((boolean)or.valueNotEqual(null));
        ObjectReferenceTests.assertFalse((boolean)or.valueNotEqual((Object)"foo"));
        ObjectReferenceTests.assertFalse((boolean)or.valueNotEqual((Object)new String("foo")));
    }

    public void testIsObject() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.is(null));
        ObjectReferenceTests.assertFalse((boolean)or.is((Object)"foo"));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertFalse((boolean)or.is(null));
        ObjectReferenceTests.assertTrue((boolean)or.is((Object)"foo"));
        ObjectReferenceTests.assertFalse((boolean)or.is((Object)new String("foo")));
    }

    public void testIsNotObject() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or.isNot(null));
        ObjectReferenceTests.assertTrue((boolean)or.isNot((Object)"foo"));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertTrue((boolean)or.isNot(null));
        ObjectReferenceTests.assertFalse((boolean)or.isNot((Object)"foo"));
        ObjectReferenceTests.assertTrue((boolean)or.isNot((Object)new String("foo")));
    }

    public void testIsNull() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.isNull());
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertFalse((boolean)or.isNull());
    }

    public void testIsNotNull() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or.isNotNull());
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertTrue((boolean)or.isNotNull());
    }

    public void testIsMemberOfPredicate() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.isMemberOf(PredicateTools.isNull()));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertFalse((boolean)or.isMemberOf(PredicateTools.isNull()));
    }

    public void testIsNotMemberOfPredicate() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.isNotMemberOf(PredicateTools.isNotNull()));
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertFalse((boolean)or.isNotMemberOf(PredicateTools.isNotNull()));
    }

    public void testEqualsObject() {
        ObjectReference<String> or1 = this.buildObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or1.equals(or1));
        ObjectReference<String> or2 = this.buildObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or1.equals(or2));
    }

    public void testHashCode() {
        ObjectReference<String> or1 = this.buildObjectReference();
        ObjectReferenceTests.assertEquals((int)or1.hashCode(), (int)or1.hashCode());
    }

    public void testToString() {
        ObjectReference<String> or = this.buildObjectReference();
        ObjectReferenceTests.assertEquals((String)"[null]", (String)or.toString());
        or = this.buildObjectReference("foo");
        ObjectReferenceTests.assertEquals((String)"[foo]", (String)or.toString());
    }
}

