/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;

public class SearchParticipantTests
extends ModifyingResourceTests
implements IJavaScriptSearchConstants {
    IJavaScriptProject project;
    boolean deleteProject = true;

    public static Test suite() {
        return SearchParticipantTests.buildModelTestSuite(SearchParticipantTests.class);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.deleteFile(this.getIndexLocation().toFile());
    }

    @Override
    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        if (this.project != null) {
            this.deleteProject("P");
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.project == null) {
            this.project = this.createJavaProject("P");
        }
        this.deleteProject = true;
        if (JobManager.VERBOSE) {
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("Run test " + this.getName() + "...");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.deleteProject) {
            this.deleteProject("P");
            this.project = null;
        }
        super.tearDown();
    }

    public SearchParticipantTests(String name) {
        super(name);
    }

    IPath getIndexLocation() {
        return new Path(String.valueOf(this.getExternalPath()) + "test.index");
    }

    public void testScheduleDocumentIndexing1() throws CoreException {
        this.createFile("/P/X.test", "");
        TestSearchParticipant participant = new TestSearchParticipant();
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        SearchParticipantTests.assertTrue((String)"Should have requested to index document", (boolean)document.indexingRequested);
    }

    public void testScheduleDocumentIndexing2() throws CoreException {
        TestSearchParticipant participant = new TestSearchParticipant();
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        SearchParticipantTests.assertTrue((String)"Should have requested to index document", (boolean)document.indexingRequested);
    }

    public synchronized void testIndexDocument01() throws CoreException, InterruptedException {
        this.createFile("/P/X.test", "function X() {\n}");
        TestSearchParticipant participant = new TestSearchParticipant();
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        ((Object)((Object)this)).wait(1100L);
        document = new TestSearchDocument("/P/no", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        SearchParticipantTests.assertTrue((String)"Index file should have been written", (this.getIndexLocation().toFile().length() > 0L ? 1 : 0) != 0);
        participant.removeIndex(this.getIndexLocation());
        SearchParticipantTests.assertFalse((String)"Index file should have been removed", (boolean)this.getIndexLocation().toFile().exists());
    }

    public synchronized void testIndexDocument02() throws CoreException, InterruptedException {
        TestSearchParticipant participant = new TestSearchParticipant(this){

            @Override
            public void indexDocument(SearchDocument document, IPath indexLocation) {
                if (!document.getPath().equals("/P/no")) {
                    int i = 0;
                    while (i < 1000) {
                        document.addIndexEntry(("category" + i).toCharArray(), ("key" + i).toCharArray());
                        ++i;
                    }
                }
            }
        };
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        ((Object)((Object)this)).wait(1100L);
        document = new TestSearchDocument("/P/no", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        ((Object)((Object)this)).wait(1100L);
        SearchParticipantTests.assertTrue((String)"Index file should have been written", (this.getIndexLocation().toFile().length() > 0L ? 1 : 0) != 0);
        this.simulateExit();
        SearchParticipantTests.assertTrue((String)"Index file should stay after shutdown", (this.getIndexLocation().toFile().length() > 0L ? 1 : 0) != 0);
        this.deleteProject = false;
        participant.removeIndex(this.getIndexLocation());
        SearchParticipantTests.assertFalse((String)"Index file should have been removed", (boolean)this.getIndexLocation().toFile().exists());
        this.simulateRestart();
    }

    public synchronized void testIndexDocument03() throws CoreException, InterruptedException {
        this.createFile("/P/X.test", "function X() {\n}");
        TestSearchParticipant participant = new TestSearchParticipant();
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        ((Object)((Object)this)).wait(1100L);
        document = new TestSearchDocument("/P/no", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        SearchParticipantTests.assertTrue((String)"Index file should have been written", (this.getIndexLocation().toFile().length() > 0L ? 1 : 0) != 0);
        participant.removeIndex(this.getIndexLocation());
        SearchParticipantTests.assertFalse((String)"Index file should have been removed", (boolean)this.getIndexLocation().toFile().exists());
    }

    public void testSearch() throws CoreException {
        this.createFile("/P/X.test", "function X() {\n}");
        TestSearchParticipant participant = new TestSearchParticipant();
        TestSearchDocument document = new TestSearchDocument("/P/X.test", participant);
        participant.scheduleDocumentIndexing((SearchDocument)document, this.getIndexLocation());
        SearchParticipantTests.waitUntilIndexesReady();
        SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)13, (int)13, (int)0);
        IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
        TestResultCollector requestor = new TestResultCollector();
        new SearchEngine().search(pattern, new SearchParticipant[]{participant}, scope, (SearchRequestor)requestor, null);
        this.assertSearchResults("X.test X [X]", (Object)requestor);
    }

    public class TestResultCollector
    extends AbstractJavaSearchTests.JavaSearchResultCollector {
        @Override
        protected char[] getSource(IResource resource, IJavaScriptElement element, IJavaScriptUnit unit) throws JavaScriptModelException {
            IPath path = resource.getLocation().removeFileExtension().addFileExtension("test");
            String fileContent = Util.fileContent((String)path.toFile().getPath());
            if (fileContent == null) {
                return null;
            }
            return fileContent.toCharArray();
        }

        @Override
        protected String getPathString(IResource resource, IJavaScriptElement element) {
            return super.getPathString(resource, element).replaceAll(".js", ".test");
        }
    }

    public class TestSearchDocument
    extends JavaSearchDocument {
        public boolean indexingRequested;
        private String fileSystemPath;

        protected TestSearchDocument(String documentPath, SearchParticipant participant) {
            super(documentPath, participant);
            this.fileSystemPath = SearchParticipantTests.this.getWorkspaceRoot().getFile((IPath)new Path(documentPath)).getLocation().toOSString();
        }

        public byte[] getByteContents() {
            String fileContent = Util.fileContent((String)this.fileSystemPath);
            if (fileContent == null) {
                return null;
            }
            return fileContent.getBytes();
        }

        public char[] getCharContents() {
            String fileContent = Util.fileContent((String)this.fileSystemPath);
            if (fileContent == null) {
                return null;
            }
            return fileContent.toCharArray();
        }

        public String getEncoding() {
            return null;
        }
    }

    public class TestSearchParticipant
    extends SearchParticipant {
        private SearchParticipant defaultSearchParticipant = SearchEngine.getDefaultSearchParticipant();

        public SearchDocument getDocument(String documentPath) {
            return new TestSearchDocument(documentPath, this);
        }

        public void indexDocument(SearchDocument document, IPath indexLocation) {
            ((TestSearchDocument)document).indexingRequested = true;
            document.removeAllIndexEntries();
            String documentPath = document.getPath();
            if (documentPath.endsWith(".test")) {
                new SourceIndexer(document).indexDocument();
            }
        }

        public void locateMatches(SearchDocument[] documents, SearchPattern pattern, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
            int length = documents.length;
            SearchDocument[] wrapperDocuments = new SearchDocument[length];
            int i = 0;
            while (i < length) {
                wrapperDocuments[i] = new WrapperDocument(documents[i], this);
                ++i;
            }
            this.defaultSearchParticipant.locateMatches(wrapperDocuments, pattern, scope, requestor, monitor);
        }

        public IPath[] selectIndexes(SearchPattern query, IJavaScriptSearchScope scope) {
            return new IPath[]{SearchParticipantTests.this.getIndexLocation()};
        }

        class WrapperDocument
        extends SearchDocument {
            private SearchDocument document;

            WrapperDocument(SearchDocument document, SearchParticipant participant) {
                super(document.getPath().replaceAll(".test", ".js"), participant);
                this.document = document;
            }

            public byte[] getByteContents() {
                return this.document.getByteContents();
            }

            public char[] getCharContents() {
                return this.document.getCharContents();
            }

            public String getEncoding() {
                return this.document.getEncoding();
            }
        }
    }
}

