/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class WorkingCopyNotInClasspathTests
extends ModifyingResourceTests {
    private IJavaScriptUnit workingCopy;

    public WorkingCopyNotInClasspathTests(String name) {
        super(name);
    }

    public static Test suite() {
        return WorkingCopyNotInClasspathTests.buildModelTestSuite(WorkingCopyNotInClasspathTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.createJavaProject("P", new String[]{"src"});
            this.createFolder("P/txt");
            IFile file = this.createFile("P/txt/X.js", "public class X {\n}");
            IJavaScriptUnit cu = (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
            this.workingCopy = cu.getWorkingCopy(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.workingCopy != null) {
                this.workingCopy.discardWorkingCopy();
                this.workingCopy = null;
            }
            this.deleteProject("P");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    public void testCommitWorkingCopy1() throws CoreException {
        IJavaScriptUnit primary = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary element should not be null", (primary != null ? 1 : 0) != 0);
        IBuffer workingCopyBuffer = this.workingCopy.getBuffer();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
        String newContents = "public class X {\n  public void foo() {\n  }\n}";
        workingCopyBuffer.setContents(newContents);
        this.workingCopy.commitWorkingCopy(false, null);
        IFile originalFile = (IFile)primary.getResource();
        this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
    }

    public void testCommitWorkingCopy2() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P2", new String[]{"src"}, null, null, null, "bin", null, null, new String[][]{{"p1/"}}, "1.4");
            this.createFolder("/P2/src/p1/p2");
            this.createFile("/P2/src/p1/p2/X.js", "");
            copy = this.getCompilationUnit("P2", "src", "p1.p2", "X.js").getWorkingCopy(null);
            copy.getBuffer().setContents("public class X {}");
            copy.makeConsistent(null);
            copy.commitWorkingCopy(false, null);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P2");
        }
    }

    public void testExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy should exist", (boolean)this.workingCopy.exists());
    }

    public void testGetSource() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createJavaProject("P1", new String[0]);
            this.createFolder("/P1/src/junit/test");
            String source = "package junit.test;\npublic class X {\n}";
            IFile file = this.createFile("/P1/src/junit/test/X.js", source);
            IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            copy = cu.getWorkingCopy(null);
            WorkingCopyNotInClasspathTests.assertEquals((String)"Unexpected source", (String)source, (String)copy.getSource());
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("P1");
        }
    }

    public void testParentExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy's parent should not exist", (!this.workingCopy.getParent().exists() ? 1 : 0) != 0);
    }

    public void testReconcileNonExistingProject() throws CoreException {
        IJavaScriptUnit wc = null;
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getProject("NonExisting").getFile("A.js");
            wc = JavaScriptCore.createCompilationUnitFrom((IFile)file).getWorkingCopy(null);
            wc.reconcile(0, false, null, null);
        }
        finally {
            if (wc != null) {
                wc.discardWorkingCopy();
            }
        }
    }

    public void testReconcileSimpleProject() throws CoreException {
        IJavaScriptUnit wc = null;
        try {
            IProject project = this.createProject("SimpleProject");
            IFile file = project.getFile("A.js");
            wc = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            new AbstractJavaModelTests.ProblemRequestor();
            wc.becomeWorkingCopy(null);
            wc.getBuffer().setContents("public class A {}");
            wc.reconcile(0, true, null, null);
        }
        finally {
            if (wc != null) {
                wc.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testReconcileSimpleProject2() throws CoreException {
        IJavaScriptUnit wc = null;
        try {
            IProject project = this.createProject("SimpleProject");
            IFile file = project.getFile("A.js");
            wc = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            new AbstractJavaModelTests.ProblemRequestor();
            wc.becomeWorkingCopy(null);
            wc.reconcile(0, true, null, null);
        }
        finally {
            if (wc != null) {
                wc.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testSimpleProject() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createProject("SimpleProject");
            IFile file = this.createFile("/SimpleProject/X.js", "public class X {\n}");
            IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            copy = cu.getWorkingCopy(null);
            try {
                copy.getChildren();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                WorkingCopyNotInClasspathTests.assertTrue((String)"Should not get JavaScriptModelException", (boolean)false);
            }
        }
        catch (Throwable throwable) {
            if (copy != null) {
                ((IJavaScriptUnit)copy).discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
            throw throwable;
        }
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        this.deleteProject("SimpleProject");
    }

    public void testPrimaryExistence() {
        IJavaScriptUnit primary = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation unit should not exist", (!primary.exists() ? 1 : 0) != 0);
    }

    public void testPrimaryParentExistence() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation unit's parent should not exist", (!this.workingCopy.getPrimary().getParent().exists() ? 1 : 0) != 0);
    }

    public void testIsOpen() {
        WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy should be open", (boolean)this.workingCopy.isOpen());
    }

    public void testPrimaryIsOpen() {
        IJavaScriptUnit original = this.workingCopy.getPrimary();
        WorkingCopyNotInClasspathTests.assertTrue((String)"Primary compilation should not be opened", (!original.isOpen() ? 1 : 0) != 0);
    }

    public void testIsOnClasspath() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createProject("SimpleProject");
            this.createFolder("/SimpleProject/src/junit/test");
            String source = "package junit.test;\npublic class X {\n}";
            IFile file = this.createFile("/SimpleProject/src/junit/test/X.js", source);
            IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
            copy = cu.getWorkingCopy(null);
            boolean isOnClasspath = copy.getJavaScriptProject().isOnIncludepath((IJavaScriptElement)copy);
            WorkingCopyNotInClasspathTests.assertTrue((String)"working copy shouldn't answer to isOnClasspath", (!isOnClasspath ? 1 : 0) != 0);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testReconcileAndCommit1() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            try {
                this.createJavaProject("JavaProject", new String[]{"src"});
                this.createFolder("/JavaProject/src/native.1");
                String source = "class X {}";
                IFile file = this.createFile("/JavaProject/src/native.1/X.js", source);
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                IBuffer workingCopyBuffer = copy.getBuffer();
                WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                String newContents = "public class X {\n  public void foo() {\n  }\n}";
                workingCopyBuffer.setContents(newContents);
                copy.reconcile(0, true, null, null);
                copy.commitWorkingCopy(true, null);
                IFile originalFile = (IFile)cu.getResource();
                this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("JavaProject");
            }
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("JavaProject");
        }
    }

    public void testReconcileAndCommit2() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            try {
                this.createProject("SimpleProject");
                this.createFolder("/SimpleProject/src/native.1");
                String source = "class X {}";
                IFile file = this.createFile("/SimpleProject/src/native.1/X.js", source);
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                IBuffer workingCopyBuffer = copy.getBuffer();
                WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                String newContents = "public class X {\n  public void foo() {\n  }\n}";
                workingCopyBuffer.setContents(newContents);
                copy.reconcile(0, true, null, null);
                copy.commitWorkingCopy(true, null);
                IFile originalFile = (IFile)cu.getResource();
                this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should not have been saved successfully", (boolean)workingCopyBuffer.hasUnsavedChanges());
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
            }
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testReconcileAndCommit3() throws CoreException {
        IJavaScriptUnit primary = null;
        try {
            try {
                this.createProject("SimpleProject");
                this.createFolder("/SimpleProject/src/native.1");
                String source = "class X {}";
                IFile file = this.createFile("/SimpleProject/src/native.1/X.js", source);
                primary = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                primary.becomeWorkingCopy(null);
                IBuffer workingCopyBuffer = primary.getBuffer();
                WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                String newContents = "public class X {\n  public void foo() {\n  }\n}";
                workingCopyBuffer.setContents(newContents);
                primary.reconcile(0, true, null, null);
                primary.commitWorkingCopy(true, null);
                IFile originalFile = (IFile)primary.getResource();
                this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should have been saved successfully", (!workingCopyBuffer.hasUnsavedChanges() ? 1 : 0) != 0);
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                if (primary != null) {
                    primary.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
            }
        }
        finally {
            if (primary != null) {
                primary.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testReconcileAndCommit4() throws CoreException {
        IJavaScriptUnit primary = null;
        try {
            try {
                this.createProject("SimpleProject");
                this.createFolder("/SimpleProject/src/native.1");
                String source = "class X {}";
                IFile file = this.createFile("/SimpleProject/src/native.1/some invalid name.js", source);
                primary = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                primary.becomeWorkingCopy(null);
                IBuffer workingCopyBuffer = primary.getBuffer();
                WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                String newContents = "public class X {\n  public void foo() {\n  }\n}";
                workingCopyBuffer.setContents(newContents);
                primary.reconcile(0, true, null, null);
                primary.commitWorkingCopy(true, null);
                IFile originalFile = (IFile)primary.getResource();
                this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
                WorkingCopyNotInClasspathTests.assertTrue((String)"buffer should have been saved successfully", (!workingCopyBuffer.hasUnsavedChanges() ? 1 : 0) != 0);
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                if (primary != null) {
                    primary.discardWorkingCopy();
                }
                this.deleteProject("SimpleProject");
            }
        }
        finally {
            if (primary != null) {
                primary.discardWorkingCopy();
            }
            this.deleteProject("SimpleProject");
        }
    }

    public void testReconcileAndCommit5() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            try {
                this.createJavaProject("JavaProject", new String[]{"src"});
                this.createFolder("/JavaProject/src/p");
                String source = "package p; \npublic class X {}";
                IFile file = this.createFile("/JavaProject/src/invalid unit name.js", source);
                IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
                copy = cu.getWorkingCopy(null);
                IBuffer workingCopyBuffer = copy.getBuffer();
                WorkingCopyNotInClasspathTests.assertTrue((String)"Working copy buffer should not be null", (workingCopyBuffer != null ? 1 : 0) != 0);
                String newContents = "public class X {\n  public void foo() {\n  }\n}";
                workingCopyBuffer.setContents(newContents);
                copy.reconcile(0, true, null, null);
                copy.commitWorkingCopy(true, null);
                IFile originalFile = (IFile)cu.getResource();
                this.assertSourceEquals("Unexpected contents", newContents, new String(Util.getResourceContentsAsCharArray((IFile)originalFile)));
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                WorkingCopyNotInClasspathTests.assertTrue((String)("No exception should have occurred: " + e.getMessage()), (boolean)false);
                if (copy != null) {
                    copy.discardWorkingCopy();
                }
                this.deleteProject("JavaProject");
            }
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
            this.deleteProject("JavaProject");
        }
    }
}

