/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadValidatorTestCase
extends BaseReadTestCase {
    public ReadValidatorTestCase(String name) {
        super(name);
    }

    public void testSingleValidator() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadValidatorTestCase.assertNotNull((Object)this.getValidator1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    ValidatorType getValidator1(FacesConfigType facesConfig) {
        return (ValidatorType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getValidator(), "validator1");
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator1 = this.getValidator1(edit.getFacesConfig());
            ReadValidatorTestCase.assertNotNull((Object)validator1);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)validator1.getDescription(), "validator1_description");
            ReadValidatorTestCase.assertEquals((String)"validator-description", (String)descType.getTextContent());
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)validator1.getDisplayName(), "validator1_displayName");
            ReadValidatorTestCase.assertEquals((String)"validator-display-name", (String)displayNameType.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)validator1.getIcon(), "validator1_icon");
            ReadValidatorTestCase.assertEquals((String)"validator-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadValidatorTestCase.assertEquals((String)"validator-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testValidatorSingleValueProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator1 = this.getValidator1(edit.getFacesConfig());
            ReadValidatorTestCase.assertNotNull((Object)validator1);
            ReadValidatorTestCase.assertEquals((String)"validator-Id", (String)validator1.getValidatorId().getTextContent());
            ReadValidatorTestCase.assertEquals((String)"validator-class", (String)validator1.getValidatorClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator = this.getValidator1(edit.getFacesConfig());
            ReadValidatorTestCase.assertEquals((int)1, (int)validator.getAttribute().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator = this.getValidator1(edit.getFacesConfig());
            ReadValidatorTestCase.assertEquals((int)1, (int)validator.getProperty().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

