/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.wst.jsdt.chromium.internal.transport.ChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;

public class ControlledFakeConnection
extends FakeConnection {
    private final Queue<Message> messages = new ConcurrentLinkedQueue<Message>();
    private boolean isContinuousProcessing = false;

    public ControlledFakeConnection(ChromeStub responder) {
        super(responder);
    }

    @Override
    public void send(Message message) {
        if (this.isContinuousProcessing) {
            super.send(message);
        } else {
            this.messages.add(message);
        }
    }

    public void setContinuousProcessing(boolean enabled) {
        this.isContinuousProcessing = enabled;
    }

    public void processMessages(int count) {
        int i = 0;
        while (i < count) {
            Message polled = this.messages.poll();
            if (polled == null) break;
            super.send(polled);
            ++i;
        }
    }
}

