/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;

public class AnnotationUtilsTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testRemove() throws Exception {
        this.setUp();
        IValue sv = AnnotationFactory.createStringValue((String)"My String Value");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"Param", (IValue)sv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint.getField("field1"));
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint.getField("field1"));
        AnnotationUtilsTest.assertEquals((Object)ann.getAppliedElement(), (Object)this.endpoint.getField("field1"));
        AnnotationWriter.getInstance().remove(ann);
    }
}

