/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt.bindings;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComboBoxModelBindingUITest
extends ApplicationWindow {
    private final SimpleListValueModel<String> nameListModel = this.buildNameListModel();
    private final TestModel testModel = new TestModel("Scooby-Doo");
    private static final String DEFAULT_NAME = "Scooby-Doo";
    private final ModifiablePropertyValueModel<TestModel> testModelModel = new SimplePropertyValueModel((Object)this.testModel);
    private final ModifiablePropertyValueModel<String> nameModel = new NameModel((PropertyValueModel<TestModel>)this.testModelModel);
    private final PropertyValueModel<String> allCapsNameModel = this.buildAllCapsNameModel((PropertyValueModel<TestModel>)this.testModelModel);
    private final ModifiablePropertyValueModel<String> nameListSelectionModel = new SimplePropertyValueModel();
    private final ModifiablePropertyValueModel<String> nameListIndexTextModel = new SimplePropertyValueModel();
    private final ModifiablePropertyValueModel<String> nameListNameModel = new SimplePropertyValueModel();
    private static final Transformer<String, Integer> STRING_INTEGER_TRANSFORMER = new StringIntegerTransformer();
    public static final Transformer<String, String> UPPER_CASE_TRANSFORMER = new UpperCaseTransformer();
    private static final Iterable<String> REPLACEMENT_LIST = ArrayTools.iterable((Object[])new String[]{"AAAA", "BBBB", "CCCC", "DDDD", "EEEE"});

    public static void main(String[] args) throws Exception {
        ComboBoxModelBindingUITest window = new ComboBoxModelBindingUITest();
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private ComboBoxModelBindingUITest() {
        super(null);
    }

    private SimpleListValueModel<String> buildNameListModel() {
        SimpleListValueModel x = new SimpleListValueModel();
        x.add((Object)"Daphne");
        x.add((Object)"Fred");
        x.add((Object)DEFAULT_NAME);
        x.add((Object)"Shaggy");
        x.add((Object)"Velma");
        return x;
    }

    private PropertyValueModel<String> buildAllCapsNameModel(PropertyValueModel<TestModel> vm) {
        return new TransformationPropertyValueModel((PropertyValueModel)new NameModel(vm), UPPER_CASE_TRANSFORMER);
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(400, 500);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new FormLayout());
        Control comboBoxPanel = this.buildComboBoxPanel(mainPanel);
        Control comboBoxControlPanel = this.buildComboBoxControlPanel(mainPanel, comboBoxPanel);
        Control nameListControlPanel = this.buildNameListControlPanel(mainPanel);
        this.buildNameListPanel(mainPanel, comboBoxControlPanel, nameListControlPanel);
        return mainPanel;
    }

    private Control buildComboBoxPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(0, 35);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildNameComboBox(panel);
        this.buildNameLabel(panel);
        this.buildAllCapsNameLabel(panel);
        return panel;
    }

    private void buildNameComboBox(Composite parent) {
        Combo comboBox = new Combo(parent, 4);
        SWTBindingTools.bindComboBox(this.nameListModel, this.nameModel, (Combo)comboBox);
    }

    private void buildNameLabel(Composite parent) {
        Label textLabel = new Label(parent, 0);
        SWTBindingTools.bindTextLabel(this.nameModel, (Label)textLabel);
    }

    private void buildAllCapsNameLabel(Composite parent) {
        Label textLabel = new Label(parent, 0);
        SWTBindingTools.bindTextLabel(this.allCapsNameModel, (Label)textLabel);
    }

    private Control buildComboBoxControlPanel(Composite parent, Control comboBoxPanel) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(comboBoxPanel);
        fd.bottom = new FormAttachment(comboBoxPanel, 35, 1024);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildResetNameButton(panel);
        this.buildClearModelButton(panel);
        this.buildRestoreModelButton(panel);
        this.buildPrintModelButton(panel);
        return panel;
    }

    private void buildResetNameButton(Composite parent) {
        this.buildResetNameACI().fill(parent);
    }

    private ActionContributionItem buildResetNameACI() {
        Action action = new Action("reset name", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.resetName();
            }
        };
        action.setToolTipText("reset name");
        return new ActionContributionItem((IAction)action);
    }

    void resetName() {
        this.testModel.setName(DEFAULT_NAME);
    }

    private void buildClearModelButton(Composite parent) {
        this.buildClearModelACI().fill(parent);
    }

    private ActionContributionItem buildClearModelACI() {
        Action action = new Action("clear model", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.clearModel();
            }
        };
        action.setToolTipText("clear model");
        return new ActionContributionItem((IAction)action);
    }

    void clearModel() {
        this.testModelModel.setValue(null);
    }

    private void buildRestoreModelButton(Composite parent) {
        this.buildRestoreModelACI().fill(parent);
    }

    private ActionContributionItem buildRestoreModelACI() {
        Action action = new Action("restore model", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.restoreModel();
            }
        };
        action.setToolTipText("restore model");
        return new ActionContributionItem((IAction)action);
    }

    void restoreModel() {
        this.testModelModel.setValue((Object)this.testModel);
    }

    private void buildPrintModelButton(Composite parent) {
        this.buildPrintModelACI().fill(parent);
    }

    private ActionContributionItem buildPrintModelACI() {
        Action action = new Action("print model", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.printModel();
            }
        };
        action.setToolTipText("print model");
        return new ActionContributionItem((IAction)action);
    }

    void printModel() {
        System.out.println("current model: " + (Object)((Object)this.testModel));
    }

    private Control buildNameListPanel(Composite parent, Control comboBoxControlPanel, Control nameListControlPanel) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment(comboBoxControlPanel);
        fd.bottom = new FormAttachment(nameListControlPanel);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        Label listLabel = new Label(panel, 16896);
        listLabel.setText("Names");
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(0, 35);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        listLabel.setLayoutData((Object)fd);
        List listBox = new List(panel, 2052);
        fd = new FormData();
        fd.top = new FormAttachment((Control)listLabel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        listBox.setLayoutData((Object)fd);
        SWTBindingTools.bind(this.nameListModel, this.nameListSelectionModel, (List)listBox);
        return panel;
    }

    private Control buildNameListControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(100, -35);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildNameListIndexTextField(panel);
        this.buildNameListNameTextField(panel);
        this.buildAddNameButton(panel);
        this.buildSetNameButton(panel);
        this.buildRemoveNameButton(panel);
        this.buildReplaceNameListButton(panel);
        this.buildClearNameListButton(panel);
        return panel;
    }

    private void buildNameListIndexTextField(Composite parent) {
        Text textField = new Text(parent, 2052);
        SWTBindingTools.bind(this.nameListIndexTextModel, (Text)textField);
    }

    private void buildNameListNameTextField(Composite parent) {
        Text textField = new Text(parent, 2052);
        SWTBindingTools.bind(this.nameListNameModel, (Text)textField);
    }

    private void buildAddNameButton(Composite parent) {
        this.buildAddNameACI().fill(parent);
    }

    private ActionContributionItem buildAddNameACI() {
        Action action = new Action("add", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.addName();
            }
        };
        action.setToolTipText("add");
        return new ActionContributionItem((IAction)action);
    }

    void addName() {
        int index = (Integer)STRING_INTEGER_TRANSFORMER.transform((Object)((String)this.nameListIndexTextModel.getValue()));
        String newName = (String)this.nameListNameModel.getValue();
        if (StringTools.isNotBlank((String)newName)) {
            this.nameListModel.add(index, (Object)newName);
        }
    }

    private void buildSetNameButton(Composite parent) {
        this.buildSetNameACI().fill(parent);
    }

    private ActionContributionItem buildSetNameACI() {
        Action action = new Action("set", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.setName();
            }
        };
        action.setToolTipText("set");
        return new ActionContributionItem((IAction)action);
    }

    void setName() {
        int index = (Integer)STRING_INTEGER_TRANSFORMER.transform((Object)((String)this.nameListIndexTextModel.getValue()));
        String newName = (String)this.nameListNameModel.getValue();
        if (StringTools.isNotBlank((String)newName)) {
            this.nameListModel.set(index, (Object)newName);
        }
    }

    private void buildRemoveNameButton(Composite parent) {
        this.buildRemoveNameACI().fill(parent);
    }

    private ActionContributionItem buildRemoveNameACI() {
        Action action = new Action("remove", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.removeName();
            }
        };
        action.setToolTipText("remove");
        return new ActionContributionItem((IAction)action);
    }

    void removeName() {
        this.nameListModel.remove(this.nameListNameModel.getValue());
    }

    private void buildClearNameListButton(Composite parent) {
        this.buildClearNameListACI().fill(parent);
    }

    private ActionContributionItem buildClearNameListACI() {
        Action action = new Action("clear", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.clearNameList();
            }
        };
        action.setToolTipText("clear");
        return new ActionContributionItem((IAction)action);
    }

    void clearNameList() {
        this.nameListModel.clear();
    }

    private void buildReplaceNameListButton(Composite parent) {
        this.buildReplaceNameListACI().fill(parent);
    }

    private ActionContributionItem buildReplaceNameListACI() {
        Action action = new Action("replace", 1){

            public void run() {
                ComboBoxModelBindingUITest.this.replaceNameList();
            }
        };
        action.setToolTipText("replace");
        return new ActionContributionItem((IAction)action);
    }

    void replaceNameList() {
        this.nameListModel.setListValues(REPLACEMENT_LIST);
    }

    private static class NameModel
    extends PropertyAspectAdapter<TestModel, String> {
        NameModel(PropertyValueModel<TestModel> vm) {
            super(vm, new String[]{"name"});
        }

        protected String buildValue_() {
            return ((TestModel)((Object)this.subject)).name();
        }

        protected void setValue_(String value) {
            ((TestModel)((Object)this.subject)).setName(value);
        }
    }

    static class StringIntegerTransformer
    extends TransformerAdapter<String, Integer> {
        StringIntegerTransformer() {
        }

        public Integer transform(String input) {
            try {
                return Integer.valueOf(input);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    class TestModel
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public TestModel(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            if (this.firePropertyChanged(NAME_PROPERTY, old, name)) {
                System.out.println("set model name: " + name);
            }
        }

        public String toString() {
            return "TestModel(" + this.name + ")";
        }
    }

    static class UpperCaseTransformer
    extends AbstractTransformer<String, String> {
        UpperCaseTransformer() {
        }

        protected String transform_(String string) {
            return string.toUpperCase();
        }
    }
}

