/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import java.util.List;
import org.eclipse.wst.xml.catalog.tests.internal.AbstractCatalogTest;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;

public class CatalogTest
extends AbstractCatalogTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CatalogTest(String name) {
        super(name);
    }

    public void testCatalog() throws Exception {
        Catalog workingUserCatalog = new Catalog(null, "working", null);
        CatalogTest.assertNotNull((Object)this.userCatalog);
        workingUserCatalog.addEntriesFromCatalog(this.userCatalog);
        ICatalogEntry catalogEntry = (ICatalogEntry)this.userCatalog.createCatalogElement(2);
        catalogEntry.setKey("testKey");
        catalogEntry.setURI("http://testuri");
        workingUserCatalog.addCatalogElement((ICatalogElement)catalogEntry);
        this.userCatalog.addEntriesFromCatalog((ICatalog)workingUserCatalog);
        String userCatalogLocation = this.userCatalog.getLocation();
        this.userCatalog.save();
        this.userCatalog.clear();
        this.userCatalog = this.getCatalog("user_catalog", userCatalogLocation);
        List entries = CatalogTest.getCatalogEntries(this.userCatalog, 2);
        CatalogTest.assertEquals((int)1, (int)entries.size());
        ICatalogEntry entry = (ICatalogEntry)entries.get(0);
        CatalogTest.assertEquals((String)"http://testuri", (String)entry.getURI());
        CatalogTest.assertEquals((String)"testKey", (String)entry.getKey());
    }
}

