/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite10
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;
    private static final String TARGET_RUNTIME_VALIDATOR_ID = "org.eclipse.wst.common.tests.validation.TargetRuntimeValidator";
    private static final String TARGET_RUNTIME = "targetRuntime";
    private static final String RULES = "rules";
    private static final String ID = "id";

    public static Test suite() {
        return new TestSuite(TestSuite10.class);
    }

    public TestSuite10(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._project = this._env.createProject("TestSuite10");
        TestEnvironment.enableOnlyTheseValidators("T10");
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testTargetRuntimeFilterRule() throws CoreException, UnsupportedEncodingException, InterruptedException {
        IConfigurationElement[] children;
        String ruleName = null;
        String ruleID = null;
        IConfigurationElement[] iConfigurationElementArray = children = this.getIncludesAndExcludes(TARGET_RUNTIME_VALIDATOR_ID);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            IConfigurationElement[] rules = child.getChildren(RULES);
            int i = 0;
            while (i < rules.length) {
                IConfigurationElement[] r = rules[i].getChildren();
                int j = 0;
                while (j < r.length) {
                    IConfigurationElement rule = r[j];
                    ruleName = rule.getName();
                    if (ruleName.equals(TARGET_RUNTIME)) {
                        FilterRule filterRule = FilterRule.create((IConfigurationElement)rule);
                        TestSuite10.assertNotNull((Object)filterRule);
                        ruleID = rule.getAttribute(ID);
                        TestSuite10.assertNotNull((Object)ruleName);
                        TestSuite10.assertNotNull((Object)ruleID);
                    }
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
    }

    private IConfigurationElement[] getIncludesAndExcludes(String validatorID) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "validatorV2");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement validator = iConfigurationElementArray[n4];
                String id = ext.getUniqueIdentifier();
                if (id.equals(validatorID)) {
                    return validator.getChildren();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

