/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.WebServiceRef;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;

public class UpdateMemberValuePairTest
extends AbstractAnnotationTest {
    @Override
    protected Annotation getAnnotation() {
        return null;
    }

    @Override
    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n");
        classContents.append("import javax.jws.WebMethod;\n");
        classContents.append("import javax.jws.WebParam;\n");
        classContents.append("import javax.xml.ws.WebServiceRef;\n\n");
        classContents.append("@WebService(name=\"Calculator\")\n");
        classContents.append("public class Calculator {\n\n");
        classContents.append("\t@WebServiceRef(mappedName=\"myField\")\n");
        classContents.append("\tpublic String myField;\n\n");
        classContents.append("\t@WebMethod(operationName=\"add\")\n");
        classContents.append("\tpublic int add(@WebParam(partName=\"i\") int i, int k) {");
        classContents.append("\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    @Override
    protected String getClassName() {
        return "Calculator.java";
    }

    @Override
    protected String getPackageName() {
        return "com.example";
    }

    public void testUpdateMemberValuePair() {
        try {
            IType type = this.source.findPrimaryType();
            UpdateMemberValuePairTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)"WebService"));
            Annotation webService = AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            UpdateMemberValuePairTest.assertNotNull((Object)webService);
            UpdateMemberValuePairTest.assertTrue((boolean)(webService instanceof NormalAnnotation));
            NormalAnnotation webServiceAnnotation = (NormalAnnotation)webService;
            UpdateMemberValuePairTest.assertTrue((webServiceAnnotation.values().size() == 1 ? 1 : 0) != 0);
            MemberValuePair nameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webServiceAnnotation, (String)"name");
            UpdateMemberValuePairTest.assertNotNull((Object)nameValuePair);
            StringLiteral nameValue = (StringLiteral)nameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)nameValue.getLiteralValue().equals("Calculator"));
            AnnotationUtils.updateMemberValuePair((MemberValuePair)nameValuePair, (ASTNode)AnnotationsCore.createStringLiteral((AST)this.ast, (String)"ScientificCalculator"));
            webServiceAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)type, WebService.class);
            nameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webServiceAnnotation, (String)"name");
            nameValue = (StringLiteral)nameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)nameValue.getLiteralValue().equals("ScientificCalculator"));
            IField field = type.getField("myField");
            UpdateMemberValuePairTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)"WebServiceRef"));
            Annotation webServiceRef = AnnotationUtils.getAnnotation((IJavaElement)field, WebServiceRef.class);
            UpdateMemberValuePairTest.assertNotNull((Object)webServiceRef);
            UpdateMemberValuePairTest.assertTrue((boolean)(webServiceRef instanceof NormalAnnotation));
            NormalAnnotation webServiceRefAnnotation = (NormalAnnotation)webServiceRef;
            UpdateMemberValuePairTest.assertTrue((webServiceRefAnnotation.values().size() == 1 ? 1 : 0) != 0);
            MemberValuePair mappedNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webServiceRefAnnotation, (String)"mappedName");
            UpdateMemberValuePairTest.assertNotNull((Object)mappedNameValuePair);
            StringLiteral mappedNameValue = (StringLiteral)mappedNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)mappedNameValue.getLiteralValue().equals("myField"));
            AnnotationUtils.updateMemberValuePair((MemberValuePair)mappedNameValuePair, (ASTNode)AnnotationsCore.createStringLiteral((AST)this.ast, (String)"anotherField"));
            webServiceRefAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)field, WebServiceRef.class);
            mappedNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webServiceRefAnnotation, (String)"mappedName");
            mappedNameValue = (StringLiteral)mappedNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)mappedNameValue.getLiteralValue().equals("anotherField"));
            IMethod method = type.getMethod("add", new String[]{"I", "I"});
            UpdateMemberValuePairTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)"WebMethod"));
            Annotation webMethod = AnnotationUtils.getAnnotation((IJavaElement)method, WebMethod.class);
            UpdateMemberValuePairTest.assertNotNull((Object)webMethod);
            UpdateMemberValuePairTest.assertTrue((boolean)(webMethod instanceof NormalAnnotation));
            NormalAnnotation webMethodAnnotation = (NormalAnnotation)webMethod;
            UpdateMemberValuePairTest.assertTrue((webMethodAnnotation.values().size() == 1 ? 1 : 0) != 0);
            MemberValuePair operationNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webMethodAnnotation, (String)"operationName");
            UpdateMemberValuePairTest.assertNotNull((Object)operationNameValuePair);
            StringLiteral operationNameValue = (StringLiteral)operationNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)operationNameValue.getLiteralValue().equals("add"));
            AnnotationUtils.updateMemberValuePair((MemberValuePair)operationNameValuePair, (ASTNode)AnnotationsCore.createStringLiteral((AST)this.ast, (String)"multiply"));
            webMethodAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)method, WebMethod.class);
            operationNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webMethodAnnotation, (String)"operationName");
            operationNameValue = (StringLiteral)operationNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)operationNameValue.getLiteralValue().equals("multiply"));
            ILocalVariable localVariable = AnnotationUtils.getLocalVariable((IMethod)method, (String)"i");
            UpdateMemberValuePairTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)localVariable, (String)"WebParam"));
            Annotation webParam = AnnotationUtils.getAnnotation((IJavaElement)localVariable, WebParam.class);
            UpdateMemberValuePairTest.assertNotNull((Object)webParam);
            UpdateMemberValuePairTest.assertTrue((boolean)(webParam instanceof NormalAnnotation));
            NormalAnnotation webParamAnnotation = (NormalAnnotation)webParam;
            UpdateMemberValuePairTest.assertTrue((webParamAnnotation.values().size() == 1 ? 1 : 0) != 0);
            MemberValuePair partNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webParamAnnotation, (String)"partName");
            UpdateMemberValuePairTest.assertNotNull((Object)partNameValuePair);
            StringLiteral partNameValue = (StringLiteral)partNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)partNameValue.getLiteralValue().equals("i"));
            AnnotationUtils.updateMemberValuePair((MemberValuePair)partNameValuePair, (ASTNode)AnnotationsCore.createStringLiteral((AST)this.ast, (String)"iii"));
            webParamAnnotation = (NormalAnnotation)AnnotationUtils.getAnnotation((IJavaElement)localVariable, WebParam.class);
            partNameValuePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)webParamAnnotation, (String)"partName");
            partNameValue = (StringLiteral)partNameValuePair.getValue();
            UpdateMemberValuePairTest.assertTrue((boolean)partNameValue.getLiteralValue().equals("iii"));
        }
        catch (CoreException ce) {
            UpdateMemberValuePairTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

