/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockResource;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEvent;
import org.eclipse.jst.jsf.test.util.mock.MockResourceDelta;
import org.eclipse.jst.jsf.test.util.mock.MockResourceDeltaFactory;

public class MockResourceChangeEventFactory {
    private final MockResourceDeltaFactory _deltaFactory;

    public MockResourceChangeEventFactory(MockResourceDeltaFactory deltaFactory) {
        this._deltaFactory = deltaFactory;
    }

    public MockResourceChangeEventFactory(IWorkspaceContext wsContext) {
        this(new MockResourceDeltaFactory(wsContext));
    }

    public IResourceChangeEvent createSimpleFileChange(IFile file, boolean incrementModStamp) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileChange(file);
        if (incrementModStamp && file instanceof MockFile) {
            ((MockResource)file).incrementModStamp();
        }
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileRemove(IFile file) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileRemoved(file);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileAdded(IFile file) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFileAdded(file);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleProjectClosed(IProject project) {
        return new MockResourceChangeEvent((IResource)project, 2, null);
    }

    public IResourceChangeEvent createSimpleProjectDeleted(IProject project) {
        return new MockResourceChangeEvent((IResource)project, 4, null);
    }

    public IResourceChangeEvent createSimpleFolderAdded(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFolderAdded(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFolderDeleted(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createSimpleFolderRemoved(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createRecursiveFolderDeleted(IFolder folder) {
        MockResourceDelta delta = this._deltaFactory.createRecursiveFolderRemoved(folder);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFolderRename(IFolder folder, IFolder newFolderName) {
        MockResourceDelta delta = this._deltaFactory.createFolderRename(folder, newFolderName);
        return this.newPostChangeEvent(delta);
    }

    public IResourceChangeEvent createSimpleFileRename(IFile file, IFile newFile) {
        MockResourceDelta delta = this._deltaFactory.createFileRename(file, newFile);
        return this.newPostChangeEvent(delta);
    }

    private MockResourceChangeEvent newPostChangeEvent(MockResourceDelta delta) {
        return new MockResourceChangeEvent(1, delta);
    }
}

