/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public class TestEventHandler
implements Runnable {
    private DebugSession debugSession;
    private Thread thread;
    private final List subhandlers = new ArrayList();
    private final ArrayList expectedEvents = new ArrayList();
    private final ArrayList actualEvents = new ArrayList();
    private volatile boolean shutdown = false;
    private int eventCount = 0;
    private String testname = null;

    public TestEventHandler(DebugSession debugSession, String testname) {
        this.debugSession = debugSession;
        this.thread = new Thread((Runnable)this, "TestEventHandler");
        this.testname = testname;
    }

    public void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.shutdown = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestEventHandler testEventHandler = this;
        synchronized (testEventHandler) {
            this.expectedEvents.clear();
            this.actualEvents.clear();
            this.subhandlers.clear();
            this.eventCount = 0;
        }
    }

    public synchronized void setExpectedEvents(EventPacket[] events) {
        this.expectedEvents.clear();
        int i = 0;
        while (i < events.length) {
            this.expectedEvents.add(events[i]);
            ++i;
        }
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                EventPacket event = (EventPacket)this.debugSession.receive("event", 30000);
                this.handleEvent(event);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (DisconnectedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addSubhandler(Subhandler subhandler) {
        this.subhandlers.add(subhandler);
    }

    public synchronized void removeSubhandler(Subhandler subhandler) {
        this.subhandlers.remove(subhandler);
    }

    private synchronized void handleEvent(EventPacket event) {
        String estring = null;
        if (RequestTest.isTracing()) {
            estring = JSONUtil.write((Object)event.toJSON());
            System.out.println(String.valueOf(this.testname) + " got event: " + estring);
        }
        ListIterator iterator = this.subhandlers.listIterator();
        while (iterator.hasNext()) {
            Subhandler subhandler = (Subhandler)iterator.next();
            try {
                if (!subhandler.handleEvent(this.debugSession, event)) continue;
                if (RequestTest.isTracing()) {
                    System.out.println("\t" + this.testname + " handled event: " + estring);
                }
                this.expectedEvents.remove(event);
                this.actualEvents.add(event);
                ++this.eventCount;
                this.notifyAll();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!event.getEvent().equals("thread")) {
            this.sendContinue(event, null);
        }
    }

    protected void sendContinue(EventPacket event, String step) {
        block4: {
            Number threadId = (Number)event.getBody().get("threadId");
            RhinoRequest request = new RhinoRequest("continue");
            request.getArguments().put("threadId", threadId);
            request.getArguments().put("step", step);
            try {
                this.debugSession.send((Packet)request);
                this.debugSession.receiveResponse(request.getSequence(), 30000);
            }
            catch (DisconnectedException e) {
                if (!this.shutdown) {
                    e.printStackTrace();
                }
            }
            catch (TimeoutException e) {
                if (this.shutdown) break block4;
                e.printStackTrace();
            }
        }
    }

    public synchronized void waitForEvents(int count) {
        long timeout = System.currentTimeMillis() + 5000L;
        while (this.eventCount < count && System.currentTimeMillis() < timeout) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.eventCount != count) {
                Iterator it = this.actualEvents.iterator();
                while (it.hasNext()) {
                    System.err.println(it.next().toString());
                }
                throw new IllegalStateException("eventcount was: " + this.eventCount + " expected: " + count);
            }
        }
        finally {
            this.eventCount = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void waitForEvents(EventPacket[] events) {
        timeout = System.currentTimeMillis() + 5000L;
        while (!this.expectedEvents.isEmpty() && System.currentTimeMillis() < timeout) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!this.expectedEvents.isEmpty()) {
            try {
                throw new IllegalStateException("Some expected events were not received");
            }
            catch (Throwable var4_4) {
                this.eventCount = 0;
                i = 0;
                ** while (i < this.expectedEvents.size())
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(String.valueOf(this.testname) + " missed expected event: " + JSONUtil.write(this.expectedEvents.get(i)));
                ++i;
                continue;
            }
lbl19:
            // 1 sources

            throw var4_4;
        }
        if (this.eventCount > events.length) {
            try {
                throw new IllegalStateException(String.valueOf(this.testname) + " got too many events - expected [" + events.length + "] got [" + this.eventCount + "]");
            }
            catch (Throwable var4_5) {
                this.eventCount = 0;
                throw var4_5;
            }
        }
    }

    public static interface BreakpointSubHandler
    extends Subhandler {
        public void linesToAddBreakpoints(int[] var1);

        public void linesToRemoveBreakpoints(int[] var1);
    }

    public static interface Subhandler {
        public boolean handleEvent(DebugSession var1, EventPacket var2);

        public String testName();
    }
}

