/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.navigator;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.DOMAdapterFactoryContentProvider;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ILoadingWsProject;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.ui.DomItemProviderAdapterFactory;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;

public class DOMAdapterFactoryContentProviderTest
extends TestCase {
    private TestProject testPrj1;
    private IPackageFragment modelSync1;
    private IWebServiceProject wsProject;
    protected JaxWsWorkspaceResource targetResource;
    protected DOMAdapterFactoryContentProvider adapterFactory;
    private DomUtil domUtil;

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        IProject ejbProject = TestProjectsUtils.createEjb3Project((String)("DOMCntProvTestProject1" + System.currentTimeMillis()));
        this.testPrj1 = new TestProject(ejbProject.getProject());
        this.modelSync1 = this.testPrj1.createPackage("org.eclipse.test.modelsync1");
        this.testPrj1.createType(this.modelSync1, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1{\n@javax.jws.WebMethod(name=\"parentMethod\") public void voidMethodWithNoArgsInParent();\n}");
        this.testPrj1.createType(this.modelSync1, "Sei2.java", "@javax.jws.WebService(name=\"Sei2Name\") public interface Sei2 extends Sei1 {\n@javax.jws.WebMethod(name=\"voidMethodWithArgs\") public void voidMethodWithArgs(@javax.jws.WebParam(name=\"param1\") java.util.List<String> param1);\n}");
        this.testPrj1.createType(this.modelSync1, "WS1.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"org.eclipse.test.modelsync1.Sei2\") public class WS1 {}");
        this.testPrj1.createType(this.modelSync1, "WS2.java", "@javax.jws.WebService(serviceName=\"WS2Name\") public class WS2 {}");
        this.targetResource = new JaxWsWorkspaceResource(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.targetResource.load(null);
        this.wsProject = this.domUtil.findProjectByName(this.targetResource.getDOM(), this.testPrj1.getProject().getName());
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)this.wsProject);
        this.adapterFactory = new DOMAdapterFactoryContentProvider(){

            protected IWebServiceProject getWsProject(IDOM dom, IProject project) {
                return DOMAdapterFactoryContentProviderTest.this.wsProject;
            }
        };
        this.targetResource.startSynchronizing();
    }

    public void tearDown() throws CoreException {
        this.targetResource.stopSynchronizing();
        this.testPrj1.dispose();
    }

    public void testDOMAdapterFactoryContentProvider() {
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)this.adapterFactory.getAdapterFactory());
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(this.adapterFactory.getAdapterFactory() instanceof DomItemProviderAdapterFactory));
    }

    public void testDOMAdapterFactoryContentProviderAdapterFactory() {
        this.adapterFactory = new DOMAdapterFactoryContentProvider((AdapterFactory)new DomItemProviderAdapterFactory());
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)this.adapterFactory.getAdapterFactory());
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(this.adapterFactory.getAdapterFactory() instanceof DomItemProviderAdapterFactory));
    }

    public void testGetChildrenListsObject() {
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)children);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)children.length, (int)1);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[0] instanceof IWebServiceProject));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)children);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)children.length, (int)2);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[0] instanceof ISEIChildList));
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[1] instanceof IWebServiceChildList));
        Object[] sEIs = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)sEIs);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)3, (int)sEIs.length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(sEIs[0] instanceof IServiceEndpointInterface));
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(sEIs[1] instanceof IServiceEndpointInterface));
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(sEIs[2] instanceof IServiceEndpointInterface));
        Object[] wSs = this.adapterFactory.getChildren(children[1]);
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)wSs);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)wSs.length, (int)2);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(wSs[0] instanceof IWebService));
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(wSs[1] instanceof IWebService));
    }

    public void testHasChildrenObject() {
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren(children[0]));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren(children[0]));
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren(children[1]));
        DOMAdapterFactoryContentProviderTest.assertFalse((boolean)this.adapterFactory.hasChildren(null));
    }

    public void testChildrenIWebService() {
        IWebService ws = this.findWs("org.eclipse.test.modelsync1.WS1");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)ws);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren((Object)ws));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)1, (int)this.adapterFactory.getChildren((Object)ws).length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(this.adapterFactory.getChildren((Object)ws)[0] instanceof IServiceEndpointInterface));
        DOMAdapterFactoryContentProvider otherFactory = new DOMAdapterFactoryContentProvider();
        otherFactory.getChildren((Object)ws);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)2, (int)ws.eAdapters().size());
    }

    public void testChildrenIServiceEndpointInterface() {
        IServiceEndpointInterface sei = this.findSei("org.eclipse.test.modelsync1.Sei2");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)sei);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren((Object)sei));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)2, (int)this.adapterFactory.getChildren((Object)sei).length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(this.adapterFactory.getChildren((Object)sei)[0] instanceof IWebMethod));
        DOMAdapterFactoryContentProvider otherFactory = new DOMAdapterFactoryContentProvider();
        otherFactory.getChildren((Object)sei);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)2, (int)sei.eAdapters().size());
        IWebService ws = this.findWs("org.eclipse.test.modelsync1.WS2");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)ws);
        DOMAdapterFactoryContentProviderTest.assertFalse((boolean)this.adapterFactory.hasChildren((Object)ws.getServiceEndpoint()));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)0, (int)this.adapterFactory.getChildren((Object)ws.getServiceEndpoint()).length);
        otherFactory.getChildren((Object)ws.getServiceEndpoint());
        DOMAdapterFactoryContentProviderTest.assertEquals((int)2, (int)ws.getServiceEndpoint().eAdapters().size());
    }

    public void testChildrenWebMethod() {
        IServiceEndpointInterface sei = this.findSei("org.eclipse.test.modelsync1.Sei2");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)sei);
        IWebMethod method = this.findMethod(sei, "voidMethodWithArgs");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)method);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)this.adapterFactory.hasChildren((Object)method));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)1, (int)this.adapterFactory.getChildren((Object)method).length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(this.adapterFactory.getChildren((Object)method)[0] instanceof IWebParam));
        method = this.findMethod(sei, "voidMethodWithNoArgsInParent");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)method);
        DOMAdapterFactoryContentProviderTest.assertFalse((boolean)this.adapterFactory.hasChildren((Object)method));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)0, (int)this.adapterFactory.getChildren((Object)method).length);
    }

    public void testChildrenWebParam() {
        IServiceEndpointInterface sei = this.findSei("org.eclipse.test.modelsync1.Sei2");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)sei);
        IWebMethod method = this.findMethod(sei, "voidMethodWithArgs");
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)method);
        DOMAdapterFactoryContentProviderTest.assertFalse((boolean)this.adapterFactory.hasChildren(method.getParameters().get(0)));
        DOMAdapterFactoryContentProviderTest.assertEquals((int)0, (int)this.adapterFactory.getChildren(method.getParameters().get(0)).length);
    }

    private IServiceEndpointInterface findSei(String implName) {
        for (IServiceEndpointInterface sei : this.wsProject.getServiceEndpointInterfaces()) {
            if (!sei.getImplementation().equals(implName)) continue;
            return sei;
        }
        return null;
    }

    private IWebService findWs(String implName) {
        for (IWebService ws : this.wsProject.getWebServices()) {
            if (!ws.getImplementation().equals(implName)) continue;
            return ws;
        }
        return null;
    }

    private IWebMethod findMethod(IServiceEndpointInterface sei, String methodName) {
        for (IWebMethod method : sei.getWebMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public void testGetWSProject() {
        this.adapterFactory = new DOMAdapterFactoryContentProvider();
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)children);
    }

    public void testGetWsProjectDomNotLoaded() {
        this.adapterFactory = new DOMAdapterFactoryContentProvider(){

            protected IWebServiceProject getWsProject(IDOM dom, IProject project) {
                return null;
            }
        };
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryContentProviderTest.assertEquals((int)1, (int)children.length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[0] instanceof ILoadingWsProject));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)1, (int)children.length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[0] instanceof ILoadingWsProject.ILoadingDummy));
    }

    public void testGetWsProjectChildsDomNotLoaded() {
        ILoadingWsProject loadingProject = new ILoadingWsProject(){

            public IProject getProject() {
                return DOMAdapterFactoryContentProviderTest.this.testPrj1.getProject();
            }
        };
        Object[] children = this.adapterFactory.getChildren((Object)loadingProject);
        DOMAdapterFactoryContentProviderTest.assertEquals((int)1, (int)children.length);
        DOMAdapterFactoryContentProviderTest.assertTrue((boolean)(children[0] instanceof ILoadingWsProject.ILoadingDummy));
    }

    public void testGetSupportingRuntime() {
        DOMAdapterFactoryContentProviderMy provider = new DOMAdapterFactoryContentProviderMy();
        IWsDOMRuntimeExtension runtime = provider.getSupportingRuntime(this.testPrj1.getProject());
        DOMAdapterFactoryContentProviderTest.assertNotNull((Object)runtime);
    }

    protected class DOMAdapterFactoryContentProviderMy
    extends DOMAdapterFactoryContentProvider {
        protected DOMAdapterFactoryContentProviderMy() {
        }

        public IWsDOMRuntimeExtension getSupportingRuntime(IProject project) {
            return super.getSupportingRuntime(project);
        }
    }
}

