/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.laf.BaselineSupportHelper;
import org.eclipse.wb.internal.layout.group.model.GroupLayoutUtils;
import org.eclipse.wb.internal.layout.group.model.IGroupLayoutInfo;
import org.eclipse.wb.internal.swing.java6.model.GroupLayoutInfo2;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

public class SwingVisualMapper
implements VisualMapper {
    private static final int DEFAULT_MIN_SIZE = 25;
    private GroupLayoutInfo2 m_layout;

    public SwingVisualMapper(GroupLayoutInfo2 layout) {
        this.m_layout = layout;
        this.m_layout.addBroadcastListener(new JavaEventListener(){

            public void replaceChildAfter(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                if (oldChild == SwingVisualMapper.this.m_layout) {
                    SwingVisualMapper.this.m_layout = (GroupLayoutInfo2)newChild;
                }
            }
        });
    }

    public int getBaselinePosition(String componentId, int width, int height) {
        return BaselineSupportHelper.getBaseline((Object)this.getComponent(componentId));
    }

    public Rectangle getComponentBounds(String componentId) {
        ComponentInfo componentInfo = this.getComponentInfo(componentId);
        return GroupLayoutUtils.getBoundsInLayout((IGroupLayoutInfo)this.m_layout.getAdapter(IGroupLayoutInfo.class), (IAbstractComponentInfo)componentInfo);
    }

    public Dimension getComponentMinimumSize(String componentId) {
        Component component = this.getComponent(componentId);
        if (component == null) {
            return new Dimension(25, 25);
        }
        return component.getMinimumSize();
    }

    public Dimension getComponentPreferredSize(String componentId) {
        Component component = this.getComponent(componentId);
        return component.getPreferredSize();
    }

    public Rectangle getContainerInterior(String componentId) {
        org.eclipse.draw2d.geometry.Rectangle bounds = this.getContainer().getModelBounds().getCopy();
        bounds.shrink(this.getContainer().getInsets());
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public int getPreferredPadding(String component1Id, String component2Id, int dimension, int comp2Alignment, LayoutConstants.PaddingType paddingType) {
        JComponent jcomp2;
        Component comp1 = this.getComponent(component1Id);
        Component comp2 = this.getComponent(component2Id);
        JComponent jcomp1 = comp1 instanceof JComponent ? (JComponent)comp1 : null;
        JComponent jComponent = jcomp2 = comp2 instanceof JComponent ? (JComponent)comp2 : null;
        assert (dimension == 0 || dimension == 1);
        assert (comp2Alignment == 0 || comp2Alignment == 1);
        LayoutStyle.ComponentPlacement type = paddingType == LayoutConstants.PaddingType.INDENT ? LayoutStyle.ComponentPlacement.INDENT : (paddingType == LayoutConstants.PaddingType.RELATED ? LayoutStyle.ComponentPlacement.RELATED : LayoutStyle.ComponentPlacement.UNRELATED);
        int position = 0;
        if (dimension == 0) {
            position = paddingType == LayoutConstants.PaddingType.INDENT ? (comp2Alignment == 0 ? 7 : 3) : (comp2Alignment == 0 ? 3 : 7);
        } else {
            int n = position = comp2Alignment == 0 ? 5 : 1;
        }
        if (jcomp1 == null || jcomp2 == null) {
            return type != LayoutStyle.ComponentPlacement.UNRELATED ? 6 : 12;
        }
        int prefPadding = paddingType != LayoutConstants.PaddingType.SEPARATE ? LayoutStyle.getInstance().getPreferredGap(jcomp1, jcomp2, type, position, this.getContainer().getContainer()) : 18;
        return prefPadding;
    }

    public void setComponentVisibility(String componentId, boolean visible) {
    }

    public int getPreferredPaddingInParent(String parentId, String componentId, int dimension, int compAlignment) {
        int alignment = dimension == 0 ? (compAlignment == 0 ? 7 : 3) : (compAlignment == 0 ? 1 : 5);
        Component component = this.getComponent(componentId);
        if (component instanceof JComponent) {
            return LayoutStyle.getInstance().getContainerGap((JComponent)component, alignment, this.getContainer().getContainer());
        }
        return 6;
    }

    public boolean hasExplicitPreferredSize(String componentId) {
        ComponentInfo componentInfo = this.getComponentInfo(componentId);
        Component component = componentInfo.getComponent();
        if (JTextComponent.class.isAssignableFrom(componentInfo.getDescription().getComponentClass())) {
            return true;
        }
        if (component == null) {
            return false;
        }
        return component.isPreferredSizeSet();
    }

    public void rebuildLayout(String containerId) {
    }

    public boolean[] getComponentResizability(String compId, boolean[] resizability) {
        return null;
    }

    private Component getComponent(String id) {
        ComponentInfo componentInfo = this.getComponentInfo(id);
        return componentInfo.getComponent();
    }

    private ComponentInfo getComponentInfo(String id) {
        return (ComponentInfo)ObjectInfoUtils.getById((String)id);
    }

    private ContainerInfo getContainer() {
        return this.m_layout.getContainer();
    }
}

