/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class PropertyCategoryTest
extends SwingModelTest {
    @Test
    public void test_is() throws Exception {
        PropertyCategoryTest.assertTrue((boolean)PropertyCategory.PREFERRED.isPreferred());
        PropertyCategoryTest.assertTrue((boolean)PropertyCategory.ADVANCED.isAdvanced());
        PropertyCategoryTest.assertTrue((boolean)PropertyCategory.ADVANCED_REALLY.isAdvancedReally());
        PropertyCategoryTest.assertTrue((boolean)PropertyCategory.HIDDEN.isHidden());
        PropertyCategory systemCategory = PropertyCategory.system((int)10);
        PropertyCategoryTest.assertTrue((boolean)systemCategory.isSystem());
        PropertyCategoryTest.assertEquals((int)1010, (int)systemCategory.getPriority());
    }

    @Test
    public void test_system() throws Exception {
        PropertyCategory category = PropertyCategory.system((int)10);
        PropertyCategoryTest.assertTrue((boolean)category.isSystem());
        PropertyCategoryTest.assertEquals((int)1010, (int)category.getPriority());
        PropertyCategory categoryAdd = PropertyCategory.system((PropertyCategory)category, (int)5);
        PropertyCategoryTest.assertTrue((boolean)categoryAdd.isSystem());
        PropertyCategoryTest.assertEquals((int)1015, (int)categoryAdd.getPriority());
    }

    @Test
    public void test_toString() throws Exception {
        PropertyCategoryTest.assertEquals((Object)"PREFERRED", (Object)PropertyCategory.PREFERRED.toString());
        PropertyCategoryTest.assertEquals((Object)"NORMAL", (Object)PropertyCategory.NORMAL.toString());
        PropertyCategoryTest.assertEquals((Object)"ADVANCED", (Object)PropertyCategory.ADVANCED.toString());
        PropertyCategoryTest.assertEquals((Object)"ADVANCED_REALLY", (Object)PropertyCategory.ADVANCED_REALLY.toString());
        PropertyCategoryTest.assertEquals((Object)"HIDDEN", (Object)PropertyCategory.HIDDEN.toString());
        PropertyCategoryTest.assertEquals((Object)"SYSTEM:10", (Object)PropertyCategory.system((int)10).toString());
    }

    @Test
    public void test_equals() throws Exception {
        PropertyCategoryTest.assertEquals((Object)PropertyCategory.PREFERRED, (Object)PropertyCategory.PREFERRED);
        PropertyCategoryTest.assertEquals((Object)PropertyCategory.ADVANCED, (Object)PropertyCategory.ADVANCED);
        PropertyCategoryTest.assertEquals((Object)PropertyCategory.system((int)10), (Object)PropertyCategory.system((int)10));
        PropertyCategoryTest.assertFalse((boolean)PropertyCategory.PREFERRED.equals((Object)PropertyCategory.ADVANCED));
        PropertyCategoryTest.assertFalse((boolean)PropertyCategory.system((int)10).equals((Object)PropertyCategory.system((int)11)));
        PropertyCategoryTest.assertFalse((boolean)PropertyCategory.PREFERRED.equals((Object)this));
    }

    @Test
    public void test_hashCode() throws Exception {
        PropertyCategory category = PropertyCategory.PREFERRED;
        PropertyCategoryTest.assertEquals((int)category.getPriority(), (int)category.hashCode());
    }

    @Test
    public void test_get() throws Exception {
        PropertyCategoryTest.assertSame((Object)PropertyCategory.NORMAL, (Object)PropertyCategory.get((String)"normal", null));
        PropertyCategoryTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)PropertyCategory.get((String)"preferred", null));
        PropertyCategoryTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)PropertyCategory.get((String)"advanced", null));
        PropertyCategoryTest.assertSame((Object)PropertyCategory.ADVANCED_REALLY, (Object)PropertyCategory.get((String)"advanced-really", null));
        PropertyCategoryTest.assertSame((Object)PropertyCategory.HIDDEN, (Object)PropertyCategory.get((String)"hidden", null));
        PropertyCategoryTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)PropertyCategory.get((String)"NoSuchCategory", (PropertyCategory)PropertyCategory.ADVANCED));
        PropertyCategory category = PropertyCategory.get((String)"system(5)", null);
        PropertyCategoryTest.assertTrue((boolean)category.isSystem());
        PropertyCategoryTest.assertEquals((int)1005, (int)category.getPriority());
        category = PropertyCategory.get((String)"system(bad)", (PropertyCategory)PropertyCategory.ADVANCED);
        PropertyCategoryTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)category);
        category = PropertyCategory.get((String)"bad", (PropertyCategory)PropertyCategory.ADVANCED);
        PropertyCategoryTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)category);
        try {
            PropertyCategory.get((String)"bad", null);
            PropertyCategoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

