/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.assertj.core.api.Assertions;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.ApplicationWindowInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ToolBarManagerInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ApplicationWindowTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createContents(Composite parent) {", "    Composite container = (Composite) super.createContents(parent);", "    Button button = new Button(container, SWT.NONE);", "    return container;", "  }", "}");
        ApplicationWindowTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}", "  {parameter} {parent} {/super.createContents(parent)/}", "    {casted-superInvocation: (Composite)super.createContents(parent)} {local-unique: container} {/(Composite) super.createContents(parent)/ /new Button(container, SWT.NONE)/ /container/}", "      {implicit-layout: absolute} {implicit-layout} {}", "      {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(container, SWT.NONE)/}");
    }

    @Test
    public void test_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseSource("test", "Test.java", ApplicationWindowTest.getSourceDQ("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "  }", "}"));
        ApplicationWindowTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_ignoreMethod_close() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseSource("test", "Test.java", ApplicationWindowTest.getSource("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "  }", "  public boolean close() {", "    return false;", "  }", "}"));
        window.refresh();
        Shell shell = window.getComponentObject();
        ReflectionUtils.invokeMethod((Object)window.getObject(), (String)"close()", (Object[])new Object[0]);
        ApplicationWindowTest.assertTrue((boolean)shell.isDisposed());
    }

    @Disabled
    @Test
    public void test_managers_ToolBarManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolBarManager = super.createToolBarManager(style);", "    return toolBarManager;", "  }", "}");
        window.refresh();
        ApplicationWindowTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addToolBar(SWT.FLAT)/}", "  {superInvocation: super.createToolBarManager(style)} {local-unique: toolBarManager} {/super.createToolBarManager(style)/ /toolBarManager/}");
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ApplicationWindowTest.assertEquals((Object)"org.eclipse.jface.action.ToolBarManager", (Object)toolBarManager.getObject().getClass().getName());
        ApplicationWindowTest.assertEquals((Object)"org.eclipse.swt.widgets.ToolBar", (Object)toolBarManager.getComponentObject().getClass().getName());
        ApplicationWindowTest.assertNotNull((Object)toolBarManager.getImage());
        ApplicationWindowTest.assertNotNull((Object)toolBarManager.getBounds());
        Assertions.assertThat((int)toolBarManager.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)toolBarManager.getBounds().height).isGreaterThan(20);
    }

    @Test
    public void test_managers_ignoreDangling() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = new MenuManager();", "    MenuManager dangling = new MenuManager();", "    return menuManager;", "  }", "}");
        ApplicationWindowTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addMenuBar()/}", "  {new: org.eclipse.jface.action.MenuManager} {local-unique: menuManager} {/new MenuManager()/ /menuManager/}");
        this.refresh();
    }
}

