/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.gef.tree.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.tree.TreeViewer;
import org.eclipse.wb.tests.gef.EventSender;
import org.eclipse.wb.tests.gef.GefTestCase;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class TreeToolTest
extends GefTestCase {
    protected Shell m_shell;
    protected EditDomain m_domain;
    protected TreeViewer m_viewer;
    protected EventSender m_sender;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_shell = new Shell();
        this.m_domain = new EditDomain(){

            public Tool getDefaultTool() {
                return null;
            }
        };
        this.m_viewer = new TreeViewer((Composite)this.m_shell, 770){

            public void expandAll() {
                super.expandAll();
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
        };
        this.m_viewer.getControl().setSize(500, 400);
        this.m_viewer.setEditDomain(this.m_domain);
        this.m_sender = new EventSender(this.m_viewer.getControl());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.m_shell.dispose();
        this.m_shell = null;
        this.m_domain = null;
        this.m_viewer = null;
        this.m_sender = null;
    }

    protected static final Point getBeforeLocation(TreeEditPart part) {
        Rectangle bounds = new Rectangle(part.getWidget().getBounds());
        Point location = bounds.getTop();
        ++location.y;
        return location;
    }

    protected static final Point getOnLocation(TreeEditPart part) {
        Rectangle bounds = new Rectangle(part.getWidget().getBounds());
        return bounds.getCenter();
    }

    protected static final Point getAfterLocation(TreeEditPart part) {
        Rectangle bounds = new Rectangle(part.getWidget().getBounds());
        Point location = bounds.getBottom();
        --location.y;
        return location;
    }

    protected static final void assertLoggers(RequestsLogger expectedLogger, RequestsLogger actualLogger) {
        actualLogger.assertEquals(expectedLogger);
        actualLogger.clear();
        expectedLogger.clear();
    }

    protected static final void refreshTreeParst(TreeEditPart part) throws Exception {
        ReflectionUtils.invokeMethod((Object)part, (String)"refreshVisuals()", (Object[])new Object[0]);
        for (EditPart child : part.getChildren()) {
            TreeToolTest.refreshTreeParst((TreeEditPart)child);
        }
    }

    protected final TreeEditPart addEditPart(EditPart parentEditPart, String name, RequestsLogger actualLogger, ILayoutEditPolicy ipolicy) throws Exception {
        RequestTreeEditPart editPart = new RequestTreeEditPart(name, actualLogger, ipolicy);
        if (this.m_viewer.getRootEditPart() == parentEditPart) {
            this.m_viewer.getRootEditPart().setContents((EditPart)editPart);
        } else {
            TreeToolTest.addChildEditPart(parentEditPart, (EditPart)editPart);
        }
        return editPart;
    }

    protected static interface ILayoutEditPolicy {
        public boolean isGoodReferenceChild(Request var1, EditPart var2);
    }

    private static final class RequestTreeEditPart
    extends TreeEditPart {
        private final String m_name;
        private final RequestsLogger m_logger;
        private final ILayoutEditPolicy m_ipolicy;

        public RequestTreeEditPart(String name, RequestsLogger logger, ILayoutEditPolicy ipolicy) {
            this.m_name = name;
            this.m_logger = logger;
            this.m_ipolicy = ipolicy;
            this.setModel(this.m_name);
        }

        protected void createEditPolicies() {
            super.createEditPolicies();
            if (this.m_ipolicy != null) {
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

                    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
                        return m_ipolicy.isGoodReferenceChild(request, editPart);
                    }

                    protected Command getPasteCommand(PasteRequest request, Object referenceObject) {
                        m_logger.log((EditPart)this, "getPasteCommand", (Request)request);
                        return null;
                    }

                    protected Command getMoveCommand(List<? extends EditPart> moveParts, Object referenceObject) {
                        m_logger.log((EditPart)this, "getMoveCommand(parts=" + String.valueOf(moveParts) + ", next=" + String.valueOf(referenceObject) + ")");
                        return null;
                    }

                    protected Command getCreateCommand(Object newObject, Object referenceObject) {
                        m_logger.log((EditPart)this, "getCreateCommand(object=" + String.valueOf(newObject) + ", next=" + String.valueOf(referenceObject) + ")");
                        return null;
                    }

                    protected Command getAddCommand(List<? extends EditPart> addParts, Object referenceObject) {
                        m_logger.log((EditPart)this, "getAddCommand(parts=" + String.valueOf(addParts) + ", next=" + String.valueOf(referenceObject) + ")");
                        return null;
                    }
                });
            }
        }

        public EditPart getTargetEditPart(Request request) {
            if (request instanceof SelectionRequest) {
                return this;
            }
            return super.getTargetEditPart(request);
        }

        public void performRequest(Request request) {
            this.m_logger.log((EditPart)this, "performRequest", request);
            super.performRequest(request);
        }

        protected void refreshVisuals() {
            this.getWidget().setText(this.m_name);
        }

        public String toString() {
            return this.m_name;
        }
    }
}

