/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;

public abstract class AbstractEditPartViewer
extends org.eclipse.gef.ui.parts.AbstractEditPartViewer
implements IEditPartViewer {
    private EditDomain m_domain;
    private IEditPartFactory m_factory;
    private MenuManager m_contextMenu;
    private List<EditPart> m_selectionList = new ArrayList<EditPart>();
    private EventListenerList m_eventTable;
    private EditPart m_selecting;

    public IEditPartFactory getEditPartFactory() {
        return this.m_factory;
    }

    public void setEditPartFactory(IEditPartFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public EditDomain getEditDomain() {
        return this.m_domain;
    }

    public void setEditDomain(EditDomain domain) {
        this.m_domain = domain;
    }

    public void setInput(Object model) {
        RootEditPart rootEditPart = this.getRootEditPart();
        org.eclipse.wb.gef.core.EditPart contentEditPart = this.m_factory.createEditPart((EditPart)rootEditPart, model);
        rootEditPart.setContents((EditPart)contentEditPart);
    }

    public MenuManager getContextMenu() {
        return this.m_contextMenu;
    }

    public void setContextMenu(MenuManager menu) {
        if (this.m_contextMenu != null && this.m_contextMenu != menu) {
            this.m_contextMenu.dispose();
        }
        this.m_contextMenu = menu;
        Control control = this.getControl();
        Menu menuWidget = this.m_contextMenu.createContextMenu(control);
        if (menuWidget.getShell() == control.getShell()) {
            control.setMenu(menuWidget);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().addListener(ISelectionChangedListener.class, (Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().removeListener(ISelectionChangedListener.class, (Object)listener);
    }

    public ISelection getSelection() {
        EditPart content;
        if (this.m_selectionList.isEmpty() && (content = this.getRootEditPart().getContents()) != null) {
            return new StructuredSelection((Object)content);
        }
        return new StructuredSelection(this.m_selectionList);
    }

    protected void fireSelectionChanged() {
        Iterator<ISelectionChangedListener> listeners = this.getListeners(ISelectionChangedListener.class);
        if (listeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            listeners.forEachRemaining(listener -> listener.selectionChanged(event));
        }
    }

    public void appendSelection(EditPart part) {
        EditPart primary;
        Assert.isNotNull((Object)part);
        if (!this.m_selectionList.isEmpty() && (primary = this.m_selectionList.get(this.m_selectionList.size() - 1)) != part) {
            try {
                this.m_selecting = part;
                primary.setSelected(1);
            }
            finally {
                this.m_selecting = null;
            }
        }
        try {
            this.m_selecting = part;
            this.m_selectionList.remove(part);
            this.m_selectionList.add(part);
            part.setSelected(2);
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    public void setSelection(ISelection selection) {
        try {
            List editParts = ((StructuredSelection)selection).toList();
            if (!editParts.isEmpty()) {
                this.m_selecting = (EditPart)editParts.get(0);
            }
            this.internalDeselectAll();
            Iterator I = editParts.iterator();
            while (I.hasNext()) {
                EditPart part = (EditPart)I.next();
                if (part == null) continue;
                this.m_selectionList.add(part);
                this.m_selecting = part;
                if (I.hasNext()) {
                    part.setSelected(1);
                    continue;
                }
                part.setSelected(2);
            }
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    public void select(EditPart part) {
        Assert.isNotNull((Object)part);
        if (this.m_selectionList.size() != 1 || this.m_selectionList.get(0) != part) {
            try {
                this.m_selectionList.add(part);
                this.m_selecting = part;
                this.internalDeselectAll();
                this.appendSelection(part);
            }
            finally {
                this.m_selecting = null;
            }
        }
    }

    public void deselect(EditPart part) {
        Assert.isNotNull((Object)part);
        this.m_selectionList.remove(part);
        part.setSelected(0);
        if (!this.m_selectionList.isEmpty()) {
            EditPart primary = this.m_selectionList.get(this.m_selectionList.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(List<? extends EditPart> editParts) {
        for (EditPart editPart : editParts) {
            Assert.isNotNull((Object)editPart);
            this.m_selectionList.remove(editPart);
            editPart.setSelected(0);
        }
        if (!this.m_selectionList.isEmpty()) {
            EditPart editPart = this.m_selectionList.get(this.m_selectionList.size() - 1);
            editPart.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        this.internalDeselectAll();
        this.fireSelectionChanged();
    }

    private void internalDeselectAll() {
        List<EditPart> selectionList = this.m_selectionList;
        this.m_selectionList = new ArrayList<EditPart>();
        for (EditPart part : selectionList) {
            part.setSelected(0);
        }
    }

    public List<? extends EditPart> getSelectedEditParts() {
        return this.m_selectionList;
    }

    private EventListenerList getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventListenerList();
        }
        return this.m_eventTable;
    }

    private <T> Iterator<T> getListeners(Class<T> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    public Control createControl(Composite parent) {
        return null;
    }
}

