/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.property.table.editparts.AbstractPropertyEditPart;
import org.eclipse.wb.internal.core.model.property.table.editparts.PropertyEditPart;

public final class PropertyRootEditPart
extends AbstractPropertyEditPart {
    public PropertyRootEditPart(List<PropertyTable.PropertyInfo> model) {
        this.setModel(model);
    }

    protected IFigure createFigure() {
        FlowLayout flowLayout = new FlowLayout(true);
        flowLayout.setMajorSpacing(0);
        LineBorder border = new LineBorder(COLOR_LINE){

            public void paint(IFigure f, Graphics g, Insets i) {
                super.paint(f, g, i);
                tempRect = 1.getPaintRectangle((IFigure)f, (Insets)i);
                this.drawExpandLines(g, tempRect);
                tempRect = 1.getPaintRectangle((IFigure)f, (Insets)i);
                g.drawLine(PropertyRootEditPart.this.getViewer().getSplitter(), 0, PropertyRootEditPart.this.getViewer().getSplitter(), 1.tempRect.height);
            }

            private void drawExpandLines(Graphics graphics, Rectangle clientArea) {
                int height = PropertyRootEditPart.this.getViewer().getRowHeight() - 1;
                int xOffset = PropertyRootEditPart.m_plusImage.getBounds().width / 2;
                int yOffset = (height - PropertyRootEditPart.m_plusImage.getBounds().width) / 2;
                List<PropertyTable.PropertyInfo> properties = PropertyRootEditPart.this.getModelChildren();
                graphics.setForegroundColor(COLOR_COMPLEX_LINE);
                int i = 0;
                while (i < properties.size()) {
                    PropertyTable.PropertyInfo propertyInfo = properties.get(i);
                    if (propertyInfo.isExpanded()) {
                        PropertyTable.PropertyInfo nextPropertyInfo;
                        int index;
                        int index2 = index = properties.indexOf(propertyInfo);
                        while (index2 < properties.size()) {
                            nextPropertyInfo = properties.get(index2);
                            if (nextPropertyInfo != propertyInfo && nextPropertyInfo.getLevel() <= propertyInfo.getLevel()) break;
                            ++index2;
                        }
                        if (--index2 > index) {
                            nextPropertyInfo = properties.get(index2);
                            PropertyEditPart editPart = PropertyRootEditPart.this.getViewer().getEditPartForModel(propertyInfo);
                            PropertyEditPart nextEditPart = PropertyRootEditPart.this.getViewer().getEditPartForModel(nextPropertyInfo);
                            if (editPart != null && nextEditPart != null) {
                                Rectangle bounds = editPart.getFigure().getBounds();
                                Rectangle nextBounds = nextEditPart.getFigure().getBounds();
                                int x = editPart.getTitleX() + xOffset;
                                int y1 = bounds.top() + height - yOffset;
                                int y2 = nextBounds.top() + PropertyRootEditPart.this.getViewer().getRowHeight() / 2;
                                graphics.drawLine(x, y1, x, y2);
                                graphics.drawLine(x, y2, x + PropertyRootEditPart.this.getViewer().getRowHeight() / 3, y2);
                            }
                        }
                    }
                    ++i;
                }
            }
        };
        this.figure = new Figure();
        this.figure.setBorder((Border)border);
        this.figure.setBackgroundColor(COLOR_BACKGROUND);
        this.figure.setLayoutManager((LayoutManager)flowLayout);
        this.figure.setOpaque(true);
        return this.figure;
    }

    public List<PropertyTable.PropertyInfo> getModel() {
        return (List)super.getModel();
    }

    protected List<PropertyTable.PropertyInfo> getModelChildren() {
        Object model = this.getModel();
        if (model == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(model);
    }
}

